package cn.com.duiba.thirdpartyvnew.dto.wdt;

import com.alibaba.fastjson.annotation.JSONField;
import com.alibaba.fastjson.annotation.JSONType;
import lombok.Data;

import java.math.BigDecimal;
import java.util.List;

/**
 * 旺店通旗舰版原始订单推送参数
 *
 * @author cgq
 * @date 2025-01-27
 */
@Data
@JSONType(orders = {"shopNo", "rawTradeList", "rawTradeOrderList", "discountList"})
public class SalesRawTradePushSelfParam {

    /**
     * 店铺编号
     */
    @JSONField(name = "shop_no")
    private String shopNo;

    /**
     * 原始单信息
     */
    private List<RawTradeInfo> rawTradeList;

    /**
     * 原始子单信息
     */
    private List<RawTradeOrderInfo> rawTradeOrderList;

    /**
     * 优惠信息
     */
    private List<DiscountInfo> discountList;

    @Data
    public static class RawTradeInfo {

        /**
         * 平台状态 未确认
         */
        public static final Integer TRADE_STATUS_TO_CONFIRM = 10;
        /**
         * 平台状态 待尾款
         */
        public static final Integer TRADE_STATUS_PART_PAID = 20;
        /**
         * 平台状态 待发货
         */
        public static final Integer TRADE_STATUS_WAIT_CONSIGN = 30;
        /**
         * 平台状态 部分发货
         */
        public static final Integer TRADE_STATUS_PART_CONSIGN = 40;
        /**
         * 平台状态 已发货
         */
        public static final Integer TRADE_STATUS_CONSIGNED = 50;
        /**
         * 平台状态 已签收
         */
        public static final Integer TRADE_STATUS_SIGNED = 60;
        /**
         * 平台状态 已完成
         */
        public static final Integer TRADE_STATUS_COMPLETE = 70;
        /**
         * 平台状态 已退款
         */
        public static final Integer TRADE_STATUS_REFUND = 80;
        /**
         * 平台状态 已关闭(付款前取消)
         */
        public static final Integer TRADE_STATUS_CLOSED = 90;

        /**
         * 付款状态 - 未付款
         */
        public static final Integer PAY_STATUS_UNPAY = 0;

        /**
         * 付款状态 - 部分付款
         */
        public static final Integer PAY_STATUS_PART_PAID = 1;

        /**
         * 付款状态 - 已付款
         */
        public static final Integer PAY_STATUS_FULL_PAID = 2;

        /**
         * 退款状态 - 无退款
         */
        public static final Integer REFUND_NONE = 0;

        /**
         * 退款状态 - 申请退款
         */
        public static final Integer REFUND_APPLY = 1;

        /**
         * 退款状态 - 部分退款
         */
        public static final Integer REFUND_PART = 2;

        /**
         * 退款状态 - 全部退款
         */
        public static final Integer REFUND_FULL = 3;

        /**
         * 发货条件 - 款到发货
         */
        public static final Integer DELIVERY_TERM_DAP = 1;

        /**
         * 发货条件 - 货到付款(包含部分货到付款)
         */
        public static final Integer DELIVERY_TERM_COD = 2;

        /**
         * 处理状态 - 待递交
         */
        public static final Integer PROCESS_STATUS_WAIT_DELIVERY = 10;

        /**
         * 处理状态 - 已取消
         */
        public static final Integer PROCESS_STATUS_CANCEL = 70;

        /**
         * 支付方式 - 在线转帐
         */
        public static final Integer PAY_METHOD_ONLINE = 1;

        /**
         * 支付方式 - 现金
         */
        public static final Integer PAY_METHOD_CASH = 2;

        /**
         * 支付方式 - 银行转账
         */
        public static final Integer PAY_METHOD_BANK = 3;
        /**
         * 支付方式 - 邮局汇款
         */
        public static final Integer PAY_METHOD_REMITTANCE = 4;

        /**
         * 支付方式 - 预付款
         */
        public static final Integer PAY_METHOD_ADVANCES = 5;

        /**
         * 支付方式 - 刷卡
         */
        public static final Integer PAY_METHOD_CARD = 6;

        /**
         * 支付方式 - 支付宝
         */
        public static final Integer PAY_METHOD_ALIPAY = 7;

        /**
         * 支付方式 - 支付宝
         */
        public static final Integer PAY_METHOD_WX = 8;

        /**
         * 发票类型 - 不需要
         */
        public static final Integer INVOICE_TYPE_NONE = 0;

        /**
         * 发票类型 - 普通发票
         */
        public static final Integer INVOICE_TYPE_ORDINARY = 1;

        /**
         * 发票类型 - 增值税发票
         */
        public static final Integer INVOICE_TYPE_VAT = 2;

        /**
         * 原始单号
         */
        private String tid;

        /**
         * 处理状态
         * 是否执行自动递交以系统配置为准
         * 10: 待递交,
         * 20: 已递交，
         * 30: 部分发货，
         * 40: 已发货，
         * 60: 已完成，
         * 70: 已取消
         */
        @JSONField(name = "process_status")
        private Integer processStatus;

        /**
         * 平台状态
         * 10未确认 20待尾款 30待发货 40部分发货 50已发货 60已签收 70已完成 80已退款 90已关闭(付款前取消)
         */
        @JSONField(name = "trade_status")
        private Integer tradeStatus;

        /**
         * 退款状态
         * 0无退款 1申请退款 2部分退款 3全部退款
         */
        @JSONField(name = "refund_status")
        private Integer refundStatus;

        /**
         * 付款状态
         * 0未付款1部分付款2已付款
         */
        @JSONField(name = "pay_status")
        private Integer payStatus;

        /**
         * 子订单个数
         * 原始单包含的子订单数，rawTradeOrderList节点下所有子单数之和
         */
        @JSONField(name = "order_count")
        private Integer orderCount;

        /**
         * 货品总数量
         * 货品总数量，rawTradeOrderList节点下所有"num"数量之和
         */
        @JSONField(name = "goods_count")
        private BigDecimal goodsCount;

        /**
         * 支付方式
         * 1在线转帐 2现金，3银行转账，4邮局汇款 5预付款 6刷卡 7支付宝 8微信支付
         */
        @JSONField(name = "pay_method")
        private Integer payMethod;

        /**
         * 下单时间
         */
        @JSONField(name = "trade_time")
        private String tradeTime;

        /**
         * 支付时间
         */
        @JSONField(name = "pay_time")
        private String payTime;

        /**
         * 交易结束时间，若无则传null
         */
        @JSONField(name = "end_time")
        private String endTime;

        /**
         * 买家昵称/客户网名
         * 若无则传一个固定值
         */
        @JSONField(name = "buyer_nick")
        private String buyerNick;

        /**
         * 收件人姓名
         */
        @JSONField(name = "receiver_name")
        private String receiverName;

        /**
         * 省市区
         * 省市区空格分隔，示例【北京 北京市 朝阳区】，省市区推送旺店通地址库
         */
        @JSONField(name = "receiver_area")
        private String receiverArea;

        /**
         * 收件人详细地址，不包含省市区，示例【xx街道xx小区xx号楼101】
         */
        @JSONField(name = "receiver_address")
        private String receiverAddress;

        /**
         * 收件人邮编，若无则传''
         */
        @JSONField(name = "receiver_zip")
        private String receiverZip;

        /**
         * 收件人手机
         */
        @JSONField(name = "receiver_mobile")
        private String receiverMobile;

        /**
         * 邮费
         */
        @JSONField(name = "post_amount")
        private BigDecimal postAmount;

        /**
         * 优惠金额
         */
        private BigDecimal discount;

        /**
         * 应收金额
         */
        private BigDecimal receivable;

        /**
         * 发货条件
         * 1款到发货 2货到付款(包含部分货到付款) 3分期付款
         */
        @JSONField(name = "delivery_term")
        private Integer deliveryTerm;

        /**
         * 是否是自流转
         * true自流转，false 非自流转
         */
        @JSONField(name = "is_auto_wms")
        private Boolean autoWms;

        /**
         * 仓库编号
         * 仅自流转订单填写该仓库编号, 非自流转订单传入空字符串即可
         */
        @JSONField(name = "warehouse_no")
        private String warehouseNo;
    }

    @Data
    public static class RawTradeOrderInfo {

        /**
         * 订单类型 - 普通货品
         */
        public static final Integer ORDER_TYPE_NORMAL = 0;

        /**
         * 订单类型 - 虚拟货品
         */
        public static final Integer ORDER_TYPE_VIRTUAL = 1;

        /**
         * 订单类型 - 服务
         */
        public static final Integer ORDER_TYPE_SERVICE = 2;

        /**
         * 退款状态 - 无退款
         */
        public static final Integer REFUND_STATUS_NONE = 0;

        /**
         * 退款状态 - 取消退款
         */
        public static final Integer REFUND_STATUS_CANCEL = 1;

        /**
         * 退款状态 - 已申请退款
         */
        public static final Integer REFUND_STATUS_APPLY = 2;

        /**
         * 退款状态 - 等待退货
         */
        public static final Integer REFUND_STATUS_AGREE = 3;

        /**
         * 退款状态 - 等待收货
         */
        public static final Integer REFUND_STATUS_WAIT_RECEIVE = 4;

        /**
         * 退款状态 - 退款成功
         */
        public static final Integer REFUND_STATUS_SUCCESS = 5;

        /**
         * 退款状态 - 未付款关闭
         */
        public static final Integer REFUND_STATUS_DISCARD = 6;

        /**
         * 平台状态
         */
        public static final Integer PLATFORM_STATUS = 30;

        /**
         * 原始订单号
         */
        private String tid;

        /**
         * 原始子单号
         */
        private String oid;

        /**
         * 平台的状态
         * 10未确认 20待尾款 30待发货 40部分发货 50已发货 60已签收 70已完成 80已退款 90已关闭
         */
        private Integer status;

        /**
         * 退款标记
         * 0无退款1取消退款,2已申请退款,3等待退货,4等待收货,5退款成功,6未付款关闭
         */
        @JSONField(name = "refund_status")
        private Integer refundStatus;

        /**
         * 平台系统货品（SPU）的唯一标识。SPU和SKU概念介绍
         */
        @JSONField(name = "goods_id")
        private String goodsId;

        /**
         * 平台系统单品（SKU）的的唯一标识。SPU和SKU概念介绍
         */
        @JSONField(name = "spec_id")
        private String specId;

        /**
         * 货品编号
         */
        @JSONField(name = "goods_no")
        private String goodsNo;

        /**
         * 规格编码
         */
        @JSONField(name = "spec_no")
        private String specNo;

        /**
         * 货品名称
         */
        @JSONField(name = "goods_name")
        private String goodsName;

        /**
         * 数量
         */
        private Integer num;

        /**
         * 单价
         */
        private BigDecimal price;

        /**
         * 优惠，平台折扣, 不包含手工调整和分摊优惠
         */
        private BigDecimal discount;

        /**
         * 分摊优惠,退款不变
         */
        @JSONField(name = "share_discount")
        private BigDecimal shareDiscount;

        /**
         * 总价格
         */
        @JSONField(name = "total_amount")
        private BigDecimal totalAmount;

        /**
         * 手工调整的优惠金额，
         */
        @JSONField(name = "adjust_amount")
        private BigDecimal adjustAmount;

        /**
         * 退款金额
         */
        @JSONField(name = "refund_amount")
        private BigDecimal refundAmount;

        /**
         * 备注
         */
        private String remark;

        /**
         * json串，若无可传""
         */
        private String json = "";
    }

    @Data
    public static class DiscountInfo {

        /**
         * 原始订单号
         */
        private String tid;

        /**
         * 原始子单号
         */
        private String oid;

        /**
         * 唯一编码
         * 平台上优惠的唯一标识
         */
        private String sn;

        /**
         * 优惠名称
         */
        private String name;

        /**
         * 优惠详情
         */
        private String detail;

        /**
         * 优惠金额
         */
        private BigDecimal amount;
    }
}
