package cn.com.duiba.thirdpartyvnew.dto.mengniu;

import java.io.Serializable;
import java.util.List;

/**
 * @date:2022/6/8 10:05
 * @author:zhaozhanghai
 * @Description:
 */
public class MengNiuGoodsDto implements Serializable {

    /**
     * 请求ID，全局唯⼀。
     */
    private String requestId;
    /**
     * 请求时间戳（毫秒）
     */
    private Long timestamp;
    /**
     * data
     */
    private DataDTO data;

    public String getRequestId() {
        return requestId;
    }

    public void setRequestId(String requestId) {
        this.requestId = requestId;
    }

    public Long getTimestamp() {
        return timestamp;
    }

    public void setTimestamp(Long timestamp) {
        this.timestamp = timestamp;
    }

    public DataDTO getData() {
        return data;
    }

    public void setData(DataDTO data) {
        this.data = data;
    }

    public static class DataDTO implements Serializable {
        /**
         * spuId
         */
        private Long spuId;
        /**
         * 类型，取值["虚拟卡券","实物商品"]
         */
        private String category;
        /**
         * spu 商品名称
         */
        private String name;
        /**
         * 可选，商品编号
         */
        private String spuNo;
        /**
         * 可选，商品来源
         */
        private String sourceType;
        /**
         * 可选，商品来源Id
         */
        private String sourceId;

        /**
         * 仅支持virtual类商品 可选，账⼾类型 0 ⼿机号 1 QQ号 2 微信
         */
        private Integer accountType;
        /**
         * 商品描述
         */
        private String introduction;
        /**
         * 可选，商品分享背景图
         */
        private String shareBgImg;
        /**
         * 商品主图地址
         */
        private String thumbnail;
        /**
         * 轮播图
         */
        private List<String> slides;
        /**
         * 单位
         */
        private String unit;
        /**
         * 描述
         */
        private DescriptionDTO description;
        /**
         * skus
         */
        private List<SkusDTO> skus;

        public Long getSpuId() {
            return spuId;
        }

        public void setSpuId(Long spuId) {
            this.spuId = spuId;
        }

        public String getCategory() {
            return category;
        }

        public void setCategory(String category) {
            this.category = category;
        }

        public String getName() {
            return name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public Integer getAccountType() {
            return accountType;
        }

        public void setAccountType(Integer accountType) {
            this.accountType = accountType;
        }

        public String getSpuNo() {
            return spuNo;
        }

        public void setSpuNo(String spuNo) {
            this.spuNo = spuNo;
        }

        public String getSourceType() {
            return sourceType;
        }

        public void setSourceType(String sourceType) {
            this.sourceType = sourceType;
        }

        public String getSourceId() {
            return sourceId;
        }

        public void setSourceId(String sourceId) {
            this.sourceId = sourceId;
        }

        public String getIntroduction() {
            return introduction;
        }

        public void setIntroduction(String introduction) {
            this.introduction = introduction;
        }

        public String getShareBgImg() {
            return shareBgImg;
        }

        public void setShareBgImg(String shareBgImg) {
            this.shareBgImg = shareBgImg;
        }

        public String getThumbnail() {
            return thumbnail;
        }

        public void setThumbnail(String thumbnail) {
            this.thumbnail = thumbnail;
        }

        public List<String> getSlides() {
            return slides;
        }

        public void setSlides(List<String> slides) {
            this.slides = slides;
        }

        public String getUnit() {
            return unit;
        }

        public void setUnit(String unit) {
            this.unit = unit;
        }

        public DescriptionDTO getDescription() {
            return description;
        }

        public void setDescription(DescriptionDTO description) {
            this.description = description;
        }

        public List<SkusDTO> getSkus() {
            return skus;
        }

        public void setSkus(List<SkusDTO> skus) {
            this.skus = skus;
        }

        public static class DescriptionDTO implements Serializable {
            /**
             * 描述⽂本
             */
            private String text;
            /**
             * 描述图⽚
             */
            private List<String> imgs;

            public String getText() {
                return text;
            }

            public void setText(String text) {
                this.text = text;
            }

            public List<String> getImgs() {
                return imgs;
            }

            public void setImgs(List<String> imgs) {
                this.imgs = imgs;
            }
        }

        public static class SkusDTO implements Serializable {
            /**
             * skuId
             */
            private Long skuId;
            /**
             * 商品名称
             */
            private String name;
            /**
             * 商品描述
             */
            private String description;
            /**
             * 商品图地址
             */
            private String thumbnail;
            /**
             * 可选 库存数
             */
            private Integer stockNum;
            /**
             * 可选 商品编码
             */
            private String skuCode;
            /**
             * 可选 条形码
             */
            private String barcode;

            public Long getSkuId() {
                return skuId;
            }

            public void setSkuId(Long skuId) {
                this.skuId = skuId;
            }

            public String getName() {
                return name;
            }

            public void setName(String name) {
                this.name = name;
            }

            public String getDescription() {
                return description;
            }

            public void setDescription(String description) {
                this.description = description;
            }

            public String getThumbnail() {
                return thumbnail;
            }

            public void setThumbnail(String thumbnail) {
                this.thumbnail = thumbnail;
            }

            public Integer getStockNum() {
                return stockNum;
            }

            public void setStockNum(Integer stockNum) {
                this.stockNum = stockNum;
            }

            public String getSkuCode() {
                return skuCode;
            }

            public void setSkuCode(String skuCode) {
                this.skuCode = skuCode;
            }

            public String getBarcode() {
                return barcode;
            }

            public void setBarcode(String barcode) {
                this.barcode = barcode;
            }
        }
    }
}
