package cn.com.duiba.thirdpartyvnew.dto.wlnx.request.consumer;

import cn.com.duiba.thirdpartyvnew.dto.wlnx.request.WlnxBaseRequest;
import lombok.Data;
import lombok.EqualsAndHashCode;

@Data
@EqualsAndHashCode(callSuper = true)
public class WlnxConsumerCreditsChangeRequest extends WlnxBaseRequest {
    /**
     * 积分收入
     */
    public static final String INCOME = "INCOME";
    /**
     * 积分支出
     */
    public static final String EXPEND = "EXPEND";
    /**
     * 积分数
     */
    private Integer number;
    /**
     * 唯一流水标识，使用系统标识（签名的source+uuid）
     */
    private String uuid;
    /**
     * 来源备注
     */
    private String sourceRemark;
    /**
     * 积分类型
     */
    private String pointType;
    /**
     * INCOME(收入),EXPEND(支出)
     */
    private String pointUpdateType;
    /**
     * 积分运营平台传 （见备注）
     */
    private String pointUpdateWay;
}
