package cn.com.duiba.thirdpartyvnew.api.wdt;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.thirdpartyvnew.dto.wdt.LogisticsSyncUpdateParam;
import cn.com.duiba.thirdpartyvnew.dto.wdt.LogisticsSyncUpdateResult;
import cn.com.duiba.thirdpartyvnew.dto.wdt.Pager;
import cn.com.duiba.thirdpartyvnew.dto.wdt.SalesLogisticsSyncGetSyncListExtParam;
import cn.com.duiba.thirdpartyvnew.dto.wdt.SalesLogisticsSyncGetSyncListExtResult;
import cn.com.duiba.thirdpartyvnew.dto.wdt.SalesRawTradePushSelfParam;
import cn.com.duiba.thirdpartyvnew.dto.wdt.SalesRawTradePushSelfResult;
import cn.com.duiba.thirdpartyvnew.dto.yaduo.LogisticsSyncAckReqDto;
import cn.com.duiba.thirdpartyvnew.dto.yaduo.LogisticsSyncAckRespDto;
import cn.com.duiba.thirdpartyvnew.dto.yaduo.LogisticsSyncQueryReqDto;
import cn.com.duiba.thirdpartyvnew.dto.yaduo.LogisticsSyncQueryRespDto;
import cn.com.duiba.thirdpartyvnew.dto.yaduo.TradePushReqDto;
import cn.com.duiba.thirdpartyvnew.dto.yaduo.TradePushRespDto;

import java.util.List;

/**
 * 旺店通外部接口调用
 *
 * @author cgq
 */
@AdvancedFeignClient
public interface RemoteWdtService {

    /**
     * 创建原始订单
     * 企业版
     * @param tradePushReqDto 创建原始订单入参
     * @param supplierId 供应商ID
     * @return {@link TradePushRespDto}
     */
    TradePushRespDto tradePush(TradePushReqDto tradePushReqDto, Long supplierId);

    /**
     * 查询物流同步
     * 企业版
     * @param logisticsSyncQueryReqDto 查询物流同步入参
     * @param supplierId 供应商ID
     * @return {@link LogisticsSyncQueryRespDto}
     */
    LogisticsSyncQueryRespDto logisticsSyncQuery(LogisticsSyncQueryReqDto logisticsSyncQueryReqDto, Long supplierId);

    /**
     * 物流同步回写
     * 企业版
     * @param logisticsSyncAckReqDto 物流同步回写入参
     * @param supplierId 供应商ID
     * @return {@link LogisticsSyncAckRespDto}
     */
    LogisticsSyncAckRespDto logisticsSyncAck(LogisticsSyncAckReqDto logisticsSyncAckReqDto, Long supplierId);

    /**
     * 创建原始订单（旗舰版）
     * 参考 WangDianTongService.salesRawTradePushSelf
     *
     * @param salesRawTradePushSelfParam 创建原始订单入参
     * @param supplierId 供应商ID
     * @return {@link SalesRawTradePushSelfResult}
     */
    SalesRawTradePushSelfResult tradePushFlagship(SalesRawTradePushSelfParam salesRawTradePushSelfParam, Long supplierId);

    /**
     * 查询物流同步（旗舰版）
     * 参考 WangDianTongService.salesLogisticsSyncGetSyncListExt
     *
     * @param param 查询物流同步入参
     * @param pager 分页参数
     * @param supplierId 供应商ID
     * @return {@link List<SalesLogisticsSyncGetSyncListExtResult>}
     */
    List<SalesLogisticsSyncGetSyncListExtResult> logisticsSyncQueryFlagship(
            SalesLogisticsSyncGetSyncListExtParam param, Pager pager, Long supplierId);

    /**
     * 物流同步回写（旗舰版）
     * 参考 WangDianTongService.logisticsSyncUpdate
     *
     * @param param 物流同步回写入参
     * @param supplierId 供应商ID
     * @return {@link LogisticsSyncUpdateResult}
     */
    LogisticsSyncUpdateResult logisticsSyncAckFlagship(LogisticsSyncUpdateParam param, Long supplierId);
}
