package cn.com.duiba.thirdpartyvnew.dto.wdt;

import com.alibaba.fastjson.annotation.JSONField;
import lombok.Data;

/**
 * 旺店通旗舰版物流同步状态回传参数
 *
 * @author cgq
 * @date 2025-01-27
 */
@Data
public class LogisticsSyncUpdateParam {

    /**
     * 同步成功
     */
    public static final byte SYNC_SUCCESS = 0;

    /**
     * 还需同步
     */
    public static final byte SYNC_FAIL = 2;

    /**
     * 同步失败
     */
    public static final byte SYNC_RETRY = -100;

    /**
     * 物流同步id
     */
    @JSONField(name = "sync_id")
    private Integer syncId;

    /**
     * 状态
     * 0:同步成功 2:还需同步 -100:同步失败
     */
    @JSONField(name = "status")
    private Integer status;

    /**
     * 错误信息
     * 若成功传""
     */
    @JSONField(name = "error_msg")
    private String errorMessage;
}
