package cn.com.duiba.thirdpartyvnew.dto.wdt;

import com.alibaba.fastjson.annotation.JSONField;
import lombok.Data;

/**
 * 旺店通旗舰版待同步列表查询返回结果
 *
 * @author cgq
 * @date 2025-01-27
 */
@Data
public class SalesLogisticsSyncGetSyncListExtResult {

    /**
     * 物流同步id
     */
    @JSONField(name = "sync_id")
    private String syncId;

    /**
     * 原始单号
     */
    private String tid;

    /**
     * 物流单号
     */
    @JSONField(name = "logistics_no")
    private String logisticsNo;

    /**
     * 物流公司编号
     */
    @JSONField(name = "logistics_code")
    private String logisticsCode;

    /**
     * 物流公司名称
     */
    @JSONField(name = "logistics_name")
    private String logisticsName;

    /**
     * 是否拆单发货
     * 是：0  否：1
     */
    @JSONField(name = "is_part_sync")
    private Integer isPartSync;

    /**
     * 原始子单号
     * 仅拆单发货和部分退款成功的单据该字段有值
     */
    private String oids;

    /**
     * 订单id
     */
    @JSONField(name = "trade_id")
    private String tradeId;

    /**
     * 平台id
     */
    @JSONField(name = "platform_id")
    private String platformId;

    /**
     * 创建时间
     * 格式: yyyy-MM-dd HH:mm:ss
     */
    private String created;
}
