package cn.com.duiba.thirdpartyvnew.dto.wanda.response;

import lombok.Data;

import java.io.Serializable;

/**
 * 万达优惠券操作响应DTO
 *
 * @author zhangdaqing
 * @date 2025/7/10
 */
@Data
public class WandaCouponOperationResponse implements Serializable {
    
    private static final long serialVersionUID = 1L;
    
    /**
     * 状态码；200正常
     */
    private Integer status;
    
    /**
     * 响应消息
     */
    private String message;
    
    /**
     * 判断是否成功
     * 
     * @return true: 成功, false: 失败
     */
    public boolean isSuccess() {
        return status != null && status == 200;
    }
} 