package cn.com.duiba.biz.credits;

import cn.com.duiba.api.bo.subcredits.SubCreditsMsgDto;
import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.constant.MiaojieConfig;
import cn.com.duiba.domain.SubCreditsMsgWrapper;
import cn.com.duiba.notifycenter.domain.NotifyQueueDO;
import cn.com.duiba.order.center.api.dto.CreditsMessage;
import cn.com.duiba.thirdparty.dto.CreditsMessageDto;
import cn.com.duiba.tool.AssembleTool;
import cn.com.duiba.tool.HttpRequestLog;
import cn.com.duiba.tool.HttpUtils;
import cn.com.duiba.tool.JsonTool;
import cn.com.duiba.wolf.utils.DateUtils;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Maps;
import org.apache.commons.lang.StringUtils;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.message.BasicHeader;
import org.apache.http.util.EntityUtils;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;

/**
 * Created by sunyan on 2020/1/9.
 */
@Service
public class MiaojieApi {
    private static final Logger LOGGER = LoggerFactory.getLogger(MiaojieApi.class);

    private static final String CHARACTER_ENCODE = "UTF-8";
    private static final String APPLICATION_JSON = "application/json";

    @Autowired
    private MiaojieConfig miaojieConfig;
    @Resource(name = "httpClient")
    // HTTP超时已经修复
    private CloseableHttpClient httpClient;


    /**
     * 判断当前app是否是妙洁的app
     * @param appId
     * @return
     */
    public boolean isMiaojieApp(Long appId) {
        return miaojieConfig.getAppIds().contains(appId);
    }



    /**
     * 组装扣积分对象  remote形式发起的扣积分请求
     * @param request
     * @return
     */
    public CreditsMessage getSubCreditsMessage(CreditsMessage request) throws BizException {
        Map<String, String> originAuthParams = request.getAuthParams();
        String orderNum = originAuthParams.get("orderNum");
        String credits = originAuthParams.get("credits");
        String transfer = originAuthParams.get("transfer");
        String[] transfers = transfer.split("#");
        if(transfers.length!=2){
            LOGGER.error("MiaojieApi call getSubCreditsMessage transfers error , CreditsMessage = {},transfers={}",
                    JSONObject.toJSONString(request), transfers);
            throw new BizException("妙洁扣积分流程中断");
        }
        String openIdStr = transfers[0];
        String openId = openIdStr.substring(openIdStr.indexOf("openId=")+7);
        String mobileStr = transfers[1];
        String mobile = mobileStr.substring(mobileStr.indexOf("mobile=")+7);
        String content;
        String type = originAuthParams.get("type");
        if(StringUtils.equals("hdtool",type)){
            content = "兑吧参与活动扣减";
        }else if(StringUtils.equals("game",type)){
            content = "兑吧参与游戏扣减";
        }else if(StringUtils.equals("alipay",type)||
                StringUtils.equals("qb",type)||
                StringUtils.equals("coupon",type)||
                StringUtils.equals("object",type)||
                StringUtils.equals("phonebill",type)||
                StringUtils.equals("phoneflow",type)||
                StringUtils.equals("virtual",type)){
            content = "兑吧线上消费扣减";
        }else if (StringUtils.equals("sign",type)){
            content = "兑吧签到类活动扣减";
        } else{
            content = "兑吧扣减";
        }
        Map<String, String> authParams = Maps.newHashMap();
        authParams.put("type", "1");
        authParams.put("mobile", mobile);
        authParams.put("pointInt", credits);
        authParams.put("recordId", orderNum);
        authParams.put("openId", openId);
        authParams.put("content", content);
        request.setAuthParams(authParams);
        request.setHttpType(CreditsMessage.HTTP_POST);
        return request;
    }

    /**
     * 构造减积分请求 remote
     *
     * @param message
     * @return
     */
    public HttpRequestBase getSubCreditsHttpRequestBase(CreditsMessage message) {
        Map<String, String> params = message.getAuthParams();
        HttpPost httpPost = getHttpPost(params,miaojieConfig.getCreditsRequestPath());
        return httpPost;
    }

    /**
     * 构造减积分请求 remote
     *
     * @param subCreditsMsgWrapper
     * @return
     */
    public HttpRequestBase getSubCreditsHttpRequestBase(SubCreditsMsgWrapper subCreditsMsgWrapper) {
        Map<String, String> params = subCreditsMsgWrapper.getSubCreditsMsg().getAuthParams();
        HttpPost httpPost = getHttpPost(params,miaojieConfig.getCreditsRequestPath());
        return httpPost;
    }

    /**
     * 构造加积分请求
     *
     * @param message
     * @return
     */
    public HttpRequestBase getAddCreditsHttpRequestBase(CreditsMessageDto message) {
        Map<String, String> params = message.getAuthParams();
        HttpPost httpPost = getHttpPost(params,miaojieConfig.getCreditsRequestPath());
        return httpPost;
    }

    @NotNull
    private HttpPost getHttpPost(Map<String, String> params,String requestPath) {
        String serviceName = miaojieConfig.getServiceName();
        String serviceSecret = miaojieConfig.getServiceSecret();
        String host = miaojieConfig.getHost();
        String contextPath = miaojieConfig.getContextPath();
        String version = miaojieConfig.getVersion();
        //头部
        BasicHeader[] headers = getHeaders(requestPath, serviceName, serviceSecret, contextPath, version);
        String url = host+"/"+contextPath+"/"+version+requestPath;

        HttpPost httpPost = new HttpPost(url);
        StringEntity stringEntity = new StringEntity(JSONObject.toJSONString(params), CHARACTER_ENCODE);
        stringEntity.setContentEncoding(CHARACTER_ENCODE);
        stringEntity.setContentType(APPLICATION_JSON);
        httpPost.setHeaders(headers);
        httpPost.setEntity(stringEntity);
        return httpPost;
    }


    /**
     * 组装扣积分对象  mq形式发起的扣积分请求
     * @param subCreditsMsgWrapper
     * @return
     */
    public SubCreditsMsgWrapper getSubCreditsMessage(SubCreditsMsgWrapper subCreditsMsgWrapper) throws BizException {
        SubCreditsMsgDto msg = subCreditsMsgWrapper.getSubCreditsMsg();
        Map<String, String> originAuthParams = msg.getAuthParams();
        String orderNum = originAuthParams.get("orderNum");
        String credits = originAuthParams.get("credits");
        String transfer = originAuthParams.get("transfer");
        String[] transfers = transfer.split("#");
        if(transfers.length!=2){
            LOGGER.error("MiaojieApi call getSubCreditsMessage transfers error , subCreditsMsgWrapper = {},transfers={}",
                    JSONObject.toJSONString(subCreditsMsgWrapper), transfers);
            throw new BizException("妙洁扣积分流程中断");
        }
        String openIdStr = transfers[0];
        String openId = openIdStr.substring(openIdStr.indexOf("openId=")+7);
        String mobileStr = transfers[1];
        String mobile = mobileStr.substring(mobileStr.indexOf("mobile=")+7);
        String content;
        String type = originAuthParams.get("type");
        if(StringUtils.equals("hdtool",type)){
            content = "兑吧参与活动扣减";
        }else if(StringUtils.equals("game",type)){
            content = "兑吧参与游戏扣减";
        }else if(StringUtils.equals("alipay",type)||
                StringUtils.equals("qb",type)||
                StringUtils.equals("coupon",type)||
                StringUtils.equals("object",type)||
                StringUtils.equals("phonebill",type)||
                StringUtils.equals("phoneflow",type)||
                StringUtils.equals("virtual",type)){
            content = "兑吧线上消费扣减";
        }else if (StringUtils.equals("sign",type)){
            content = "兑吧签到类活动扣减";
        } else{
            content = "兑吧扣减";
        }
        Map<String, String> authParams = Maps.newHashMap();
        authParams.put("type", "1");
        authParams.put("mobile", mobile);
        authParams.put("pointInt", credits);
        authParams.put("recordId", orderNum);
        authParams.put("openId", openId);
        authParams.put("content", content);
        msg.setAuthParams(authParams);
        msg.setHttpType(SubCreditsMsgDto.HTTP_POST);
        return subCreditsMsgWrapper;
    }


    /**
     * 组装加积分对象 正常加积分
     * @param request
     * @return
     */
    public CreditsMessageDto getAddCreditsMessage(CreditsMessageDto request) throws BizException {
        Map<String, String> originAuthParams = request.getAuthParams();
        String orderNum = originAuthParams.get("orderNum");
        String credits = originAuthParams.get("credits");
        String transfer = originAuthParams.get("transfer");
        String[] transfers = transfer.split("#");
        if(transfers.length!=2){
            LOGGER.error("MiaojieApi call getAddCreditsMessage transfers error , request = {},transfers={}",
                    JSONObject.toJSONString(request), transfers);
            throw new BizException("妙洁加积分流程中断");
        }
        String openIdStr = transfers[0];
        String openId = openIdStr.substring(openIdStr.indexOf("openId=")+7);
        String mobileStr = transfers[1];
        String mobile = mobileStr.substring(mobileStr.indexOf("mobile=")+7);
        String content;
        String type = originAuthParams.get("type");
        if(StringUtils.equals("hdtool",type)){
            content = "兑吧参与活动赠送";
        }else if(StringUtils.equals("game",type)){
            content = "兑吧参与游戏赠送";
        }else if(StringUtils.equals("sign",type)){
            content = "兑吧签到赠送";
        }else{
            content = "兑吧赠送";
        }
        String failType = originAuthParams.get("failType");
        if(failType!=null){
            if(StringUtils.equals("1",failType)){
                content = "兑吧订单失败返还积分";
            }else if (StringUtils.equals("2",failType)){
                content = "兑吧订单取消返还积分";
            }
        }
        Map<String, String> authParams = Maps.newHashMap();
        authParams.put("type", "2");
        authParams.put("mobile", mobile);
        authParams.put("pointInt", credits);
        authParams.put("recordId", orderNum);
        authParams.put("openId", openId);
        authParams.put("content", content);
        request.setAuthParams(authParams);
        request.setHttpType(CreditsMessage.HTTP_POST);
        return request;
    }

    /**
     * 转义扣积分响应数据
     *
     * @param body
     * @return
     */
    public String getMiaojieResponseCredis(String body,Map<String, String> authParams) {
        JSONObject jsonBody;
        try {
            jsonBody = JSON.parseObject(body);
        } catch (Exception e) {
            LOGGER.error("JSON.parseObject:body={},error={}",body, e.getMessage());
            return body;
        }
        JSONObject json = JsonTool.getAllJson(jsonBody);
        Map<String, String> duibaDoc = new HashMap<>();
        String code = json.getString("code");
        String pointCode = json.getString("point_code");
        if ("SUCCESS".equals(code)&&"SUC".equals(pointCode)) {
            duibaDoc.put("status", "ok");
        } else {
            duibaDoc.put("status", "fail");
        }
        duibaDoc.put("errorMessage", json.getString("message"));
        duibaDoc.put("bizId", authParams.get("recordId")+"_miaojie");
        //获取用户积分
        Map<String, String> params = new HashMap<>();
        params.put("openId",authParams.get("openId"));
        params.put("mobile",authParams.get("mobile"));
        String credits = getCredits(params);
        duibaDoc.put("credits", credits);
        return JsonTool.objectToJson(duibaDoc);
    }


    private String getCredits(Map<String, String> params){
        String credits = null;
        try {
            HttpPost httpPost = getHttpPost(params,miaojieConfig.getGradeRequestPath());
            HttpUtils.resetTimeOut(httpPost);
            try (CloseableHttpResponse response = httpClient.execute(httpPost)) {
                String result = EntityUtils.toString(response.getEntity());
                JSONObject jsonret = JSONObject.parseObject(result);
                String code = jsonret.getString("code");
                if(StringUtils.equals("SUCCESS",code)){
                    String jsondata = jsonret.getString("jsondata");
                    JSONObject jsondataJ = JSONObject.parseObject(jsondata);
                    if(jsondataJ!=null){
                        credits = jsondataJ.getString("point");
                    }
                }
            } catch (Exception e) {
                LOGGER.info("妙洁定制积分查询接口调用异常 params={},error={}", JSONObject.toJSONString(params), e.getMessage());
            }
            return credits;
        } catch (Exception e) {
            LOGGER.info("妙洁定制积分查询接口调用异常 params={},error={}", JSONObject.toJSONString(params), e.getMessage());
            return null;
        }
    }

    /**
     * 结果通知
     * @param record 通知记录
     * @return 通知请求
     */
    public HttpRequestBase getMiaojieRequestNotify(NotifyQueueDO record) throws BizException {
        //妙洁活动通知是同步主订单，扣积分通知不走
        if(StringUtils.isBlank(record.getError4developer())){
            return new HttpPost("http://test.lianwangshenqi.com");
        }

        String transfer = record.getTransfer();
        String[] transfers = transfer.split("#");
        if(transfers.length!=2){
            LOGGER.error("MiaojieApi call getMiaojieRequestNotify transfers error , NotifyQueueDO = {},transfers={}",
                    JSONObject.toJSONString(record), transfers);
            throw new BizException("妙洁加积分流程中断");
        }
        String mobileStr = transfers[1];
        String mobile = mobileStr.substring(mobileStr.indexOf("mobile=")+7);
        Map<String, String> param = JSONObject.parseObject(record.getError4developer(),Map.class);
        param.put("mobile",mobile);
        HttpRequestLog.logUrl("[action notify request][bizId " + record.getDuibaOrderNum() + "] [param " + JSONObject.toJSONString(param) + "]");
        HttpPost httpPost = getHttpPost(param,miaojieConfig.getNotifyRequestPath());
        return httpPost;
    }

    /**
     * 获取通知响应
     *
     * @param body
     * @return
     */
    public String getMiaojieResponseNotify(String body) {
        JSONObject jsonBody;
        try {
            jsonBody = JSON.parseObject(body);
        } catch (Exception e) {
            LOGGER.error("JSON.parseObject:", e);
            return body;
        }
        JSONObject json = JsonTool.getAllJson(jsonBody);
        String code = json.getString("code");
        String orderPutCode = json.getString("orderPut_code");
        if ("SUCCESS".equals(code)&&"SUC".equals(orderPutCode)) {
            return "ok";
        }
        return body;
    }


    @NotNull
    private BasicHeader[] getHeaders(String requestPath, String serviceName, String serviceSecret, String contextPath, String version) {
        BasicHeader[] headers = new BasicHeader[4];
        headers[0] = new BasicHeader("X-Caller-Service", serviceName);
        String timestamp = DateUtils.getSecondStr(new Date());
        headers[1] = new BasicHeader("X-Caller-Timestamp", timestamp);
        String sign = generateSign(serviceName,contextPath,version,timestamp,serviceSecret,requestPath);
        headers[2] = new BasicHeader("X-Caller-Sign", sign);
        headers[3] = new BasicHeader("Content-Type", "application/json;charset=utf-8");
        return headers;
    }


    public static String generateSign(String callerService, String contextPath,
                                      String version, String timestamp, String serviceSecret, String requestPath) {
        String sign = "";
        if (callerService == null || callerService.equals("") || contextPath == null || contextPath.equals("") ||
                timestamp == null || timestamp.equals("") || serviceSecret == null || serviceSecret.equals("")) {
            return sign;
        }
        Map<String, String> map = new LinkedHashMap<>(); map.put("callerService", callerService); map.put("contextPath", contextPath);
        try {
            if (requestPath != null) {
                StringBuilder sb = new StringBuilder(); for(String part : requestPath.split("/")) {
                    sb.append("/").append(URLEncoder.encode(part,"utf-8"));
                }
                map.put("requestPath", sb.toString().substring(1));
            }
            map.put("timestamp", timestamp); map.put("v", version);
            sign = generateMD5Sign(serviceSecret, map);
        } catch (NoSuchAlgorithmException | UnsupportedEncodingException e) { e.printStackTrace();
            return "";
        }
        return sign;
    }

    private static String generateMD5Sign(String secret, Map<String, String> parameters) throws NoSuchAlgorithmException,UnsupportedEncodingException {
        MessageDigest md5 = MessageDigest.getInstance("MD5");
        byte[] bytes = md5.digest(generateConcatSign(secret, parameters).getBytes("utf-8"));
        return byteToHex(bytes);
    }

    private static String generateConcatSign(String secret, Map<String, String> parameters) {
        StringBuilder sb = new StringBuilder().append(secret); Set<String> keys = parameters.keySet();
        for (String key : keys) { sb.append(key).append(parameters.get(key));
        }
        return sb.append(secret).toString();
    }

    private static String byteToHex(byte[] bytesIn) {
        StringBuilder sb = new StringBuilder();
        for (byte byteIn : bytesIn) {
            String bt = Integer.toHexString(byteIn & 0xff);
            if(bt.length() == 1){
                sb.append(0).append(bt);
            }else{
                sb.append(bt);
            }
        }
        return sb.toString().toUpperCase();
    }

}
