package cn.com.duiba.biz.credits.strategy.Impl;

import cn.com.duiba.biz.Exception.ThirdpatyException;
import cn.com.duiba.biz.credits.strategy.ApiStrategy;
import cn.com.duiba.constant.GreelyConfig;
import cn.com.duiba.credits.sdk.SignTool;
import cn.com.duiba.dao.AppDAO;
import cn.com.duiba.domain.AppDO;
import cn.com.duiba.thirdparty.dto.HttpRequestMessageDto;
import cn.com.duiba.tool.AssembleTool;
import cn.com.duiba.tool.HttpRequestLog;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpRequestBase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Map;

/**
 * @Date 2020/12/28
 * @Created by cmm
 */
@Service
public class GreelyApiStrategy implements ApiStrategy {

    private static final Logger log = LoggerFactory.getLogger(GreelyApiStrategy.class);
    @Autowired
    private AppDAO appDAO;
    @Autowired
    private GreelyConfig greelyConfig;

    @Override
    public boolean isCustomCrecord(HttpRequestMessageDto dto) {
        String orderNum = dto.getHttpParams().get("orderNum");
        return StringUtils.isNotBlank(orderNum);
    }

    @Override
    public HttpRequestBase getCrecordNotify(HttpRequestMessageDto msg, AppDO app) {
        Map<String, String> authParams = msg.getHttpParams();
        authParams.put("appKey", app.getAppKey());
        authParams.put("appSecret", appDAO.getAppSecret(app));
        String sign = SignTool.sign(authParams);
        authParams.put("sign", sign);
        authParams.remove("appSecret");

        String url = greelyConfig.getCrecordNotifyUrl();
        if(StringUtils.isBlank(url)){
            throw new ThirdpatyException("吉利兑换记录同步url is not config");
        }

        url = AssembleTool.assembleUrl(url, authParams);
        HttpRequestBase http = new HttpGet(url.trim());
        HttpRequestLog.logUrl("[action crecord] [tag get request] [url " + url + "]");
        return http;
    }
}
