package cn.com.duiba.biz.credits.strategy.Impl;

import cn.com.duiba.biz.credits.strategy.ApiStrategy;
import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.constant.zhiji.ZhiJiConfig;
import cn.com.duiba.credits.sdk.AddCreditsParams;
import cn.com.duiba.domain.SubCreditsMsgWrapper;
import cn.com.duiba.domain.ZhijiAddCreditsDataReq;
import cn.com.duiba.domain.ZhijiAddCreditsReqBody;
import cn.com.duiba.domain.ZhijiAddCreditsReqData;
import cn.com.duiba.domain.ZhijiAddCreditsReqPointList;
import cn.com.duiba.domain.ZhijiAddCreditsRequest;
import cn.com.duiba.thirdparty.dto.CreditsMessageDto;
import cn.com.duiba.tool.AssembleTool;
import cn.com.duiba.tool.zhiji.ZhiJiParamTool;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Maps;
import org.apache.commons.codec.binary.Hex;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.entity.StringEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.io.UnsupportedEncodingException;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

/**
 * @author: pengyi
 * @description:
 * @date: 2021/9/3 下午3:31
 */
@Service
public class ZhiJiApiStrategy implements ApiStrategy {

    private static final Logger LOGGER = LoggerFactory.getLogger(ZhiJiApiStrategy.class);

    private final RequestConfig requestConfig;
    private static final int FIVE_SECONDS = 5*1000;
    private static final int TEN_SECONDS = 10*1000;
    @Autowired
    private ZhiJiConfig zhiJiConfig;



    {
        //http请求超时配置
        requestConfig = RequestConfig.custom().setConnectTimeout(FIVE_SECONDS).setSocketTimeout(TEN_SECONDS).setConnectionRequestTimeout(500).build();
    }

    @Override
    public HttpRequestBase getAddCreditsMessageRequest(CreditsMessageDto message) {
        try{
            HttpPost httpPost = new HttpPost(zhiJiConfig.getAddCreditsUrl());
            AddCreditsParams addCreditsParams = message.getAddCreditsParams();
            ZhijiAddCreditsReqPointList pointList = new ZhijiAddCreditsReqPointList();
            pointList.setAccrualPoints(addCreditsParams.getCredits().intValue());
            ZhijiAddCreditsDataReq dataReq = new ZhijiAddCreditsDataReq();
            dataReq.setPointList(pointList);
            ZhijiAddCreditsReqData reqData = new ZhijiAddCreditsReqData();
            reqData.setListOfIMAccruePointsInput(dataReq);

            ZhijiAddCreditsReqBody body = new ZhijiAddCreditsReqBody();
            body.setData(reqData);
            body.setTraceId(addCreditsParams.getOrderNum());
            body.setTransactionNumber(addCreditsParams.getOrderNum());
            String transfer = message.getAddCreditsParams().getTransfer();

            body.setTransactionTime(transfer);
            ZhijiAddCreditsRequest request = new ZhijiAddCreditsRequest();
            request.setZhijiAddCreditsReqBody(body);
            LOGGER.info("【智几汽车】加积分请求，url:{},params:{}",zhiJiConfig.getAddCreditsUrl(),JSON.toJSONString(request));

            httpPost.setEntity(new StringEntity(JSON.toJSONString(request)));

            byte[] bytes = ZhiJiParamTool.hmacEncrypt(JSON.toJSONString(request));
            if (bytes == null) {
                LOGGER.warn("【智几汽车】加积参数加密异常，params:{},message:{}", JSON.toJSONString(request), JSON.toJSONString(message));
                return null;
            }
            httpPost.setHeader("Content-Type","application/json");
            httpPost.setHeader("charset","gbk");
            httpPost.setHeader("signature", Hex.encodeHexString(bytes));
            httpPost.setConfig(requestConfig);
            return httpPost;
        }catch (Exception e) {
            LOGGER.warn("【智几汽车】组装加积分接口参数失败",e);
            return null;
        }
    }

    @Override
    public HttpRequestBase getMqSubCreditsHttpRequest(SubCreditsMsgWrapper message) {
        try {
            //请求链接
            HttpPost httpPost = new HttpPost(zhiJiConfig.getSubCreditsUrl());
            Map<String, String> originData = AssembleTool.getUrlParams(getParamUrl(message.getHttpUrl()));
            LOGGER.info("智己-扣积分参数，params：{}", JSON.toJSONString(originData));
            Map<String, Object> requestParams = Maps.newHashMap();
            // 从url中取，是兑吧官方扣积分文档中的参数，会放在url
            requestParams.put("TransactionType", originData.get("description"));
            requestParams.put("RedeemNumber", originData.get("orderNum"));
            requestParams.put("TraceId", originData.get("orderNum") + ZhiJiParamTool.generateRandom());
            // 定制参数
            Map<String, String> customParams = message.getSubCreditsMsg().getParams();
            requestParams.put("superId", "1000000001788065");
            requestParams.put("RedeemTime", customParams.get("TransactionTime"));
            // 固定参数
            requestParams.put("SourceCode", "DUIBA");
            // data格式
            Map<String, Object> data = new HashMap<>(1);
            Map<String, Object> lostOfPointList = new HashMap<>(1);
            Map<String, String> pointList = new HashMap<>(2);
            pointList.put("Type", "Point");
            pointList.put("RedeemPoints", originData.get("credits"));
            lostOfPointList.put("PointList", pointList);
            data.put("ListOfPointList", lostOfPointList);
            requestParams.put("Data", data);
            // 请求参数先放入body中，加密，放入header
            Map<String, Object> body = new HashMap<>(1);
            body.put("body", requestParams);
            LOGGER.info("智己-扣积分参数，url：{}，body：{}，message：{}", zhiJiConfig.getSubCreditsUrl(), body, JSON.toJSONString(message));
            try {
                httpPost.setEntity(new StringEntity(JSON.toJSONString(body)));
            } catch (UnsupportedEncodingException e) {
                LOGGER.warn("智己-扣积分参数异常，body:{},message:{}", body, JSON.toJSONString(message), e);
                return null;
            }
            byte[] bytes = ZhiJiParamTool.hmacEncrypt(JSON.toJSONString(body));
            if (bytes == null) {
                LOGGER.warn("智己-扣积分参数加密异常，body:{},message:{}", body, JSON.toJSONString(message));
                return null;
            }
            httpPost.setHeader("Content-Type","application/json");
            httpPost.setHeader("charset","gbk");
            httpPost.setHeader("signature", Hex.encodeHexString(bytes));
            httpPost.setConfig(requestConfig);
            return httpPost;
        } catch (Exception e) {
            LOGGER.warn("智己-扣积分参数加密异常，message:{}", message, e);
            return null;
        }
    }

    /**
     * 智己积分返回参数解析
     * @param body
     * @param addCredits
     * @param authParams
     * @return
     */
    @Override
    public String parseCreditsRsp(String body, Boolean addCredits, Map<String, String> authParams) {
        LOGGER.info("智己-积分返回参数，params：{}", body);
        JSONObject response = JSON.parseObject(body);
        JSONObject result = new JSONObject();
        result.put("bizId", response.get("TxnId"));
        if (Objects.equals("0", response.get("ErrorCode"))) {
            result.put("status","ok");
        } else {
            result.put("status", "fail");
        }
        result.put("errorMessage", response.get("ErrorMessage"));
        return result.toJSONString();
    }

    public static String getParamUrl(String url) {
        return url.substring(url.indexOf('?') + 1);
    }
}
