package cn.com.duiba.constant;


import org.springframework.beans.factory.annotation.Value;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.stereotype.Component;

import java.util.Set;

/**
 * @author pengkai
 * @date 2019/11/18
 * @description: 工行卡中心配置文件
 */
@Component
@RefreshScope
public class IcbcElifeConfig {

    @Value("#{'${icbc.elife.appids}'.split(',')}")
    private Set<Long> appIds;

    @Value("${icbc.elife.appkey}")
    private String  appKey = "";

    @Value("${icbc.elife.appsecret}")
    private String  appSecret = "";
    @Value("${icbc.elife.publickey}")
    private String publicKey;
    @Value("${icbc.elife.platformcode}")
    private String platformCode;

    public Set<Long> getAppIds() {
        return appIds;
    }

    public void setAppIds(Set<Long> appIds) {
        this.appIds = appIds;
    }

    public String getAppKey() {
        return appKey;
    }

    public void setAppKey(String appKey) {
        this.appKey = appKey;
    }

    public String getAppSecret() {
        return appSecret;
    }

    public void setAppSecret(String appSecret) {
        this.appSecret = appSecret;
    }

    public String getPublicKey() {
        return publicKey;
    }

    public void setPublicKey(String publicKey) {
        this.publicKey = publicKey;
    }

    public String getPlatformCode() {
        return platformCode;
    }

    public void setPlatformCode(String platformCode) {
        this.platformCode = platformCode;
    }
}
