package cn.com.duiba.constant.zhiji;

import cn.com.duiba.biz.credits.strategy.ApiStrategyRouter;
import cn.com.duiba.biz.credits.strategy.Impl.ZhiJiApiStrategy;
import com.google.common.collect.Sets;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Configuration;

import javax.annotation.Resource;
import java.util.Set;

/**
 * @author: pengyi
 * @description: 智己汽车配置
 * @date: 2021/9/2 下午7:24
 */
@Configuration
@ConfigurationProperties(prefix = "zhiji")
public class ZhiJiConfig implements InitializingBean {

    private Set<Long> appIds = Sets.newHashSet(19592L);

    /**
     * 保存地址，用户中心
     */
    public  String saveAddressUrl = "https://m-uat.immotors.com:38443/umc-tsp/address/add";
    /**
     * 修改地址，用户中心
     */
    public  String updateAddressUrl = "https://m-uat.immotors.com:38443/umc-tsp/address/update";
    /**
     * 收货地址查询，用户中心
     */
    public  String selectUserAddressUrl = "https://m-uat.immotors.com:38443/umc-tsp/address/query";
    /**
     * 删除收货地址，用户中心
     */
    public  String removeAddressUrl = "https://m-uat.immotors.com:38443/umc-tsp/address/remove";
    /**
     * 查询行政区信息，用户中心
     */
    public  String selectDistrictUrl = "https://m-uat.immotors.com:38443/cmc-lbs/baseDistrict";
    /**
     * 查询用户信息，token校验，用户中心
     */
    public  String queryUserInfoUrl = "https://m-uat.immotors.com:38443/external/v1/user/info";
    /**
     * 推送消息，通知中心
     */
    public  String pushMessageUrl = "https://m-uat.immotors.com:38443/msg/sendPush";
    /**
     * 扣积分，礼赏中心
     */
    public  String subCreditsUrl = "https://crm-int-uat.immotors.com:38443/siebel/v1.0/service/IMMemberCenterTransaction/IMRedeemPoints";
    /**
     * 加积分，礼赏中心
     */
    public  String addCreditsUrl = "https://crm-int-uat.immotors.com:38443/siebel/v1.0/service/IMMemberCenterTransaction/IMAccruePoints";
    /**
     * 获取用户水晶（积分），礼赏中心
     */
    public  String userCreditsUrl = "https://crm-int-uat.immotors.com:38443/siebel/v1.0/service/points/getPoints";
    /**
     * 订单信息同步，订单中心
     */
    public  String syncOrderUrl = "https://crm-int-uat.immotors.com:38443/siebel/v1.0/service/weborderService/createWebOrderDetail";
    /**
     * 订单状态同步，订单中心
     */
    public  String syncOrderStatusUrl = "https://crm-int-uat.immotors.com:38443/siebel/v1.0/service/weborderService/updateWebOrderStatus";
    /**
     * 商品信息同步/更新，订单中心
     */
    public  String syncGoodsUrl = "https://crm-int-uat.immotors.com:38443/siebel/v1.0/service/weborderService/createWebProdutDetail";
    /**
     * 批量查询订单收货地址，订单中心
     */
    public  String queryOrderAddressListUrl = "https://crm-int-uat.immotors.com:38443/siebel/v1.0/service/weborderService/queryWebOrderList";
    /**
     * 奖品兑换验证接口，盲盒
     */
    public  String blindBoxVerifyUrl = "https://csop-uat.immotors.com:38443/fortunebox/api/app/external/validated/gift";
    /**
     * 奖品核销通知接口，盲盒
     */
    public  String notifyBlindBoxUrl = "https://csop-uat.immotors.com:38443/fortunebox/api/app/external/writeOff/gift";

    /**
     * 查询隐私协议，内容中心
     */
    public  String queryProtocolUrl = "https://m-uat.immotors.com:38443/cmc-protocol/protocol/query";
    /**
     * 查询隐私协议版本
     */
    public  String getProtocolVersionUrl = "https://m-uat.immotors.com:38443/cmc-protocol/protocol/getVersion";
    /**
     * 签署隐私协议
     */
    public  String signProtocolUrl = "https://m-uat.immotors.com:38443/cmc-protocol/protocol/sign";


    public Boolean isVerifyZhiJi(Long appId) {
        return this.appIds.contains(appId);
    }

    public Set<Long> getAppIds() {
        return appIds;
    }

    public void setAppIds(Set<Long> appIds) {
        this.appIds = appIds;
    }

    @Resource
    private ZhiJiApiStrategy zhiJiApiStrategy;

    @Override
    public void afterPropertiesSet() throws Exception {
        // 注册智己积分策略
        ApiStrategyRouter.register(appIds, zhiJiApiStrategy);
    }

    public String getSaveAddressUrl() {
        return saveAddressUrl;
    }

    public void setSaveAddressUrl(String saveAddressUrl) {
        this.saveAddressUrl = saveAddressUrl;
    }

    public String getUpdateAddressUrl() {
        return updateAddressUrl;
    }

    public void setUpdateAddressUrl(String updateAddressUrl) {
        this.updateAddressUrl = updateAddressUrl;
    }

    public String getSelectUserAddressUrl() {
        return selectUserAddressUrl;
    }

    public void setSelectUserAddressUrl(String selectUserAddressUrl) {
        this.selectUserAddressUrl = selectUserAddressUrl;
    }

    public String getRemoveAddressUrl() {
        return removeAddressUrl;
    }

    public void setRemoveAddressUrl(String removeAddressUrl) {
        this.removeAddressUrl = removeAddressUrl;
    }

    public String getSelectDistrictUrl() {
        return selectDistrictUrl;
    }

    public void setSelectDistrictUrl(String selectDistrictUrl) {
        this.selectDistrictUrl = selectDistrictUrl;
    }

    public String getQueryUserInfoUrl() {
        return queryUserInfoUrl;
    }

    public void setQueryUserInfoUrl(String queryUserInfoUrl) {
        this.queryUserInfoUrl = queryUserInfoUrl;
    }

    public String getPushMessageUrl() {
        return pushMessageUrl;
    }

    public void setPushMessageUrl(String pushMessageUrl) {
        this.pushMessageUrl = pushMessageUrl;
    }

    public String getSubCreditsUrl() {
        return subCreditsUrl;
    }

    public void setSubCreditsUrl(String subCreditsUrl) {
        this.subCreditsUrl = subCreditsUrl;
    }

    public String getAddCreditsUrl() {
        return addCreditsUrl;
    }

    public void setAddCreditsUrl(String addCreditsUrl) {
        this.addCreditsUrl = addCreditsUrl;
    }

    public String getUserCreditsUrl() {
        return userCreditsUrl;
    }

    public void setUserCreditsUrl(String userCreditsUrl) {
        this.userCreditsUrl = userCreditsUrl;
    }

    public String getSyncOrderUrl() {
        return syncOrderUrl;
    }

    public void setSyncOrderUrl(String syncOrderUrl) {
        this.syncOrderUrl = syncOrderUrl;
    }

    public String getSyncOrderStatusUrl() {
        return syncOrderStatusUrl;
    }

    public void setSyncOrderStatusUrl(String syncOrderStatusUrl) {
        this.syncOrderStatusUrl = syncOrderStatusUrl;
    }

    public String getSyncGoodsUrl() {
        return syncGoodsUrl;
    }

    public void setSyncGoodsUrl(String syncGoodsUrl) {
        this.syncGoodsUrl = syncGoodsUrl;
    }

    public String getQueryOrderAddressListUrl() {
        return queryOrderAddressListUrl;
    }

    public void setQueryOrderAddressListUrl(String queryOrderAddressListUrl) {
        this.queryOrderAddressListUrl = queryOrderAddressListUrl;
    }

    public String getBlindBoxVerifyUrl() {
        return blindBoxVerifyUrl;
    }

    public void setBlindBoxVerifyUrl(String blindBoxVerifyUrl) {
        this.blindBoxVerifyUrl = blindBoxVerifyUrl;
    }

    public String getNotifyBlindBoxUrl() {
        return notifyBlindBoxUrl;
    }

    public void setNotifyBlindBoxUrl(String notifyBlindBoxUrl) {
        this.notifyBlindBoxUrl = notifyBlindBoxUrl;
    }

    public String getQueryProtocolUrl() {
        return queryProtocolUrl;
    }

    public void setQueryProtocolUrl(String queryProtocolUrl) {
        this.queryProtocolUrl = queryProtocolUrl;
    }

    public String getGetProtocolVersionUrl() {
        return getProtocolVersionUrl;
    }

    public void setGetProtocolVersionUrl(String getProtocolVersionUrl) {
        this.getProtocolVersionUrl = getProtocolVersionUrl;
    }

    public String getSignProtocolUrl() {
        return signProtocolUrl;
    }

    public void setSignProtocolUrl(String signProtocolUrl) {
        this.signProtocolUrl = signProtocolUrl;
    }

    public ZhiJiApiStrategy getZhiJiApiStrategy() {
        return zhiJiApiStrategy;
    }

    public void setZhiJiApiStrategy(ZhiJiApiStrategy zhiJiApiStrategy) {
        this.zhiJiApiStrategy = zhiJiApiStrategy;
    }
}
