package cn.com.duiba.dao.impl;

import java.util.HashMap;
import java.util.Map;

import cn.com.duiba.constant.DatabaseSchema;
import org.springframework.stereotype.Repository;

import cn.com.duiba.dao.BaseDAO;
import cn.com.duiba.dao.ThirdpartyRelationDAO;
import cn.com.duiba.domain.ThirdpartyRelationDO;

/**
 * 把兑吧String类型的订单号转为Long, 给只支持Long类型的第三方用
 * 
 * @author Administrator
 *
 */
@Repository
public class ThirdpartyRelationDAOImpl extends BaseDAO implements ThirdpartyRelationDAO {

	@Override
	public Long save(String duibaOrderNum) {
		ThirdpartyRelationDO releation = new ThirdpartyRelationDO();
		releation.setOrderNum(duibaOrderNum);
		getSqlSession().insert(getStamentNameSpace("insert"), releation);
		return releation.getId();
	}

	@Override
	public Long findByOrderNum(String orderNum) {
		Map<String, Object> params = new HashMap<>();
		params.put("orderNum", orderNum);
		return getSqlSession().selectOne(getStamentNameSpace("findByOrderNum"), params);
	}

	@Override
	protected DatabaseSchema chooseSchema() {
		return DatabaseSchema.CREDITS;
	}
}
