package cn.com.duiba.tool.huawei;

import org.apache.commons.lang.StringUtils;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

/**
 * Url工具类
 */
public class UrlUtils {

    /**
     * 解析出url参数中的键值对,
     * 如 "http://www.baidu.com/index.jsp?Action=del&id=123"，解析出Action:del,id:123存入map中
     *
     * @param url url地址
     * @return url请求参数部分
     */
    public static Map<String, String> extractUrlParamsFromUrl(String url) {
        String queryString = truncateQueryString(url);
        if (queryString == null) {
            return Collections.emptyMap();
        }
        return extractUrlParams(queryString);
    }

    /**
     * 解析出url参数中的键值对 如 "action=del&id=123"，解析出action:del,id:123存入map中
     * (注意：此方法对类似a=1&a=2的字符串支持不友好)
     */
    public static Map<String, String> extractUrlParams(String queryString) {
        if (StringUtils.isBlank(queryString)) {
            return Collections.emptyMap();
        }
        Map<String, String> mapRequest = new HashMap<>();
        String[] arrSplit;
        // 每个键值为一组
        arrSplit = StringUtils.split(queryString,'&');
        for (String strSplit : arrSplit) {
            String[] arrSplitEqual = StringUtils.split(strSplit, '=');
            // 解析出键值
            if (arrSplitEqual.length > 1) {
                // 正确解析
                try {
                    mapRequest.put(arrSplitEqual[0], URLDecoder.decode(arrSplitEqual[1], StandardCharsets.UTF_8.name()));
                } catch (UnsupportedEncodingException e) {
                    throw new IllegalStateException(e);
                }
            } else {
                if (!arrSplitEqual[0].equals("")) {
                    // 只有参数没有值，加入空字符
                    mapRequest.put(arrSplitEqual[0], "");
                }
            }
        }
        return mapRequest;
    }

    /**
     * 去掉url中的路径，留下请求参数部分
     *
     * @param strURL url地址
     * @return url请求参数部分
     */
    private static String truncateQueryString(String strURL) {
        String url = StringUtils.trimToEmpty(strURL);

        int idx = url.indexOf('?');
        if(idx == -1) {
            return null;
        }
        return url.substring(idx + 1);
    }
}
