/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.biz.credits;

import cn.com.duiba.api.enums.SubjectTypeEnum;
import cn.com.duiba.client.FuLuClient;
import cn.com.duiba.constant.ChangChengConfig;
import cn.com.duiba.domain.SupplierRequest;
import cn.com.duiba.dto.fulu.FuLuBaseResp;
import cn.com.duiba.tool.AssembleTool;
import com.alibaba.fastjson.JSON;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpRequestBase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ChangChengApi {
    private static final Logger log = LoggerFactory.getLogger(ChangChengApi.class);
    @Autowired
    private ChangChengConfig changChengConfig;
    @Autowired
    private FuLuClient fuLuClient;

    public Boolean isChangCheng(Long appId) {
        Set<Long> appIds = this.changChengConfig.getAppIds();
        if (CollectionUtils.isEmpty(appIds)) {
            return false;
        }
        return appIds.contains(appId);
    }

    public HttpRequestBase getVirtualRequest(SupplierRequest request) {
        log.info("\u957f\u57ce\u865a\u62df\u5151\u6362SupplierRequest:{}", (Object)JSON.toJSONString((Object)request));
        String goodsNum = this.getGoodsNum(request);
        if (StringUtils.isNotBlank((CharSequence)goodsNum) && goodsNum.startsWith(this.changChengConfig.getFuluPrefix())) {
            return this.fuLuClient.getFuLuDirectRequest(request, goodsNum.replace(this.changChengConfig.getFuluPrefix(), ""), SubjectTypeEnum.DUIA.getType());
        }
        return new HttpGet(request.getHttpUrl());
    }

    public String getVirtualResponse(SupplierRequest request, String body, String callbackTopic, String msgTag, String msgKey) {
        log.info("\u798f\u7984\u76f4\u5145\u8fd4\u56de body:{},request:{}", (Object)body, (Object)JSON.toJSONString((Object)request));
        String goodsNum = this.getGoodsNum(request);
        if (StringUtils.isNotBlank((CharSequence)goodsNum) && goodsNum.startsWith(this.changChengConfig.getFuluPrefix())) {
            Map<String, String> duibaDoc = new HashMap<String, String>();
            try {
                FuLuBaseResp fuluBaseResp = (FuLuBaseResp)JSON.parseObject((String)body, FuLuBaseResp.class);
                duibaDoc = this.fuLuClient.getDuibaVirtualResponse(request, fuluBaseResp, callbackTopic, msgTag, msgKey);
            }
            catch (Exception e) {
                log.error("fulu\uff0c\u5145\u503c\u5546\u54c1\u5b9a\u5236\uff0c\u7ed3\u679c\u89e3\u6790\u9519\u8bef:{}", (Object)body, (Object)e);
                duibaDoc.put("status", "fail");
                duibaDoc.put("errorMessage", "\u798f\u7984\u76f4\u5145\u54cd\u5e94\u89e3\u6790\u9519\u8bef");
            }
            return JSON.toJSONString(duibaDoc);
        }
        return body;
    }

    private String getGoodsNum(SupplierRequest request) {
        String url = request.getHttpUrl();
        String paramsStr = url.substring(url.indexOf(63) + 1);
        Map<String, String> params = AssembleTool.getUrlParams(paramsStr);
        String goodsNum = params.get("params");
        return goodsNum;
    }
}

