/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.biz.credits;

import cn.com.duiba.api.bo.subcredits.SubCreditsMsgDto;
import cn.com.duiba.biz.Exception.ThirdpatyException;
import cn.com.duiba.biz.credits.InoherbApi;
import cn.com.duiba.constant.InoherbConstant;
import cn.com.duiba.constant.NewInoherbConfig;
import cn.com.duiba.domain.SubCreditsMsgWrapper;
import cn.com.duiba.domain.SupplierRequest;
import cn.com.duiba.thirdparty.dto.CreditsMessageDto;
import cn.com.duiba.tool.AssembleTool;
import cn.com.duiba.tool.InoherbTools;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Maps;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Resource;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.message.BasicNameValuePair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class NewInoherbApi {
    @Resource
    private NewInoherbConfig inoherbConfig;
    @Resource
    private InoherbConstant inoherbConstant;
    @Resource
    private InoherbApi oldInoherbApi;
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private static final String VIRTUAL_CREDITS_PREFIX = "xybc_virtual_credits";

    public boolean isNewInoherb(Long appId) {
        return this.inoherbConfig.getAppIds().contains(appId);
    }

    public HttpRequestBase getAddCreditsHttpRequest(CreditsMessageDto message) {
        return this.inoherbConfig.isNewLogic() ? this.genCreditsRequest(this.assembleRequestData(message.getAuthParams(), false), InoherbTools.getHostName(message)) : this.oldInoherbApi.getAddCreditsHttpRequest(message);
    }

    public HttpRequestBase getSubCreditsHttpRequest(SubCreditsMsgWrapper message) {
        if (this.inoherbConfig.isNewLogic()) {
            SubCreditsMsgDto subCreditsMsg = message.getSubCreditsMsg();
            return this.genCreditsRequest(this.assembleRequestData(subCreditsMsg.getAuthParams(), true), InoherbTools.getHostName(message));
        }
        return this.oldInoherbApi.getSubCreditsHttpRequest(message);
    }

    public HttpPost genCreditsRequest(Map<String, Object> params, String host) {
        HttpPost httpPost = new HttpPost(host);
        ArrayList<BasicNameValuePair> list = new ArrayList<BasicNameValuePair>();
        Set<String> keySet = params.keySet();
        for (String key : keySet) {
            Object value = params.get(key);
            if (value instanceof JSONObject) {
                list.add(new BasicNameValuePair(key, JSON.toJSONString((Object)value)));
                continue;
            }
            list.add(new BasicNameValuePair(key, String.valueOf(value)));
        }
        if (list.size() > 0) {
            try {
                this.log.info("\u76f8\u5b9c\u672c\u8349 \u52a0\u51cf\u79ef\u5206\u8bf7\u6c42\u53c2\u6570 = {}", list);
                httpPost.setEntity((HttpEntity)new UrlEncodedFormEntity(list, "UTF-8"));
            }
            catch (UnsupportedEncodingException e) {
                this.log.error("\u76f8\u5b9c\u672c\u8349\u751f\u6210entity\u9519\u8bef = {}", (Object)e.getMessage());
                throw new ThirdpatyException(e);
            }
        }
        return httpPost;
    }

    private Map<String, Object> assembleRequestData(Map<String, String> originData, boolean isSub) {
        return this.assembleRequestData(originData, isSub, false);
    }

    private Map<String, Object> assembleRequestData(Map<String, String> originData, boolean isSub, boolean isVirtual) {
        HashMap params = Maps.newHashMap();
        params.put("app_id", this.inoherbConfig.getDeveloperAppId());
        JSONObject requestData = new JSONObject();
        requestData.put("unionId", (Object)originData.get("uid"));
        if (isVirtual) {
            String num = originData.get("params");
            String[] s = StringUtils.split((String)num, (String)"_");
            requestData.put("changeIntegral", (Object)new BigDecimal(s[this.inoherbConfig.getVirtualCreditsIndex()]));
        } else {
            requestData.put("changeIntegral", (Object)new BigDecimal(originData.get("credits")));
        }
        requestData.put("uuid", (Object)originData.get("orderNum"));
        int processType = isVirtual ? InoherbTools.locateVirtualProcessType(this.inoherbConfig) : InoherbTools.locateProcessType(originData, this.inoherbConfig, isSub);
        int issueType = InoherbTools.locateIssueType(processType, this.inoherbConfig);
        if (!isSub) {
            requestData.put("issueType", (Object)issueType);
        }
        requestData.put("processType", (Object)processType);
        params.put("requestData", requestData);
        params.put("sign", InoherbTools.genSign(params, this.inoherbConfig.getDevelopSecret()));
        return params;
    }

    public String parseCreditsResponse(String body, Boolean addCredits, Map<String, String> authParams) {
        if (!this.inoherbConfig.isNewLogic()) {
            return this.oldInoherbApi.parseCreditsResponse(body, addCredits, authParams);
        }
        this.log.info("\u76f8\u5b9c\u672c\u8349\u52a0\u51cf\u79ef\u5206response, add={}, body={}, authParams={}", new Object[]{addCredits, body, JSON.toJSONString(authParams)});
        JSONObject responseBody = JSON.parseObject((String)body);
        JSONObject result = new JSONObject();
        if (Objects.equals("0", responseBody.getString("code"))) {
            result.put("status", (Object)"ok");
            result.put("bizId", (Object)(System.currentTimeMillis() + RandomStringUtils.randomNumeric((int)6)));
            result.put("credits", (Object)responseBody.getString("data"));
        } else {
            result.put("status", (Object)"fail");
            result.put("errorMessage", (Object)responseBody.getString("message"));
        }
        return result.toString();
    }

    public HttpRequestBase getVirtualRequest(SupplierRequest request) {
        if (!this.inoherbConfig.isNewLogic()) {
            return this.oldInoherbApi.getVirtualRequest(request);
        }
        String url = request.getHttpUrl();
        String newUrl = url.substring(0, url.indexOf(63));
        String paramsStr = url.substring(url.indexOf(63) + 1);
        Map<String, String> authParams = AssembleTool.getUrlParams(paramsStr);
        String tmp = authParams.get("params");
        this.log.info("\u76f8\u5b9c\u672c\u8349 \u865a\u62df\u5546\u54c1\u53d1\u8d27 \u5546\u54c1\u53f7 = {}", (Object)tmp);
        if (StringUtils.isBlank((CharSequence)tmp)) {
            throw new ThirdpatyException("\u76f8\u5b9c\u672c\u8349 \u865a\u62df\u5546\u54c1\u53d1\u8d27 \u5546\u54c1\u53f7\u4e3a\u7a7a");
        }
        if (tmp.contains(VIRTUAL_CREDITS_PREFIX)) {
            this.log.info("\u76f8\u5b9c\u672c\u8349 \u865a\u62df\u5546\u54c1\u53d1\u8d27 \u52a0\u79ef\u5206\u539f\u59cb\u6570\u636e = {}", authParams);
            return this.genCreditsRequest(this.assembleRequestData(authParams, false, true), this.inoherbConfig.getVirtualProductAddCreditsUrl());
        }
        String timestamp = String.valueOf(System.currentTimeMillis());
        String[] params = StringUtils.split((String)authParams.get("params"), (String)"|");
        HashMap body = Maps.newHashMap();
        body.put("code", "sendCouponsInfo");
        body.put("unionId", authParams.get("uid"));
        body.put("cardId", params[0]);
        body.put("money", params[1]);
        body.put("activityId", String.valueOf(System.currentTimeMillis() / 1000L));
        body.put("timestamp", timestamp);
        body.put("token", this.getToken(timestamp));
        this.log.info("\u76f8\u5b9c\u672c\u8349 \u865a\u62df\u5546\u54c1\u53d1\u8d27 url = {}, \u6570\u636e = {}", (Object)newUrl, (Object)JSON.toJSONString((Object)body));
        request.setHttpUrl(newUrl);
        request.setAuthParams(body);
        return this.getHttpPost(newUrl, JSON.toJSONString((Object)body));
    }

    private HttpRequestBase getHttpPost(String httpUrl, String jsonBody) {
        HttpPost request = new HttpPost(httpUrl);
        request.setEntity((HttpEntity)new StringEntity(jsonBody, ContentType.APPLICATION_JSON));
        return request;
    }

    public String getToken(String timestamp) {
        return DigestUtils.md5Hex((String)(this.inoherbConstant.getDeveloperThirdPartySecret() + timestamp)).toUpperCase();
    }

    public String getVirtualResponse(SupplierRequest message, String body) {
        if (!this.inoherbConfig.isNewLogic()) {
            return this.oldInoherbApi.getVirtualResponse(message, body);
        }
        JSONObject responseBody = JSON.parseObject((String)body);
        JSONObject result = new JSONObject();
        if (responseBody.containsKey((Object)"status")) {
            if (!Objects.equals(1, responseBody.getInteger("status"))) {
                result.put("status", (Object)"fail");
                result.put("errorMessage", ObjectUtils.firstNonNull((Object[])new String[]{responseBody.getString("refusereason"), responseBody.getString("msg")}));
            } else {
                result.put("status", (Object)"success");
            }
        } else if (Objects.equals("0", responseBody.getString("code"))) {
            result.put("status", (Object)"success");
        } else {
            result.put("status", (Object)"fail");
            result.put("errorMessage", (Object)responseBody.getString("message"));
        }
        return result.toString();
    }
}

