/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.biz.credits.impl;

import cn.com.duiba.biz.credits.CiticApi;
import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.constant.CiticBankConfig;
import cn.com.duiba.credits.sdk.SignTool;
import cn.com.duiba.dao.AppDAO;
import cn.com.duiba.domain.AppDO;
import cn.com.duiba.domain.SupplierRequest;
import cn.com.duiba.tool.AssembleTool;
import cn.com.duiba.tool.JsonTool;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.time.Instant;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class CiticApiImpl
implements CiticApi {
    private static final Logger LOGGER = LoggerFactory.getLogger(CiticApiImpl.class);
    @Autowired
    private CiticBankConfig citicBankConfig;
    @Autowired
    private AppDAO appDAO;

    @Override
    public Boolean isCiticApp(Long appId) {
        return this.citicBankConfig.getAppIdSet().contains(appId);
    }

    @Override
    public SupplierRequest getVirturalRequest(SupplierRequest request) {
        try {
            String url = request.getHttpUrl();
            List<String> analysisList = CiticApiImpl.analysisUrl(url);
            if (CollectionUtils.isEmpty(analysisList)) {
                return request;
            }
            String host = analysisList.get(0);
            Map<String, String> params = AssembleTool.getUrlParams(analysisList.get(1));
            request.setHttpUrl(AssembleTool.assembleUrl(host, this.rebuildVirtualParams(params, Long.valueOf(request.getAppId()))));
        }
        catch (Exception e) {
            LOGGER.info("[CiticApiImpl-getVirturalRequest] Params:[request={}], Msg:\u5357\u4eac\u4e2d\u4fe1\u94f6\u884c-\u865a\u62df\u5546\u54c1\u5b9a\u5236\u903b\u8f91\u5f02\u5e38", (Object)JSONObject.toJSONString((Object)request), (Object)e);
        }
        return request;
    }

    @Override
    public String getVirturalResponse(SupplierRequest message, String body) {
        HashMap<String, String> duibaDoc = new HashMap<String, String>();
        try {
            JSONObject resultJson = JSONObject.parseObject((String)body);
            if (null == resultJson) {
                throw new BizException("\u5f00\u53d1\u8005\u63a5\u53e3\u54cd\u5e94\u5185\u5bb9\u5f02\u5e38");
            }
            String status = resultJson.getString("status");
            if (!Objects.equals("ok", status)) {
                throw new BizException(resultJson.getString("errorMessage"));
            }
            duibaDoc.put("status", "success");
            duibaDoc.put("data", resultJson.toString());
        }
        catch (Exception e) {
            duibaDoc.put("status", "fail");
            duibaDoc.put("errorMessage", e.getMessage());
            LOGGER.info("[CiticApiImpl-getVirturalResponse] Params:[message={},body={}], Msg:\u5357\u4eac\u4e2d\u4fe1\u94f6\u884c-\u865a\u62df\u5546\u54c1\u63a5\u53e3\u54cd\u5e94\u89e3\u6790\u5f02\u5e38", new Object[]{JSONObject.toJSONString((Object)message), body, e});
        }
        return JsonTool.objectToJson(duibaDoc);
    }

    private Map<String, String> rebuildVirtualParams(Map<String, String> params, Long appId) {
        HashMap signParams = Maps.newHashMap();
        AppDO app = this.appDAO.getAppByCache(appId);
        signParams.put("appKey", app.getAppKey());
        signParams.put("uid", params.get("uid"));
        signParams.put("credits", params.get("params"));
        signParams.put("type", "virtual");
        signParams.put("orderNum", params.get("orderNum"));
        signParams.put("timestamp", String.valueOf(Instant.now().getEpochSecond()));
        signParams.put("description", params.get("description"));
        signParams.put("appSecret", this.appDAO.getAppSecret(app));
        signParams.put("sign", SignTool.sign((Map)signParams));
        signParams.remove("appSecret");
        return signParams;
    }

    private static List<String> analysisUrl(String url) {
        ArrayList analysis = Lists.newArrayList();
        if (StringUtils.isNotBlank((CharSequence)url)) {
            int index = url.indexOf("?");
            if (index != -1) {
                analysis.add(url.substring(0, index));
                analysis.add(url.substring(index + 1, url.length()));
            } else {
                analysis.add(url);
                analysis.add("");
            }
        }
        return analysis;
    }
}

