/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.biz.credits.strategy.Impl;

import cn.com.duiba.api.enums.ActivityUniformityTypeEnum;
import cn.com.duiba.biz.credits.strategy.ApiStrategy;
import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.constant.WandaConfig;
import cn.com.duiba.domain.SubCreditsMsgWrapper;
import cn.com.duiba.domain.SupplierRequest;
import cn.com.duiba.enums.wanda.WandaErrorCode;
import cn.com.duiba.enums.wanda.WandaRequestStatus;
import cn.com.duiba.notifycenter.domain.NotifyQueueDO;
import cn.com.duiba.thirdparty.dto.CreditsMessageDto;
import cn.com.duiba.tool.AssembleTool;
import cn.com.duiba.wolf.utils.UrlUtils2;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Maps;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class WandaApiStrategy
implements ApiStrategy {
    private static final String COMPANY_CODE = "companyCode";
    private static final String GRANT_TYPE = "grantType";
    private static final String ACCOUNT = "account";
    private static final String PASSWORD = "password";
    private static final String ACCESS_TOKEN = "accessToken";
    private static final String SUCCESS = "Success";
    private static final long SUCCESS_CODE = 200L;
    private static final String RESPONSE_CODE = "responseCode";
    private static final String VIRTUAL = "virtual";
    private static final String TRUE = "true";
    private final Logger LOGGER = LoggerFactory.getLogger(this.getClass());
    @Resource
    private WandaConfig wandaConfig;
    @Resource(name="httpClient")
    private CloseableHttpClient httpClient;
    private final RequestConfig config = RequestConfig.custom().setConnectTimeout(5000).setSocketTimeout(10000).setConnectionRequestTimeout(500).build();
    private static final int FIVE_SECONDS = 5000;
    private static final int TEN_SECONDS = 10000;

    @Override
    public HttpRequestBase getMqSubCreditsHttpRequest(SubCreditsMsgWrapper message) {
        try {
            String accessToken = this.getToken();
            this.LOGGER.info("[\u4e07\u8fbe\u9152\u5e97]\u63a5\u53e3\u6388\u6743accessToken = [{}]", (Object)accessToken);
            String url = WandaApiStrategy.getHostName(message.getHttpUrl());
            HttpPost httpPost = new HttpPost(url);
            Map<String, String> originData = AssembleTool.getUrlParams(WandaApiStrategy.getParamUrl(message.getHttpUrl()));
            this.LOGGER.info("[\u4e07\u8fbe\u9152\u5e97]\u51cf\u79ef\u5206originData = [{}]", (Object)JSON.toJSONString(originData));
            HashMap params = Maps.newHashMap();
            httpPost.setHeader("Authentication", accessToken);
            params.put("cardNo", originData.get("uid"));
            params.put("orderNumber", originData.get("orderNum"));
            params.put("points", Integer.parseInt(originData.get("credits")));
            params.put("transactionNumber", originData.get("orderNum"));
            String type = Optional.ofNullable(originData.get("type")).orElse("");
            Map data = Optional.ofNullable(message.getSubCreditsMsg().getParams()).orElse(Maps.newHashMap());
            String isDuibaItem = (String)data.get("isDuibaItem");
            params.put("storeCode", this.wandaConfig.getDefaultStoreCode());
            params.put("remarks", originData.get("description"));
            this.LOGGER.info("[\u4e07\u8fbe\u9152\u5e97]\u6263\u51cf\u79ef\u5206\u53c2\u6570 = [{}]", (Object)JSON.toJSONString((Object)params));
            httpPost.setEntity((HttpEntity)new StringEntity(JSON.toJSONString((Object)params), ContentType.APPLICATION_JSON));
            httpPost.setConfig(this.config);
            message.setHttpUrl(url);
            message.getSubCreditsMsg().setAuthParams(params.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> String.valueOf(entry.getValue()))));
            return httpPost;
        }
        catch (Exception e) {
            this.LOGGER.info("[\u4e07\u8fbe\u9152\u5e97]\u6263\u51cf\u79ef\u5206\u8bf7\u6c42\u751f\u6210\u5931\u8d25", (Throwable)e);
            throw new IllegalStateException(e);
        }
    }

    @Override
    public HttpRequestBase getAddCreditsMessageRequest(CreditsMessageDto message) {
        try {
            String accessToken = this.getToken();
            this.LOGGER.info("[\u4e07\u8fbe\u9152\u5e97]\u63a5\u53e3\u6388\u6743accessToken = [{}]", (Object)accessToken);
            Map<String, String> originData = AssembleTool.getUrlParams(WandaApiStrategy.getParamUrl(message.getHttpUrl()));
            this.LOGGER.info("[\u4e07\u8fbe\u9152\u5e97]\u52a0\u79ef\u5206originData = [{}]", (Object)JSON.toJSONString(originData));
            String url = WandaApiStrategy.getHostName(message.getHttpUrl());
            HttpPost httpPost = new HttpPost(url);
            HashMap params = Maps.newHashMap();
            httpPost.setHeader("Authentication", accessToken);
            params.put("cardNo", originData.get("uid"));
            params.put("orderNumber", originData.get("orderNum"));
            params.put("points", Integer.parseInt(originData.get("credits")));
            String relationType = message.getRelationType();
            if (ActivityUniformityTypeEnum.SIGN_CALENDAR_COMPONENT.getCode().toString().equals(relationType)) {
                params.put("pointType", "PointsMall_S");
            }
            params.put("storeCode", this.wandaConfig.getDefaultStoreCode());
            params.put("remarks", originData.get("description"));
            params.put("transactionNumber", originData.get("orderNum"));
            this.LOGGER.info("[\u4e07\u8fbe\u9152\u5e97]\u52a0\u79ef\u5206\u8bf7\u6c42\u53c2\u6570 = [{}]", (Object)JSON.toJSONString((Object)params));
            httpPost.setEntity((HttpEntity)new StringEntity(JSON.toJSONString((Object)params), ContentType.APPLICATION_JSON));
            httpPost.setConfig(this.config);
            message.setHttpUrl(url);
            message.setAuthParams(params.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> String.valueOf(entry.getValue()))));
            return httpPost;
        }
        catch (Exception e) {
            this.LOGGER.info("[\u4e07\u8fbe\u9152\u5e97]\u52a0\u79ef\u5206\u8bf7\u6c42\u751f\u6210\u5931\u8d25", (Throwable)e);
            throw new IllegalStateException(e);
        }
    }

    @Override
    public String parseCreditsRsp(String body, Boolean addCredits, Map<String, String> authParams) {
        JSONObject responseBody = JSON.parseObject((String)body);
        this.LOGGER.info("[\u4e07\u8fbe\u9152\u5e97]\u79ef\u5206\u8fd4\u56debody=[{}]", (Object)body);
        JSONObject result = new JSONObject();
        if (Objects.equals(SUCCESS, responseBody.getString(RESPONSE_CODE))) {
            result.put("status", (Object)"ok");
            result.put("bizId", (Object)(System.currentTimeMillis() + RandomStringUtils.randomNumeric((int)6)));
        } else {
            result.put("status", (Object)"fail");
            result.put("errorMessage", (Object)responseBody.getString("message"));
        }
        try {
            this.LOGGER.info("[\u4e07\u8fbe\u9152\u5e97] parseCreditsRsp#authParams = {}", (Object)JSON.toJSONString(authParams));
            Long credits = this.queryCredits(authParams.get("cardNo"));
            result.put("credits", (Object)credits);
        }
        catch (Exception e) {
            this.LOGGER.error("[\u4e07\u8fbe\u9152\u5e97] \u67e5\u8be2\u7528\u6237\u79ef\u5206\u5931\u8d25", (Throwable)e);
            return result.toString();
        }
        return result.toString();
    }

    @Override
    public HttpRequestBase getVirtualRequest(SupplierRequest request) {
        try {
            String accessToken = this.getToken();
            this.LOGGER.info("[\u4e07\u8fbe\u9152\u5e97]\u63a5\u53e3\u6388\u6743accessToken = [{}]", (Object)accessToken);
            String url = UrlUtils2.extractUrl((String)request.getHttpUrl());
            Map originData = UrlUtils2.extractUrlParamsFromUrl((String)request.getHttpUrl());
            this.LOGGER.info("[\u4e07\u8fbe\u9152\u5e97]\u865a\u62df\u5546\u54c1\u5151\u6362originData = [{}]", (Object)JSON.toJSONString((Object)originData));
            HttpPost httpPost = new HttpPost(url);
            HashMap params = Maps.newHashMap();
            httpPost.setHeader("Authentication", accessToken);
            params.put("cardNo", originData.get("uid"));
            String splitter = "_";
            String codeAndStoreCode = (String)originData.get("params");
            if (!StringUtils.isNotBlank((String)codeAndStoreCode) || !codeAndStoreCode.contains("_")) {
                throw new IllegalStateException("\u865a\u62df\u5546\u54c1\u5546\u5bb6\u7f16\u7801\u683c\u5f0f\u5f02\u5e38[" + codeAndStoreCode + "]");
            }
            String[] splitStrs = codeAndStoreCode.split("_");
            params.put("code", splitStrs[0]);
            params.put("count", "1");
            params.put("transactionNumber", originData.get("orderNum"));
            this.LOGGER.info("[\u4e07\u8fbe\u9152\u5e97]\u865a\u62df\u5546\u54c1\u5151\u6362\u53c2\u6570 = [{}]", (Object)JSON.toJSONString((Object)params));
            httpPost.setEntity((HttpEntity)new StringEntity(JSON.toJSONString((Object)params), ContentType.APPLICATION_JSON));
            httpPost.setConfig(this.config);
            request.setAuthParams(params);
            request.setHttpUrl(url);
            return httpPost;
        }
        catch (Exception e) {
            this.LOGGER.info("[\u4e07\u8fbe\u9152\u5e97]\u865a\u62df\u5546\u54c1\u5151\u6362\u8bf7\u6c42\u751f\u6210\u5931\u8d25 orderId=" + request.getOrderId(), (Throwable)e);
            throw new IllegalStateException(e);
        }
    }

    @Override
    public String getVirtualResponse(SupplierRequest request, String body) {
        JSONObject result = new JSONObject();
        try {
            JSONObject responseJson = JSONObject.parseObject((String)body);
            this.LOGGER.info("[\u4e07\u8fbe\u9152\u5e97]\u865a\u62df\u5546\u54c1\u5151\u6362body=[{}]", (Object)body);
            Long responseCode = Optional.ofNullable(responseJson.getLong("code")).orElse(-1L);
            if (responseCode == 200L) {
                result.put("status", (Object)"success");
            } else {
                result.put("status", (Object)"fail");
                result.put("errorMessage", (Object)responseJson.getString("message"));
            }
        }
        catch (Exception e) {
            result.put("status", (Object)"fail");
            result.put("errorMessage", (Object)e.getMessage());
            this.LOGGER.info("[\u4e07\u8fbe\u9152\u5e97]\u89e3\u6790\u865a\u62df\u5546\u54c1\u5151\u6362\u8bf7\u6c42\u7ed3\u679c\u5f02\u5e38 orderId=" + request.getOrderId(), (Throwable)e);
        }
        return result.toJSONString();
    }

    @Override
    public HttpRequestBase getRequestNotify(String notifyUrl, NotifyQueueDO record) {
        if (record.getResult().booleanValue()) {
            throw new IllegalStateException("\u5151\u6362\u6210\u529f\u4e0d\u80fd\u56de\u9000\u79ef\u5206");
        }
        try {
            String accessToken = this.getToken();
            this.LOGGER.info("[\u4e07\u8fbe\u9152\u5e97]\u63a5\u53e3\u6388\u6743accessToken = [{}]", (Object)accessToken);
            HttpPost httpPost = new HttpPost(notifyUrl);
            HashMap params = Maps.newHashMap();
            httpPost.setHeader("Authentication", accessToken);
            params.put("cardNo", record.getPartnerUserId());
            params.put("orderNumber", record.getDuibaOrderNum());
            params.put("transactionNumber", record.getDuibaOrderNum());
            this.LOGGER.info("[\u4e07\u8fbe\u9152\u5e97]\u79ef\u5206\u56de\u9000\u53c2\u6570 = [{}]", (Object)JSON.toJSONString((Object)params));
            httpPost.setEntity((HttpEntity)new StringEntity(JSON.toJSONString((Object)params), ContentType.APPLICATION_JSON));
            httpPost.setConfig(this.config);
            return httpPost;
        }
        catch (Exception e) {
            this.LOGGER.info("[\u4e07\u8fbe\u9152\u5e97]\u79ef\u5206\u56de\u9000\u8bf7\u6c42\u751f\u6210\u5931\u8d25 orderId=" + record.getDuibaOrderNum().replace("C", ""), (Throwable)e);
            throw new IllegalStateException(e);
        }
    }

    @Override
    public String getResponseNotify(String body) {
        try {
            JSONObject responseJson = JSONObject.parseObject((String)body);
            String responseCode = responseJson.getString(RESPONSE_CODE);
            if (SUCCESS.equals(responseCode)) {
                return "ok";
            }
        }
        catch (Exception e) {
            this.LOGGER.info("[\u4e07\u8fbe\u9152\u5e97]\u89e3\u6790\u79ef\u5206\u56de\u9000\u8bf7\u6c42\u7ed3\u679c\u5f02\u5e38", (Throwable)e);
        }
        return body;
    }

    public String getToken() throws Exception {
        HttpPost httpPost = new HttpPost(this.wandaConfig.getQueryTokenUrl());
        ArrayList<BasicNameValuePair> pairs = new ArrayList<BasicNameValuePair>(4);
        Map<String, String> authParams = this.wandaConfig.getAuthParams();
        pairs.add(new BasicNameValuePair(COMPANY_CODE, authParams.get(COMPANY_CODE)));
        pairs.add(new BasicNameValuePair(GRANT_TYPE, authParams.get(GRANT_TYPE)));
        pairs.add(new BasicNameValuePair(ACCOUNT, authParams.get(ACCOUNT)));
        pairs.add(new BasicNameValuePair(PASSWORD, authParams.get(PASSWORD)));
        httpPost.setEntity((HttpEntity)new UrlEncodedFormEntity(pairs, StandardCharsets.UTF_8));
        httpPost.setConfig(this.config);
        String response = "";
        try (CloseableHttpResponse httpResponse = this.httpClient.execute((HttpUriRequest)httpPost);){
            if (Objects.nonNull(httpResponse)) {
                response = EntityUtils.toString((HttpEntity)httpResponse.getEntity(), (Charset)StandardCharsets.UTF_8);
            }
        }
        if (StringUtils.isBlank((String)response)) {
            throw new BizException(WandaErrorCode.E1000001.getErrorMsg());
        }
        JSONObject result = JSONObject.parseObject((String)response);
        int status = result.getIntValue("status");
        String message = result.getString("message");
        if (!Objects.equals(status, WandaRequestStatus.OK.getValue())) {
            throw new BizException(WandaErrorCode.E1000001.getErrorMsg() + "," + message);
        }
        JSONObject data = result.getJSONObject("data");
        if (Objects.nonNull(data)) {
            return data.getString(ACCESS_TOKEN);
        }
        return "";
    }

    private Long queryCredits(String cardNo) throws Exception {
        String accessToken = this.getToken();
        this.LOGGER.info("[\u4e07\u8fbe\u9152\u5e97]\u63a5\u53e3\u6388\u6743accessToken = [{}]", (Object)accessToken);
        HttpPost httpPost = new HttpPost(this.wandaConfig.getQueryCreditsUrl());
        httpPost.setHeader("Authentication", accessToken);
        List<BasicNameValuePair> pairs = Collections.singletonList(new BasicNameValuePair("cardNo", cardNo));
        httpPost.setEntity((HttpEntity)new UrlEncodedFormEntity(pairs, StandardCharsets.UTF_8));
        httpPost.setConfig(this.config);
        String response = "";
        try (CloseableHttpResponse httpResponse = this.httpClient.execute((HttpUriRequest)httpPost);){
            if (Objects.nonNull(httpResponse)) {
                response = EntityUtils.toString((HttpEntity)httpResponse.getEntity(), (Charset)StandardCharsets.UTF_8);
            }
        }
        this.LOGGER.info("[\u4e07\u8fbe\u9152\u5e97] \u7528\u6237\u79ef\u5206\u67e5\u8be2 = {}", (Object)response);
        if (StringUtils.isBlank((String)response)) {
            throw new BizException(WandaErrorCode.E1000001.getErrorMsg());
        }
        JSONObject result = JSONObject.parseObject((String)response);
        String responseCode = result.getString(RESPONSE_CODE);
        String message = result.getString("message");
        if (!SUCCESS.equals(responseCode)) {
            throw new BizException(WandaErrorCode.E1000001.getErrorMsg() + "," + message);
        }
        JSONObject responseDomain = result.getJSONObject("responseDomain");
        if (Objects.nonNull(responseDomain)) {
            return responseDomain.getLong("point");
        }
        throw new BizException(WandaErrorCode.E1000003.getErrorMsg() + "," + message);
    }

    public static String getHostName(String url) {
        return url.substring(0, url.indexOf(63));
    }

    public static String getParamUrl(String url) {
        return url.substring(url.indexOf(63) + 1);
    }

    @Deprecated
    private String getStoreCode(String itemCode, String type, boolean isDuibaItem) {
        String splitter = "_";
        if (StringUtils.isBlank((String)itemCode)) {
            return this.wandaConfig.getDefaultStoreCode();
        }
        if (isDuibaItem) {
            return this.wandaConfig.getDefaultStoreCode();
        }
        if (VIRTUAL.equals(type)) {
            if (itemCode.contains("_")) {
                String[] splitStrs = itemCode.split("_");
                return Optional.ofNullable(splitStrs[1]).orElse("-1");
            }
            throw new IllegalStateException("wanda\u865a\u62df\u5546\u54c1 \u5546\u5bb6\u5546\u54c1\u7f16\u7801\u9519\u8bef");
        }
        return itemCode;
    }
}

