/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.biz.credits.strategy.Impl;

import cn.com.duiba.biz.credits.strategy.ApiStrategy;
import cn.com.duiba.constant.zhiji.ZhiJiConfig;
import cn.com.duiba.credits.sdk.AddCreditsParams;
import cn.com.duiba.domain.SubCreditsMsgWrapper;
import cn.com.duiba.domain.ZhijiAddCreditsDataReq;
import cn.com.duiba.domain.ZhijiAddCreditsReqBody;
import cn.com.duiba.domain.ZhijiAddCreditsReqData;
import cn.com.duiba.domain.ZhijiAddCreditsReqPointList;
import cn.com.duiba.domain.ZhijiAddCreditsRequest;
import cn.com.duiba.thirdparty.dto.CreditsMessageDto;
import cn.com.duiba.tool.AssembleTool;
import cn.com.duiba.tool.zhiji.ZhiJiParamTool;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Maps;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.codec.binary.Hex;
import org.apache.http.HttpEntity;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.entity.StringEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ZhiJiApiStrategy
implements ApiStrategy {
    private static final Logger LOGGER = LoggerFactory.getLogger(ZhiJiApiStrategy.class);
    private final RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout(5000).setSocketTimeout(10000).setConnectionRequestTimeout(500).build();
    private static final int FIVE_SECONDS = 5000;
    private static final int TEN_SECONDS = 10000;
    @Autowired
    private ZhiJiConfig zhiJiConfig;

    @Override
    public HttpRequestBase getAddCreditsMessageRequest(CreditsMessageDto message) {
        try {
            HttpPost httpPost = new HttpPost(this.zhiJiConfig.getAddCreditsUrl());
            AddCreditsParams addCreditsParams = message.getAddCreditsParams();
            ZhijiAddCreditsReqPointList pointList = new ZhijiAddCreditsReqPointList();
            pointList.setAccrualPoints(addCreditsParams.getCredits().intValue());
            ZhijiAddCreditsDataReq dataReq = new ZhijiAddCreditsDataReq();
            dataReq.setPointList(pointList);
            ZhijiAddCreditsReqData reqData = new ZhijiAddCreditsReqData();
            reqData.setListOfIMAccruePointsInput(dataReq);
            ZhijiAddCreditsReqBody body = new ZhijiAddCreditsReqBody();
            body.setData(reqData);
            body.setTraceId(addCreditsParams.getOrderNum());
            body.setTransactionNumber(addCreditsParams.getOrderNum());
            String transfer = message.getAddCreditsParams().getTransfer();
            body.setTransactionTime(transfer);
            ZhijiAddCreditsRequest request = new ZhijiAddCreditsRequest();
            request.setZhijiAddCreditsReqBody(body);
            LOGGER.info("\u3010\u667a\u51e0\u6c7d\u8f66\u3011\u52a0\u79ef\u5206\u8bf7\u6c42\uff0curl:{},params:{}", (Object)this.zhiJiConfig.getAddCreditsUrl(), (Object)JSON.toJSONString((Object)request));
            httpPost.setEntity((HttpEntity)new StringEntity(JSON.toJSONString((Object)request)));
            byte[] bytes = ZhiJiParamTool.hmacEncrypt(JSON.toJSONString((Object)request));
            if (bytes == null) {
                LOGGER.warn("\u3010\u667a\u51e0\u6c7d\u8f66\u3011\u52a0\u79ef\u53c2\u6570\u52a0\u5bc6\u5f02\u5e38\uff0cparams:{},message:{}", (Object)JSON.toJSONString((Object)request), (Object)JSON.toJSONString((Object)message));
                return null;
            }
            httpPost.setHeader("Content-Type", "application/json");
            httpPost.setHeader("charset", "gbk");
            httpPost.setHeader("signature", Hex.encodeHexString((byte[])bytes));
            httpPost.setConfig(this.requestConfig);
            return httpPost;
        }
        catch (Exception e) {
            LOGGER.warn("\u3010\u667a\u51e0\u6c7d\u8f66\u3011\u7ec4\u88c5\u52a0\u79ef\u5206\u63a5\u53e3\u53c2\u6570\u5931\u8d25", (Throwable)e);
            return null;
        }
    }

    @Override
    public HttpRequestBase getMqSubCreditsHttpRequest(SubCreditsMsgWrapper message) {
        try {
            HttpPost httpPost = new HttpPost(this.zhiJiConfig.getSubCreditsUrl());
            Map<String, String> originData = AssembleTool.getUrlParams(ZhiJiApiStrategy.getParamUrl(message.getHttpUrl()));
            LOGGER.info("\u667a\u5df1-\u6263\u79ef\u5206\u53c2\u6570\uff0cparams\uff1a{}", (Object)JSON.toJSONString(originData));
            HashMap requestParams = Maps.newHashMap();
            requestParams.put("TransactionType", originData.get("description"));
            requestParams.put("RedeemNumber", originData.get("orderNum"));
            requestParams.put("TraceId", originData.get("orderNum") + ZhiJiParamTool.generateRandom());
            Map customParams = message.getSubCreditsMsg().getParams();
            requestParams.put("superId", "1000000001788065");
            requestParams.put("RedeemTime", customParams.get("TransactionTime"));
            requestParams.put("SourceCode", "DUIBA");
            HashMap data = new HashMap(1);
            HashMap lostOfPointList = new HashMap(1);
            HashMap<String, String> pointList = new HashMap<String, String>(2);
            pointList.put("Type", "Point");
            pointList.put("RedeemPoints", originData.get("credits"));
            lostOfPointList.put("PointList", pointList);
            data.put("ListOfPointList", lostOfPointList);
            requestParams.put("Data", data);
            HashMap<String, HashMap> body = new HashMap<String, HashMap>(1);
            body.put("body", requestParams);
            LOGGER.info("\u667a\u5df1-\u6263\u79ef\u5206\u53c2\u6570\uff0curl\uff1a{}\uff0cbody\uff1a{}\uff0cmessage\uff1a{}", new Object[]{this.zhiJiConfig.getSubCreditsUrl(), body, JSON.toJSONString((Object)message)});
            try {
                httpPost.setEntity((HttpEntity)new StringEntity(JSON.toJSONString(body)));
            }
            catch (UnsupportedEncodingException e) {
                LOGGER.warn("\u667a\u5df1-\u6263\u79ef\u5206\u53c2\u6570\u5f02\u5e38\uff0cbody:{},message:{}", new Object[]{body, JSON.toJSONString((Object)message), e});
                return null;
            }
            byte[] bytes = ZhiJiParamTool.hmacEncrypt(JSON.toJSONString(body));
            if (bytes == null) {
                LOGGER.warn("\u667a\u5df1-\u6263\u79ef\u5206\u53c2\u6570\u52a0\u5bc6\u5f02\u5e38\uff0cbody:{},message:{}", body, (Object)JSON.toJSONString((Object)message));
                return null;
            }
            httpPost.setHeader("Content-Type", "application/json");
            httpPost.setHeader("charset", "gbk");
            httpPost.setHeader("signature", Hex.encodeHexString((byte[])bytes));
            httpPost.setConfig(this.requestConfig);
            return httpPost;
        }
        catch (Exception e) {
            LOGGER.warn("\u667a\u5df1-\u6263\u79ef\u5206\u53c2\u6570\u52a0\u5bc6\u5f02\u5e38\uff0cmessage:{}", (Object)message, (Object)e);
            return null;
        }
    }

    @Override
    public String parseCreditsRsp(String body, Boolean addCredits, Map<String, String> authParams) {
        LOGGER.info("\u667a\u5df1-\u79ef\u5206\u8fd4\u56de\u53c2\u6570\uff0cparams\uff1a{}", (Object)body);
        JSONObject response = JSON.parseObject((String)body);
        JSONObject result = new JSONObject();
        result.put("bizId", response.get((Object)"TxnId"));
        if (Objects.equals("0", response.get((Object)"ErrorCode"))) {
            result.put("status", (Object)"ok");
        } else {
            result.put("status", (Object)"fail");
        }
        result.put("errorMessage", response.get((Object)"ErrorMessage"));
        return result.toJSONString();
    }

    public static String getParamUrl(String url) {
        return url.substring(url.indexOf(63) + 1);
    }
}

