/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.biz.credits.strategy.Impl;

import cn.com.duiba.api.tools.RandomCodeUtil;
import cn.com.duiba.biz.credits.strategy.ApiStrategy;
import cn.com.duiba.biz.credits.strategy.ApiStrategyRouter;
import cn.com.duiba.config.ZhongXinConfig;
import cn.com.duiba.domain.SupplierRequest;
import cn.com.duiba.tool.AssembleTool;
import cn.com.duiba.wolf.utils.DateUtils;
import cn.com.duiba.wolf.utils.UrlUtils2;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.citic.openbank.sdk.CiticSdk;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.PostConstruct;
import org.apache.http.HttpEntity;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.entity.StringEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ZhongXinApiStrategy
implements ApiStrategy {
    private static final Logger log = LoggerFactory.getLogger(ZhongXinApiStrategy.class);
    public static final SimpleDateFormat format = new SimpleDateFormat("HHmmss");
    @Autowired
    private ZhongXinConfig zhongXinConfig;
    private final String DEFAULT_CHARSET = "UTF-8";
    private RequestConfig config;
    private static CiticSdk sdk = new CiticSdk();

    @PostConstruct
    public void init() {
        try {
            sdk.setPublicKeyEncryptUseStr(this.zhongXinConfig.getReqPublikey());
            sdk.setPrivateKeySignatureWithPwdUseStr(this.zhongXinConfig.getRepPrivatekey(), this.zhongXinConfig.getRepPrivatekeyPwd());
            sdk.setPublicKeyValidateSignatureUseStr(this.zhongXinConfig.getRespPublikey());
            sdk.setPrivateKeyDecryptWithPwdUseStr(this.zhongXinConfig.getRespPrivatekey(), this.zhongXinConfig.getRespPrivatekeyPwd());
            sdk.setTransferEncode("utf-8");
            this.config = RequestConfig.custom().setConnectTimeout(5000).setSocketTimeout(5000).setConnectionRequestTimeout(1000).build();
            ApiStrategyRouter.register(this.zhongXinConfig.getAppIds(), this);
        }
        catch (Exception e) {
            log.error("[\u4e2d\u4fe1\u94f6\u884c]\u521d\u59cb\u5316SDK\u5931\u8d25\uff1a", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HttpRequestBase getVirtualRequest(SupplierRequest request) {
        log.info("\u4e2d\u4fe1\u94f6\u884c\u865a\u62df\u5546\u54c1\u8bf7\u6c42, request={}", (Object)JSON.toJSONString((Object)request));
        String url = request.getHttpUrl();
        String paramsStr = url.substring(url.indexOf(63) + 1);
        Map<String, String> authParams = AssembleTool.getUrlParams(paramsStr);
        String goodsNum = authParams.get("params");
        String uid = authParams.get("uid");
        String httpUrl = UrlUtils2.extractUrl((String)request.getHttpUrl());
        HttpPost httpPost = new HttpPost(httpUrl);
        Date date = new Date();
        String HHmmss = "";
        SimpleDateFormat simpleDateFormat = format;
        synchronized (simpleDateFormat) {
            HHmmss = format.format(date);
        }
        HashMap<String, String> requestData = new HashMap<String, String>();
        requestData.put("OPENVER", "1.0.0");
        requestData.put("OPENTRANSCODE", "IFQYE002");
        requestData.put("OPENMERCODE", this.zhongXinConfig.getAppId());
        requestData.put("OPENMERNAME", this.zhongXinConfig.getMerchantName());
        requestData.put("OPENBUSITYPE", this.zhongXinConfig.getType());
        requestData.put("OPENLAUNCHDATE", String.valueOf(DateUtils.getDayNumber((Date)date)));
        requestData.put("OPENLAUNCHTIME", HHmmss);
        requestData.put("OPENMERFLOWID", DateUtils.getMillisecond() + RandomCodeUtil.getNumCode((int)37));
        requestData.put("BUZYTYPE", "C001");
        requestData.put("CHANNELID", "01");
        requestData.put("CSTINFVALUE", uid);
        requestData.put("SERNUM", request.getOrderId());
        requestData.put("BATCHID", goodsNum);
        try {
            String businessJsonStr = JSON.toJSONString(requestData);
            String encryptBody = sdk.encryptBusiness(businessJsonStr);
            businessJsonStr = businessJsonStr.replaceAll("\r|\n", "");
            JSONObject jsonObject = JSONObject.parseObject((String)businessJsonStr);
            StringBuffer stringBuffer = this.sortJSONObject(jsonObject);
            businessJsonStr = stringBuffer.toString().replaceAll("\\}\\{", "\\},\\{");
            String sign = sdk.signature(businessJsonStr);
            JSONObject params = new JSONObject();
            params.put("transType", (Object)"normal");
            params.put("encryptBody", (Object)encryptBody);
            params.put("sign", (Object)sign);
            StringEntity stringEntity = new StringEntity(params.toJSONString(), "UTF-8");
            stringEntity.setContentEncoding("UTF-8");
            stringEntity.setContentType("application/json");
            log.info("\u4e2d\u4fe1\u94f6\u884c\u865a\u62df\u5546\u54c1\u8bf7\u6c42, stringEntity={}", (Object)JSON.toJSONString(requestData, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat}));
            httpPost.setEntity((HttpEntity)stringEntity);
            httpPost.setConfig(this.config);
            return httpPost;
        }
        catch (Exception e) {
            log.error("[\u4e2d\u4fe1\u94f6\u884c]\u865a\u62df\u5546\u54c1\u5151\u6362\u8bf7\u6c42\u751f\u6210\u5931\u8d25 orderId=" + request.getOrderId(), (Throwable)e);
            throw new IllegalStateException(e);
        }
    }

    @Override
    public String getVirtualResponse(SupplierRequest request, String body) {
        JSONObject result = new JSONObject();
        try {
            String realRespJson = sdk.validateSignature(body);
            log.info("\u4e2d\u4fe1\u94f6\u884c\u865a\u62df\u5546\u54c1\u54cd\u5e94, body={}", (Object)JSON.toJSONString((Object)realRespJson));
            JSONObject jsonObject = JSONObject.parseObject((String)realRespJson);
            String status = (String)jsonObject.get((Object)"STATUS");
            if (Objects.equals(status, "1")) {
                result.put("status", (Object)"success");
            } else {
                result.put("status", (Object)"fail");
            }
            result.put("supplierBizId", (Object)request.getOrderId());
        }
        catch (Exception e) {
            result.put("status", (Object)"fail");
            result.put("errorMessage", (Object)e.getMessage());
            log.error("[\u4e2d\u4fe1\u94f6\u884c]\u89e3\u6790\u865a\u62df\u5546\u54c1\u5151\u6362\u8bf7\u6c42\u7ed3\u679c\u5f02\u5e38 orderId=" + request.getOrderId(), (Throwable)e);
        }
        return result.toJSONString();
    }

    public StringBuffer sortJSONObject(JSONObject jsonObject) {
        if (jsonObject == null) {
            return null;
        }
        StringBuffer plain = new StringBuffer();
        ArrayList infolds = new ArrayList(jsonObject.entrySet());
        Collections.sort(infolds, new Comparator<Map.Entry<String, Object>>(){

            @Override
            public int compare(Map.Entry<String, Object> o1, Map.Entry<String, Object> o2) {
                return o1.getKey().compareTo(o2.getKey());
            }
        });
        plain.append("{");
        for (Map.Entry item : infolds) {
            String key = (String)item.getKey();
            if ("commonDataList".equalsIgnoreCase(key)) continue;
            plain.append("\"" + key + "\"");
            plain.append(":");
            Object val = item.getValue();
            if (val instanceof JSONObject) {
                StringBuffer str = this.sortJSONObject((JSONObject)val);
                plain.append(str);
            } else if (val instanceof String) {
                plain.append("\"" + val + "\"");
            } else if (val instanceof JSONArray) {
                plain.append("[");
                JSONArray arr = (JSONArray)val;
                for (int i = 0; i < arr.size(); ++i) {
                    StringBuffer tempstr = new StringBuffer();
                    Object obj = arr.get(i);
                    if (obj instanceof JSONObject) {
                        tempstr = this.sortJSONObject((JSONObject)obj);
                    }
                    plain.append(tempstr);
                }
                plain.append("]");
            }
            plain.append(",");
        }
        plain.delete(plain.length() - 1, plain.length());
        if (plain.length() > 0) {
            plain.append("}");
        }
        return plain;
    }
}

