/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.biz.phonebill.supplier;

import cn.com.duiba.domain.SupplierRequest;
import cn.com.duiba.domain.SupplierResponse;
import cn.com.duiba.mq.RocketMQMsgProducer;
import cn.com.duiba.service.HttpAsyncClientPool;
import cn.com.duiba.service.MessageService;
import cn.com.duiba.tool.AssembleTool;
import cn.com.duiba.tool.HttpRequestLog;
import cn.com.duiba.tool.JsonTool;
import cn.com.duiba.tool.ParserUtil;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.concurrent.FutureCallback;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class XuanJiePhoneBillSupplier {
    private static Logger log = LoggerFactory.getLogger(XuanJiePhoneBillSupplier.class);
    @Autowired
    private MessageService messageService;
    @Autowired
    private RocketMQMsgProducer rocketMQMsgProducer;
    @Autowired
    private HttpAsyncClientPool httpAsyncClientPool;

    public void asyncSubmit(final SupplierRequest message, final String callbackTopic, final String msgTag, final String msgKey) {
        if (!this.messageService.messageUniqueCheck(message.getSupplierOrderId(), "phonebill")) {
            return;
        }
        String bodyContent = message.getParams().get("entity");
        HttpPost post = AssembleTool.assembleRequest(message.getHttpUrl(), ParserUtil.parseAttr2KVMap(bodyContent));
        HttpRequestLog.logUrl("[action phonebill] [tag request] [bizId " + message.getOrderId() + "] [url " + message.getHttpUrl() + "]");
        this.httpAsyncClientPool.submit(message.getAppId(), (HttpUriRequest)post, new FutureCallback<HttpResponse>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void completed(HttpResponse response) {
                SupplierResponse resp = new SupplierResponse();
                try {
                    XuanJiePhoneBillSupplier.this.buildSupplierResponse(resp, message);
                    resp.setCallbackType("completed");
                    String body = EntityUtils.toString((HttpEntity)response.getEntity());
                    resp.setBody(body);
                }
                catch (Exception e) {
                    log.error("XuanJiePhoneBillSupplier completed", (Throwable)e);
                }
                finally {
                    XuanJiePhoneBillSupplier.this.finallyBlock(message, resp, callbackTopic, msgTag, msgKey);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void failed(Exception ex) {
                log.error("XuanJiePhoneBillSupplier failed orderId:" + message.getOrderId(), (Throwable)ex);
                SupplierResponse resp = new SupplierResponse();
                try {
                    XuanJiePhoneBillSupplier.this.buildSupplierResponse(resp, message);
                    resp.setCallbackType("failed");
                    resp.setErrorMessage(ex.getClass().getName() + ":" + ex.getMessage());
                }
                catch (Exception e) {
                    log.error("XuanJiePhoneBillSupplier completed", (Throwable)e);
                }
                finally {
                    XuanJiePhoneBillSupplier.this.finallyBlock(message, resp, callbackTopic, msgTag, msgKey);
                }
            }

            public void cancelled() {
                SupplierResponse resp = new SupplierResponse();
                try {
                    XuanJiePhoneBillSupplier.this.buildSupplierResponse(resp, message);
                    resp.setCallbackType("cancelled");
                }
                catch (Exception e) {
                    log.error("XuanJiePhoneBillSupplier cancelled", (Throwable)e);
                }
                finally {
                    XuanJiePhoneBillSupplier.this.finallyBlock(message, resp, callbackTopic, msgTag, msgKey);
                }
            }
        });
    }

    private void buildSupplierResponse(SupplierResponse resp, SupplierRequest message) {
        resp.setUrl(message.getHttpUrl());
        resp.setSupplierName(message.getSupplierName());
        resp.setSupplierOrderId(message.getSupplierOrderId());
        resp.setOrderId(message.getOrderId());
        resp.setAppId(message.getAppId());
        resp.setConsumerId(message.getConsumerId());
    }

    private void finallyBlock(SupplierRequest message, SupplierResponse response, String callbackTopic, String msgTag, String msgKey) {
        try {
            String body = JsonTool.objectToJson(response);
            HttpRequestLog.logUrl("[action phonebill] [tag response] [callback " + response.getCallbackType() + "] [bizId " + message.getOrderId() + "] [body " + response.getBody() + "]");
            if (callbackTopic.contains("MQ")) {
                this.rocketMQMsgProducer.sendMsg(callbackTopic, msgTag, msgKey, body, false, null);
            } else {
                this.messageService.sendMsg(callbackTopic, msgTag, msgKey, body);
            }
        }
        catch (Exception e) {
            log.error("XuanJiePhoneBillSupplier callback:" + message.getOrderId(), (Throwable)e);
        }
    }
}

