/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.client;

import cn.com.duiba.api.enums.SubjectTypeEnum;
import cn.com.duiba.constant.nongzonghang.FuLuConfig;
import cn.com.duiba.domain.SupplierRequest;
import cn.com.duiba.domain.VirtualSupplierProcessingOrderLogEntity;
import cn.com.duiba.dto.fulu.FuLuBaseReq;
import cn.com.duiba.dto.fulu.FuLuBaseResp;
import cn.com.duiba.dto.fulu.req.OrderDirectAddReq;
import cn.com.duiba.dto.fulu.req.OrderMobileAddReq;
import cn.com.duiba.dto.fulu.resp.OrderDirectAddResp;
import cn.com.duiba.dto.virtualsupplierprocess.MqInfo;
import cn.com.duiba.service.ThreadPoolService;
import cn.com.duiba.service.virtualsupplierprocess.VirtualSupplierProcessOrderService;
import cn.com.duiba.tool.AssembleTool;
import cn.com.duiba.tool.fulu.FuLuUtils;
import com.alibaba.fastjson.JSON;
import com.google.common.collect.Sets;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.entity.StringEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class FuLuClient {
    private static final Logger log = LoggerFactory.getLogger(FuLuClient.class);
    private static Set<Integer> UNUSUAL_CODE = Sets.newHashSet((Object[])new Integer[]{4008, 4009, 4010, 4012, 5000});
    @Autowired
    private FuLuConfig fuluConfig;
    @Autowired
    private VirtualSupplierProcessOrderService virtualSupplierProcessOrderService;
    @Autowired
    private ThreadPoolService threadPoolService;

    public HttpRequestBase getFuLuDirectRequest(SupplierRequest request, String productId, String subject) {
        log.info("\u798f\u7984\u76f4\u5145---SupplierRequest:{},productId:{}", (Object)JSON.toJSONString((Object)request), (Object)productId);
        String url = request.getHttpUrl();
        String paramsStr = url.substring(url.indexOf(63) + 1);
        Map<String, String> params = AssembleTool.getUrlParams(paramsStr);
        String orderNum = params.get("orderNum");
        String account = params.get("account");
        request.setAuthParams(params);
        HttpPost httpPost = new HttpPost(this.fuluConfig.getUrl());
        FuLuBaseReq fuLuBaseReq = new FuLuBaseReq(this.fuluConfig, FuLuConfig.Api.ORDER_DIRECT_ADD.getMethodName());
        String appkey = SubjectTypeEnum.DUIA.getType().equals(subject) ? this.fuluConfig.getDuiaAppKey() : this.fuluConfig.getAppKey();
        fuLuBaseReq.setAppKey(appkey);
        OrderDirectAddReq orderDirectAddReq = new OrderDirectAddReq();
        orderDirectAddReq.setProductId(Long.valueOf(productId));
        orderDirectAddReq.setCustomerOrderNo(orderNum);
        orderDirectAddReq.setChargeAccount(account);
        orderDirectAddReq.setBuyNum(1);
        fuLuBaseReq.setBizContent(FuLuUtils.toJSON(orderDirectAddReq));
        String appSecret = SubjectTypeEnum.DUIA.getType().equals(subject) ? this.fuluConfig.getDuiaSysSecret() : this.fuluConfig.getSysSecret();
        fuLuBaseReq.setSign(FuLuUtils.sign(appSecret, fuLuBaseReq));
        StringEntity stringEntity = new StringEntity(FuLuUtils.toJSON(fuLuBaseReq), "UTF-8");
        stringEntity.setContentEncoding("UTF-8");
        stringEntity.setContentType("application/json");
        httpPost.setEntity((HttpEntity)stringEntity);
        return httpPost;
    }

    public HttpRequestBase getFuLuMobileRequest(SupplierRequest request, Double chargeValue) {
        log.info("\u798f\u7984\u8bdd\u8d39---SupplierRequest:{},chargeValue:{}", (Object)JSON.toJSONString((Object)request), (Object)chargeValue);
        String url = request.getHttpUrl();
        String paramsStr = url.substring(url.indexOf(63) + 1);
        Map<String, String> params = AssembleTool.getUrlParams(paramsStr);
        String orderNum = params.get("orderNum");
        String phone = params.get("account");
        request.setAuthParams(params);
        HttpPost httpPost = new HttpPost(this.fuluConfig.getUrl());
        FuLuBaseReq fuLuBaseReq = new FuLuBaseReq(this.fuluConfig, FuLuConfig.Api.ORDER_MOBILE_GET.getMethodName());
        OrderMobileAddReq orderDirectAddReq = new OrderMobileAddReq();
        orderDirectAddReq.setChargeValue(chargeValue);
        orderDirectAddReq.setCustomerOrderNo(orderNum);
        orderDirectAddReq.setChargePhone(phone);
        fuLuBaseReq.setBizContent(FuLuUtils.toJSON(orderDirectAddReq));
        fuLuBaseReq.setSign(FuLuUtils.sign(this.fuluConfig.getSysSecret(), fuLuBaseReq));
        StringEntity stringEntity = new StringEntity(FuLuUtils.toJSON(fuLuBaseReq), "UTF-8");
        stringEntity.setContentEncoding("UTF-8");
        stringEntity.setContentType("application/json");
        httpPost.setEntity((HttpEntity)stringEntity);
        return httpPost;
    }

    public Map<String, String> getDuibaVirtualResponse(SupplierRequest message, FuLuBaseResp fuluBaseResp, String callbackTopic, String msgTag, String msgKey) {
        HashMap<String, String> duibaDoc = new HashMap<String, String>();
        if (Objects.equals(fuluBaseResp.getCode(), 0)) {
            OrderDirectAddResp orderDirectAddResp = (OrderDirectAddResp)JSON.parseObject((String)fuluBaseResp.getResult(), OrderDirectAddResp.class);
            if (StringUtils.equals((CharSequence)orderDirectAddResp.getOrderState(), (CharSequence)"success")) {
                duibaDoc.put("status", "success");
                duibaDoc.put("supplierBizId", orderDirectAddResp.getOrderId());
                return duibaDoc;
            }
            if (StringUtils.equals((CharSequence)orderDirectAddResp.getOrderState(), (CharSequence)"failed")) {
                log.warn("fulu\uff0c\u4e0b\u5355\u5931\u8d25\uff0cresp=={}", (Object)JSON.toJSONString((Object)fuluBaseResp));
                duibaDoc.put("status", "fail");
                duibaDoc.put("errorMessage", "\u51fa\u4e86\u70b9\u5c0f\u95ee\u9898\uff0c\u8bf7\u91cd\u65b0\u4e0b\u5355");
                return duibaDoc;
            }
            if (StringUtils.equals((CharSequence)orderDirectAddResp.getOrderState(), (CharSequence)"untreated") || StringUtils.equals((CharSequence)orderDirectAddResp.getOrderState(), (CharSequence)"processing")) {
                this.initSave(message, callbackTopic, msgTag, msgKey);
                duibaDoc.put("status", "process");
                return duibaDoc;
            }
        } else {
            if (UNUSUAL_CODE.contains(fuluBaseResp.getCode())) {
                duibaDoc.put("status", "fail");
                duibaDoc.put("errorMessage", fuluBaseResp.getMessage());
                return duibaDoc;
            }
            log.warn("fulu\uff0c\u4e0b\u5355\u5931\u8d25\uff0cresp=={}", (Object)JSON.toJSONString((Object)fuluBaseResp));
            duibaDoc.put("status", "fail");
            duibaDoc.put("errorMessage", "\u51fa\u4e86\u70b9\u5c0f\u95ee\u9898\uff0c\u8bf7\u91cd\u65b0\u4e0b\u5355");
            return duibaDoc;
        }
        return duibaDoc;
    }

    private void initSave(SupplierRequest message, String callbackTopic, String msgTag, String msgKey) {
        String url = message.getHttpUrl();
        String params = url.substring(url.indexOf(63) + 1);
        Map<String, String> paramMap = AssembleTool.getUrlParams(params);
        VirtualSupplierProcessingOrderLogEntity entity = new VirtualSupplierProcessingOrderLogEntity();
        entity.setAppId(Long.valueOf(message.getAppId()));
        entity.setConsumerId(Long.valueOf(message.getConsumerId()));
        entity.setOrderId(Long.valueOf(message.getOrderId()));
        entity.setOrderNum(paramMap.get("orderNum"));
        entity.setSupplierOrderId(Long.valueOf(message.getSupplierOrderId()));
        entity.setSupplierName(message.getSupplierName());
        entity.setHttpUrl(message.getHttpUrl());
        MqInfo mqInfo = new MqInfo();
        mqInfo.setMqCallbackTopic(callbackTopic);
        mqInfo.setMqTag(msgTag);
        mqInfo.setMqMsgKey(msgKey);
        entity.setMqInfo(JSON.toJSONString((Object)mqInfo));
        this.virtualSupplierProcessOrderService.initSave(entity);
    }
}

