/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.constant;

import cn.com.duiba.api.bo.custom.funheadlines.FunheadLinesAppMapping;
import com.alibaba.fastjson.JSONObject;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.context.annotation.Configuration;

@Configuration
@RefreshScope
public class FunHeadlinesConfig {
    private static final Logger LOGGER = LoggerFactory.getLogger(FunHeadlinesConfig.class);
    @Value(value="${app.funheadlines.funheadLinesAppMappingStr}")
    private String funheadLinesAppMappingStr;
    @Value(value="${app.funheadlines.appId}")
    private String appId;
    private List<FunheadLinesAppMapping> funheadLinesAppMappingList;
    private List<Long> appIdList;

    public List<Long> getAppIds() {
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)this.appId)) {
            return Collections.emptyList();
        }
        if (CollectionUtils.isEmpty(this.appIdList)) {
            this.appIdList = Arrays.stream(this.appId.split(",")).map(Long::valueOf).collect(Collectors.toList());
        }
        return this.appIdList;
    }

    public FunheadLinesAppMapping getFunheadLinesAppMappingByAppId(String appId) {
        return this.getFunheadLinesAppMappingList(this.funheadLinesAppMappingStr).stream().filter(v -> v.getAppId().equals(appId)).findFirst().orElse(null);
    }

    private List<FunheadLinesAppMapping> getFunheadLinesAppMappingList(String funheadLinesAppMappingStr) {
        if (StringUtils.isBlank((String)funheadLinesAppMappingStr)) {
            return Collections.emptyList();
        }
        if (CollectionUtils.isEmpty(this.funheadLinesAppMappingList)) {
            try {
                this.funheadLinesAppMappingList = JSONObject.parseArray((String)this.funheadLinesAppMappingStr, FunheadLinesAppMapping.class);
            }
            catch (Exception e) {
                LOGGER.error("[FunHeadlinesConfig-getFunheadLinesAppMappingList]\u8da3\u5934\u6761-\u914d\u7f6e\u89e3\u6790\u9519\u8bef:funheadLinesAppMappingStr\uff1a{}", (Object)funheadLinesAppMappingStr, (Object)e);
                return Collections.emptyList();
            }
        }
        return this.funheadLinesAppMappingList;
    }
}

