/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.constant;

import cn.com.duiba.biz.credits.strategy.ApiStrategyRouter;
import cn.com.duiba.biz.credits.strategy.Impl.LenovoApiStrategy;
import com.alibaba.fastjson.JSON;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConfigurationProperties(prefix="lenovo.multi")
public class LenovoMultiConfig
implements InitializingBean {
    private static final Logger LOGGER = LoggerFactory.getLogger(LenovoMultiConfig.class);
    @Autowired
    private LenovoApiStrategy lenovoApiStrategy;
    private String configStr = "[{\"appIdSet\":[84929],\"crecordNotifyUrl\":\"https://devmmembership.lenovo.com.cn/member-center/member-center-outer-api/duiba/giftRecordSynchronize\"},{\"appIdSet\":[84373],\"crecordNotifyUrl\":\"https://mmembership.lenovo.com.cn/member-center/member-center-outer-api/duiba/giftRecordSynchronize\"}]";
    private Map<Long, String> configMap;

    public void afterPropertiesSet() throws Exception {
        try {
            if (StringUtils.isNotBlank((CharSequence)this.configStr)) {
                this.configMap = new HashMap<Long, String>();
                List list = JSON.parseArray((String)this.configStr, LenovoMultiBean.class);
                for (LenovoMultiBean lenovoMultiBean : list) {
                    for (Long appId : lenovoMultiBean.getAppIdSet()) {
                        this.configMap.put(appId, lenovoMultiBean.getCrecordNotifyUrl());
                    }
                }
            }
            LOGGER.info("\u8054\u60f3\u5b9a\u5236\uff0c\u914d\u7f6e\u521d\u59cb\u5316\u6210\u529f\uff0cconfigStr={}", (Object)this.configStr);
        }
        catch (Exception e) {
            LOGGER.warn("\u8054\u60f3\u5b9a\u5236\uff0c\u914d\u7f6e\u521d\u59cb\u5316\u5f02\u5e38\uff0cconfigStr={}", (Object)this.configStr);
        }
        LOGGER.info("\u8054\u60f3\u5f00\u59cb\u6ce8\u518c\u7b56\u7565---------");
        ApiStrategyRouter.register(this.configMap.keySet(), this.lenovoApiStrategy);
    }

    public String getConfigStr() {
        return this.configStr;
    }

    public void setConfigStr(String configStr) {
        this.configStr = configStr;
    }

    public Map<Long, String> getConfigMap() {
        return this.configMap;
    }

    public void setConfigMap(Map<Long, String> configMap) {
        this.configMap = configMap;
    }

    public static void main(String[] args) {
        ArrayList list = Lists.newArrayList();
        LenovoMultiBean bean1 = new LenovoMultiBean();
        bean1.setAppIdSet(Sets.newHashSet((Object[])new Long[]{84929L}));
        bean1.setCrecordNotifyUrl("https://devmmembership.lenovo.com.cn/member-center/member-center-outer-api/duiba/giftRecordSynchronize");
        list.add(bean1);
        LenovoMultiBean bean2 = new LenovoMultiBean();
        bean2.setAppIdSet(Sets.newHashSet((Object[])new Long[]{84373L}));
        bean2.setCrecordNotifyUrl("https://mmembership.lenovo.com.cn/member-center/member-center-outer-api/duiba/giftRecordSynchronize");
        list.add(bean2);
        System.out.println(JSON.toJSONString((Object)list));
    }

    public static class LenovoMultiBean {
        private Set<Long> appIdSet;
        private String crecordNotifyUrl;

        public Set<Long> getAppIdSet() {
            return this.appIdSet;
        }

        public void setAppIdSet(Set<Long> appIdSet) {
            this.appIdSet = appIdSet;
        }

        public String getCrecordNotifyUrl() {
            return this.crecordNotifyUrl;
        }

        public void setCrecordNotifyUrl(String crecordNotifyUrl) {
            this.crecordNotifyUrl = crecordNotifyUrl;
        }
    }
}

