/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.remoteimpl;

import cn.com.duiba.biz.credits.AddCreditsToDeveloper;
import cn.com.duiba.biz.credits.SubCreditsToDeveloper;
import cn.com.duiba.domain.HttpMessageDO;
import cn.com.duiba.order.center.api.dto.CreditsMessage;
import cn.com.duiba.service.HttpAsyncClientPool;
import cn.com.duiba.thirdparty.api.RemoteCreditsService;
import cn.com.duiba.thirdparty.dto.CreditsMessageDto;
import cn.com.duiba.tool.CodeException;
import cn.com.duiba.tool.JsonTool;
import cn.com.duiba.wolf.dubbo.DubboResult;
import cn.com.duiba.wolf.utils.BeanUtils;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class RemoteCreditsServiceImpl
implements RemoteCreditsService {
    private static final Logger LOG = LoggerFactory.getLogger(RemoteCreditsServiceImpl.class);
    @Autowired
    private SubCreditsToDeveloper subCreditsToDeveloper;
    @Autowired
    private AddCreditsToDeveloper addCreditsToDeveloper;
    @Autowired
    private HttpAsyncClientPool httpAsyncClientPool;
    private String defaultQueue = "0";

    private void validate(CreditsMessage request, String callbackTopic) throws CodeException {
        if (StringUtils.isEmpty((String)callbackTopic)) {
            throw new CodeException("0", "\u8ba2\u9605Topic\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((String)request.getHttpUrl())) {
            throw new CodeException("0", "\u8bf7\u6c42URL\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (request.getAppId() == null) {
            throw new CodeException("0", "APPID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (!this.httpAsyncClientPool.canSubmitToAppPool(request.getAppId())) {
            throw new CodeException("0", "\u5f00\u53d1\u8005\u63a5\u53e3\u7e41\u5fd9, appId: " + request.getAppId());
        }
    }

    @Deprecated
    public DubboResult<Boolean> submitSubCredits(CreditsMessage request, String callbackTopic) {
        try {
            this.validate(request, callbackTopic);
            this.subCreditsToDeveloper.submit(request, callbackTopic, null, null);
            return DubboResult.successResult((Object)true);
        }
        catch (CodeException e) {
            LOG.error("submitSubCredits", (Throwable)e);
            return DubboResult.failResult((String)e.getMessage());
        }
    }

    @Deprecated
    public DubboResult<Boolean> submitAddCredits(CreditsMessage request, String callbackTopic) {
        try {
            this.validate(request, callbackTopic);
            CreditsMessageDto dto = (CreditsMessageDto)BeanUtils.copy((Object)request, CreditsMessageDto.class);
            dto.setCallbackTopic(callbackTopic);
            HttpMessageDO message = new HttpMessageDO();
            message.setAppId(Long.valueOf(request.getAppId()));
            message.setBizType("addCredits");
            message.setBizParams(JsonTool.objectToJson(dto));
            message.setNumber(0);
            this.addCreditsToDeveloper.submit(message);
            return DubboResult.successResult((Object)true);
        }
        catch (CodeException e) {
            LOG.error("submitAddCredits", (Throwable)e);
            return DubboResult.failResult((String)e.getMessage());
        }
    }

    public DubboResult<Boolean> submitSubCredits(CreditsMessage request, String callbackTopic, String tag, String key) {
        try {
            this.validate(request, callbackTopic);
            this.subCreditsToDeveloper.submit(request, callbackTopic, tag, key);
            return DubboResult.successResult((Object)true);
        }
        catch (CodeException e) {
            LOG.error("submitSubCredits", (Throwable)e);
            return DubboResult.failResult((String)e.getMessage());
        }
    }

    public DubboResult<Boolean> submitAddCredits(CreditsMessage request, String callbackTopic, String tag, String key) {
        try {
            this.addCreditsToDeveloper.submit(this.makeHttpMessage(request, callbackTopic, tag, key));
            return DubboResult.successResult((Object)true);
        }
        catch (CodeException e) {
            LOG.error("submitAddCredits", (Throwable)e);
            return DubboResult.failResult((String)e.getMessage());
        }
    }

    private HttpMessageDO makeHttpMessage(CreditsMessage request, String callbackTopic, String tag, String key) {
        this.validate(request, callbackTopic);
        CreditsMessageDto dto = (CreditsMessageDto)BeanUtils.copy((Object)request, CreditsMessageDto.class);
        dto.setCallbackTopic(callbackTopic);
        dto.setCallbackTag(tag);
        dto.setCallbackKey(key);
        HttpMessageDO message = new HttpMessageDO();
        String appId = request.getAppId() == null ? this.defaultQueue : request.getAppId();
        message.setAppId(Long.valueOf(appId));
        message.setBizType("addCredits");
        message.setBizParams(JsonTool.objectToJson(dto));
        message.setNumber(0);
        return message;
    }

    public DubboResult<Boolean> batchAddCredits(List<CreditsMessage> requests, String callbackTopic, String tag, String key) {
        if (CollectionUtils.isEmpty(requests)) {
            return DubboResult.successResult((Object)true);
        }
        try {
            for (CreditsMessage each : requests) {
                HttpMessageDO message = this.makeHttpMessage(each, callbackTopic, tag, key);
                this.addCreditsToDeveloper.submit(message);
            }
            return DubboResult.successResult((Object)true);
        }
        catch (CodeException e) {
            LOG.error("batchAddCredits", (Throwable)e);
            return DubboResult.failResult((String)e.getMessage());
        }
    }
}

