/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.remoteimpl.cgb;

import cn.com.duiba.biz.credits.CgbBankApi;
import cn.com.duiba.constant.CgbBankConfig;
import cn.com.duiba.service.HttpAsyncClientPool;
import cn.com.duiba.thirdparty.api.cgb.RemoteCgbPushService;
import cn.com.duiba.thirdparty.dto.cgb.PushCouponDto;
import cn.com.duiba.thirdparty.dto.cgb.PushCouponRequest;
import cn.com.duiba.thirdparty.dto.cgb.SvcInfo;
import cn.com.duiba.thirdparty.dto.cgb.TermInfo;
import cn.com.duiba.thirdparty.dto.cgb.TranInfo;
import cn.com.duiba.tool.cgb.CgbSign;
import cn.com.duiba.tool.cgb.MD5;
import cn.com.duiba.tool.cgb.SM4Util;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.commons.lang.RandomStringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.concurrent.FutureCallback;
import org.apache.http.entity.StringEntity;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class RemoteCgbPushServiceImpl
implements RemoteCgbPushService {
    private static final Logger LOGGER = LoggerFactory.getLogger(RemoteCgbPushServiceImpl.class);
    @Autowired
    private HttpAsyncClientPool httpAsyncClientPool;
    @Autowired
    private CgbBankConfig cgbBankConfig;
    @Autowired
    private CgbBankApi cgbBankApi;
    private static String merchantPriKey = "duiba.pvk";
    private static String merchantPubKey = "duiba.puk";
    private static String guangfaPubKey = "guangfa.puk";
    private static String encoding = "UTF-8";
    private static String contentType = "application/json";

    public void pushCouponMessage(Long appId, List<PushCouponDto> pushCouponDtos) {
        LOGGER.info("\u5e7f\u53d1\u4e2d\u5fc3\u4e0a\u67b6\u4f18\u60e0\u5238\u63a8\u9001-\u5f00\u59cb, appId={}", (Object)appId);
        if (!this.cgbBankApi.isCgbBank(appId)) {
            return;
        }
        String httpUrl = null;
        try {
            httpUrl = this.cgbBankConfig.getHttpUrl();
            HttpPost http = new HttpPost(httpUrl);
            PushCouponRequest pushCouponRequest = this.getPushRequestRequest(pushCouponDtos);
            JSONObject reqStr = (JSONObject)JSONObject.toJSON((Object)pushCouponRequest);
            JSONObject jsonObject1 = new JSONObject();
            jsonObject1.put("Header", (Object)this.getHeadJson());
            JSONObject jsonObject2 = new JSONObject();
            jsonObject2.put("Body", (Object)reqStr);
            JSONObject allJsonObject = new JSONObject();
            allJsonObject.putAll((Map)jsonObject1);
            allJsonObject.putAll((Map)jsonObject2);
            String dataStr = allJsonObject.toJSONString();
            LOGGER.info("\u5e7f\u53d1\u4e2d\u5fc3\u4e0a\u67b6\u4f18\u60e0\u5238\u63a8\u9001,\u62a5\u6587\u539f\u6587={}", (Object)dataStr);
            String signature = CgbSign.sign(dataStr, merchantPriKey, encoding);
            String certId = MD5.getMD5(merchantPubKey);
            RandomStringUtils rs = new RandomStringUtils();
            String verifyChars = "123457890abcdefghijklmnopqrstuvwxyz";
            final String encryptKey = RandomStringUtils.random((int)16, (String)verifyChars).toUpperCase();
            byte[] encryptBytes = SM4Util.encryptCBC(dataStr.getBytes(encoding), encryptKey.getBytes(), encryptKey.getBytes());
            String reqEncrypStr = Base64.getEncoder().encodeToString(encryptBytes);
            LOGGER.info("\u5e7f\u53d1\u4e2d\u5fc3\u4e0a\u67b6\u4f18\u60e0\u5238\u63a8\u9001,\u62a5\u6587\u52a0\u5bc6\u7ed3\u679c={}", (Object)reqEncrypStr);
            String encryptKey1 = CgbSign.sm2EncryptString(encryptKey, guangfaPubKey, encoding);
            http.addHeader("signature", signature);
            http.addHeader("signType", "SM2");
            http.addHeader("encryptType", "SM4");
            http.addHeader("encryptKey", encryptKey1);
            http.addHeader("certId", certId);
            StringEntity stringEntity = new StringEntity(reqEncrypStr, contentType, encoding);
            http.setEntity((HttpEntity)stringEntity);
            this.httpAsyncClientPool.submit(appId.toString(), (HttpUriRequest)http, new FutureCallback<HttpResponse>(){

                public void completed(HttpResponse response) {
                    try {
                        LOGGER.info("\u5e7f\u53d1\u4e2d\u5fc3\u4e0a\u67b6\u4f18\u60e0\u5238\u63a8\u9001-\u901a\u77e5\u6210\u529f,statusCode={}", (Object)response.getStatusLine().getStatusCode());
                        String result = EntityUtils.toString((HttpEntity)response.getEntity());
                        LOGGER.info("\u5e7f\u53d1\u4e2d\u5fc3\u4e0a\u67b6\u4f18\u60e0\u5238\u63a8\u9001-\u901a\u77e5\u6210\u529f\u3002\u8fd4\u56de\u62a5\u6587\u7ed3\u679c={}", (Object)result);
                        byte[] decryptBytes = SM4Util.decryptCBC(Base64.getDecoder().decode(result), encryptKey.getBytes(), encryptKey.getBytes());
                        String respStr = new String(decryptBytes, encoding);
                        LOGGER.info("\u5e7f\u53d1\u4e2d\u5fc3\u4e0a\u67b6\u4f18\u60e0\u5238\u63a8\u9001-\u901a\u77e5\u6210\u529f\u3002\u8fd4\u56de\u62a5\u6587\u89e3\u5bc6\u7ed3\u679c={}", (Object)respStr);
                        String respSignature = response.getHeaders("signature")[0].getValue();
                        LOGGER.info("\u5e7f\u53d1\u4e2d\u5fc3\u4e0a\u67b6\u4f18\u60e0\u5238\u63a8\u9001-\u901a\u77e5\u6210\u529f\u3002\u8fd4\u56de\u7b7e\u540dsignature={}", (Object)respSignature);
                        boolean veryfyResult = CgbSign.veryfySign(respStr, respSignature, guangfaPubKey, encoding);
                        LOGGER.info("\u5e7f\u53d1\u4e2d\u5fc3\u4e0a\u67b6\u4f18\u60e0\u5238\u63a8\u9001-\u901a\u77e5\u6210\u529f\u3002\u8fd4\u56de\u62a5\u6587\u9a8c\u7b7e\u7ed3\u679c={}", (Object)veryfyResult);
                    }
                    catch (Exception e) {
                        LOGGER.error("\u5e7f\u53d1\u4e2d\u5fc3\u4e0a\u67b6\u4f18\u60e0\u5238\u63a8\u9001-\u901a\u77e5\u6210\u529f\u3002\u5904\u7406\u8fd4\u56de\u6570\u636e\u5f02\u5e38", (Throwable)e);
                    }
                }

                public void failed(Exception ex) {
                    LOGGER.info("\u5e7f\u53d1\u4e2d\u5fc3\u4e0a\u67b6\u4f18\u60e0\u5238\u63a8\u9001-\u901a\u77e5\u5931\u8d25", (Throwable)ex);
                }

                public void cancelled() {
                    LOGGER.info("\u5e7f\u53d1\u4e2d\u5fc3\u4e0a\u67b6\u4f18\u60e0\u5238\u63a8\u9001-\u901a\u77e5\u53d6\u6d88");
                }
            }, null);
        }
        catch (Exception e) {
            LOGGER.info("\u5e7f\u53d1\u4e2d\u5fc3\u4e0a\u67b6\u4f18\u60e0\u5238\u63a8\u9001\u5f02\u5e38, \u8bf7\u6c42\u8def\u5f84={}", (Object)httpUrl, (Object)e);
        }
    }

    private JSONObject getHeadJson() {
        JSONObject headJson = new JSONObject();
        headJson.put("version", (Object)"1.0.0");
        headJson.put("instId", (Object)"0120200616000002");
        headJson.put("appId", (Object)"01202006160000020001");
        headJson.put("productCode", (Object)"lifeValue");
        headJson.put("tradeCode", (Object)"compSvcInfoSync");
        headJson.put("signType", (Object)"SM2");
        headJson.put("senderSN", (Object)UUID.randomUUID().toString().substring(0, 32));
        headJson.put("requestTime", (Object)this.formatDateToSS(new Date()));
        return headJson;
    }

    private PushCouponRequest getPushRequestRequest(List<PushCouponDto> pushCouponDtos) {
        PushCouponRequest request = new PushCouponRequest();
        TermInfo termInfo = new TermInfo();
        termInfo.setTranChannel("TC");
        request.setTermInfo(termInfo);
        TranInfo tranInfo = new TranInfo();
        tranInfo.setIssuer("30000150");
        tranInfo.setNum(Integer.valueOf(pushCouponDtos.size()));
        request.setTranInfo(tranInfo);
        ArrayList svcInfos = Lists.newArrayList();
        for (PushCouponDto pushCouponDto : pushCouponDtos) {
            SvcInfo svcInfo = new SvcInfo();
            svcInfo.setThirdActNo(pushCouponDto.getAppItemId().toString());
            svcInfo.setSvcName(pushCouponDto.getName());
            svcInfo.setStartTime(this.formatDateToSS(new Date()));
            if (pushCouponDto.getValidEndDateList() != null) {
                svcInfo.setEndTime(this.formatDateToSS(pushCouponDto.getValidEndDateList()));
                svcInfo.setShowEndDate(this.formatDateToSS(pushCouponDto.getValidEndDateList()));
                svcInfo.setSvcCyc(this.formatDateToDD(pushCouponDto.getValidEndDateList()));
            }
            svcInfo.setShowStartDate(this.formatDateToSS(new Date()));
            svcInfo.setSvcSummery(pushCouponDto.getName());
            if (pushCouponDto.getDescription() != null) {
                String description = pushCouponDto.getDescription().replaceAll("<{1}[^<>]*>{1}", "");
                if (description.length() > 1000) {
                    svcInfo.setSvcDetail(description.substring(0, 1000));
                } else {
                    svcInfo.setSvcDetail(description);
                }
            }
            svcInfo.setTotalNum(pushCouponDto.getStock());
            svcInfo.setCustNum(Integer.valueOf(pushCouponDto.getLimitCountForever() == null ? 100 : pushCouponDto.getLimitCountForever()));
            svcInfo.setDayLimitNum(Integer.valueOf(pushCouponDto.getLimitCountEveryday() == null ? 100 : pushCouponDto.getLimitCountEveryday()));
            svcInfo.setSvcCycType("02");
            svcInfo.setCouponAmt(Double.valueOf(0.0));
            svcInfo.setSvcListPic(pushCouponDto.getSmallImage());
            svcInfo.setSvcDetailPic(pushCouponDto.getImage());
            svcInfo.setActiveCate(pushCouponDto.getActiveCate());
            svcInfos.add(svcInfo);
        }
        request.setSvcInfo((List)svcInfos);
        return request;
    }

    private String formatDateToSS(Date date) {
        LocalDateTime time = date.toInstant().atZone(ZoneId.systemDefault()).toLocalDateTime();
        DateTimeFormatter dtf2 = DateTimeFormatter.ofPattern("yyyyMMddHHmmss");
        return dtf2.format(time);
    }

    private String formatDateToDD(Date date) {
        LocalDateTime time = date.toInstant().atZone(ZoneId.systemDefault()).toLocalDateTime();
        DateTimeFormatter dtf2 = DateTimeFormatter.ofPattern("yyyy-MM-dd");
        return dtf2.format(time);
    }
}

