/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.service;

import cn.com.duiba.biz.credits.CgbBankApi;
import cn.com.duiba.biz.credits.CiticBankApi;
import cn.com.duiba.biz.credits.GangZhongLvApi;
import cn.com.duiba.biz.credits.SnsApi;
import cn.com.duiba.biz.credits.WjrcbApi;
import cn.com.duiba.domain.RequestTypeEnum;
import cn.com.duiba.service.SlowRequestHandler;
import cn.com.duiba.service.ThreadPoolService;
import cn.com.duiba.tool.UrlUtils;
import cn.com.duiba.wolf.utils.NumberUtils;
import cn.com.duibaboot.ext.autoconfigure.core.utils.CatUtils;
import cn.com.duibaboot.ext.autoconfigure.httpclient.ssre.CanAccessInsideNetwork;
import com.alibaba.ttl.threadpool.TtlExecutors;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Resource;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.concurrent.FutureCallback;
import org.apache.http.impl.nio.client.CloseableHttpAsyncClient;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class HttpAsyncClientPool
implements InitializingBean,
DisposableBean {
    private static final Logger log = LoggerFactory.getLogger(HttpAsyncClientPool.class);
    public static final int MAX_APP_QUEUE = 1000;
    @Resource(name="slowHttpAsyncClient")
    @CanAccessInsideNetwork
    private CloseableHttpAsyncClient slowHttpAsyncClient;
    @Resource(name="httpAsyncClient")
    @CanAccessInsideNetwork
    private CloseableHttpAsyncClient httpAsyncClient;
    @Resource(name="virtualHttpAsyncClient")
    @CanAccessInsideNetwork
    private CloseableHttpAsyncClient virtualHttpAsyncClient;
    @Resource(name="addHttpAsyncClient")
    @CanAccessInsideNetwork
    private CloseableHttpAsyncClient addHttpAsyncClient;
    @Resource(name="citicBankHttpAsyncClient")
    @CanAccessInsideNetwork
    private CloseableHttpAsyncClient citicBankHttpAsyncClient;
    @Resource(name="wjrcbHttpAsyncClient")
    @CanAccessInsideNetwork
    private CloseableHttpAsyncClient wjrcbHttpAsyncClient;
    @Resource(name="citicBankXiAnHttpAsyncClient")
    @CanAccessInsideNetwork
    private CloseableHttpAsyncClient citicBankXianHttpAsyncClient;
    private Map<String, AtomicInteger> runningStat = new ConcurrentHashMap<String, AtomicInteger>();
    @Autowired
    private ThreadPoolService threadPoolService;
    @Resource(name="ctsExecutorService")
    private ExecutorService ctsExecutorService;
    @Resource(name="ctsHttpAsyncClient")
    @CanAccessInsideNetwork
    private CloseableHttpAsyncClient ctsHttpAsyncClient;
    @Resource(name="cgbHttpAsyncClient")
    @CanAccessInsideNetwork
    private CloseableHttpAsyncClient cgbHttpAsyncClient;
    @Autowired
    private SlowRequestHandler slowRequestHandler;
    @Autowired
    private CiticBankApi citicBankApi;
    @Autowired
    private WjrcbApi wjrcbApi;
    @Autowired
    private SnsApi snsApi;
    @Autowired
    private GangZhongLvApi gangZhongLvApi;
    @Autowired
    private CgbBankApi cgbBankApi;
    private static final int MAX_QUEUE_SIZE = 50000;
    private final BlockingQueue<CallbackProcesser> latterQueue = new LinkedBlockingQueue<CallbackProcesser>(50000);
    private final ExecutorService executorService = TtlExecutors.getTtlExecutorService((ExecutorService)Executors.newSingleThreadExecutor(new ThreadFactory(){

        @Override
        public Thread newThread(Runnable r) {
            return new Thread(r, "LatterQueueProcess");
        }
    }));
    private volatile boolean status = true;

    private void execute(String queueKey, HttpUriRequest request, FutureCallback<HttpResponse> callback, CloseableHttpAsyncClient httpClient) {
        block10: {
            CallbackProcesser process = null;
            try {
                long s = System.currentTimeMillis();
                AtomicInteger running = this.runningStat.get(queueKey);
                if (running == null) {
                    this.runningStat.put(queueKey, new AtomicInteger(1));
                } else {
                    running.incrementAndGet();
                }
                process = new CallbackProcesser(queueKey, request, callback);
                request.setHeader("User-Agent", "Mozilla/5.0 (iPhone; CPU iPhone OS 9_1 like Mac OS X) AppleWebKit/601.1.46 (KHTML, like Gecko) Version/9.0 Mobile/13B143 Safari/601.1");
                String reqUrl = UrlUtils.buildUrl(request.getURI());
                if (this.slowRequestHandler.isBlackHost(reqUrl)) {
                    log.info("{} is black host", (Object)reqUrl);
                    return;
                }
                if (this.executeCustom(queueKey, request, httpClient, s, process)) {
                    return;
                }
                if (this.slowRequestHandler.isSlow(reqUrl)) {
                    log.info("url [{}], add to queue, appId={}", (Object)reqUrl, (Object)queueKey);
                    this.slowRequestHandler.addQueue(process);
                    return;
                }
                httpClient.execute(request, (FutureCallback)process);
                long e = System.currentTimeMillis();
                long t = e - s;
                if (t > 1000L) {
                    log.warn("http get pool time > {} ms for {}, appId={}", new Object[]{t, request.getURI(), queueKey});
                    if (t > 2000L) {
                        this.slowRequestHandler.addSlow(reqUrl, (int)(t / 1000L));
                    }
                }
            }
            catch (Exception e) {
                log.error("execute:", (Throwable)e);
                if (e.getCause() != null) {
                    log.error("cause:", e.getCause());
                }
                if (process == null) break block10;
                process.failed(e);
            }
        }
    }

    private boolean executeCustom(String queueKey, HttpUriRequest request, CloseableHttpAsyncClient httpClient, long s, CallbackProcesser process) {
        if (this.citicBankApi.isCiticBank(NumberUtils.parseLong((String)queueKey, (long)0L)) || this.citicBankApi.isXiAnApp(NumberUtils.parseLong((String)queueKey, (long)0L))) {
            httpClient.execute(request, (FutureCallback)process);
            long e = System.currentTimeMillis();
            long t = e - s;
            if (t > 1000L) {
                log.warn("http get pool time > {} ms for {}, appId={}", new Object[]{t, request.getURI(), queueKey});
            }
            return true;
        }
        return false;
    }

    public void submit(String queueKey, HttpUriRequest request, FutureCallback<HttpResponse> callback) {
        this.submit(queueKey, request, callback, RequestTypeEnum.SUB_CREDITS);
    }

    public void submit(final String queueKey, final HttpUriRequest request, final FutureCallback<HttpResponse> callback, RequestTypeEnum requestTypeEnum) {
        if (this.submitCustom(queueKey, request, callback)) {
            return;
        }
        final CloseableHttpAsyncClient httpClient = this.getCloseableHttpAsyncClient(requestTypeEnum);
        if (this.threadPoolService.canSubmit()) {
            this.threadPoolService.submit(new Runnable(){

                @Override
                public void run() {
                    HttpAsyncClientPool.this.execute(queueKey, request, (FutureCallback<HttpResponse>)callback, httpClient);
                }
            });
        } else {
            try {
                this.latterQueue.add(new CallbackProcesser(queueKey, request, callback));
            }
            catch (IllegalStateException e) {
                log.warn("latterQueue is temporarily full", (Throwable)e);
                callback.cancelled();
            }
        }
    }

    private boolean submitCustom(String queueKey, HttpUriRequest request, FutureCallback<HttpResponse> callback) {
        Long appId = NumberUtils.parseLong((String)queueKey, (long)0L);
        CloseableHttpAsyncClient customHttpClient = this.getCustomHttpClient(appId);
        if (customHttpClient != null) {
            if (this.gangZhongLvApi.isGangZhongLv(appId).booleanValue()) {
                this.ctsExecutorService.submit(() -> this.execute(queueKey, request, callback, customHttpClient));
            } else if (this.threadPoolService.canSubmit()) {
                this.threadPoolService.submit(() -> this.execute(queueKey, request, callback, customHttpClient));
            } else {
                this.execute(queueKey, request, callback, customHttpClient);
            }
            return true;
        }
        return false;
    }

    private CloseableHttpAsyncClient getCustomHttpClient(Long appId) {
        if (this.citicBankApi.isCiticBank(appId)) {
            return this.citicBankHttpAsyncClient;
        }
        if (this.citicBankApi.isXiAnApp(appId)) {
            return this.citicBankXianHttpAsyncClient;
        }
        if (this.wjrcbApi.isWjrcb(appId)) {
            return this.wjrcbHttpAsyncClient;
        }
        if (this.gangZhongLvApi.isGangZhongLv(appId).booleanValue()) {
            return this.ctsHttpAsyncClient;
        }
        if (this.cgbBankApi.isCgbBank(appId)) {
            return this.cgbHttpAsyncClient;
        }
        return null;
    }

    @NotNull
    private CloseableHttpAsyncClient getCloseableHttpAsyncClient(RequestTypeEnum requestTypeEnum) {
        CloseableHttpAsyncClient httpClient = this.httpAsyncClient;
        if (requestTypeEnum != null && requestTypeEnum.getCode() == RequestTypeEnum.VIRTUAL.getCode()) {
            httpClient = this.virtualHttpAsyncClient;
        }
        if (requestTypeEnum != null && requestTypeEnum.getCode() == RequestTypeEnum.ADD_CREDITS.getCode()) {
            httpClient = this.addHttpAsyncClient;
        }
        return httpClient;
    }

    public boolean canSubmitToAppPool(String queueKey) {
        int queueCount = 0;
        AtomicInteger running = this.runningStat.get(queueKey);
        if (running != null) {
            queueCount = running.intValue();
        }
        return queueCount < 1000;
    }

    public Map<String, Object> dumpDetail() {
        HashMap<String, AtomicInteger> map = new HashMap<String, AtomicInteger>();
        for (Map.Entry<String, AtomicInteger> entry : this.runningStat.entrySet()) {
            if (entry.getValue().intValue() <= 0) continue;
            map.put(entry.getKey(), entry.getValue());
        }
        HashMap<String, Object> ret = new HashMap<String, Object>();
        ret.put("runningStat", map);
        return ret;
    }

    public int dumpSize() {
        int running = 0;
        for (AtomicInteger a : this.runningStat.values()) {
            running += a.get();
        }
        return running;
    }

    public void destroy() throws Exception {
        this.status = false;
        this.executorService.shutdown();
    }

    public void afterPropertiesSet() throws Exception {
        this.executorService.execute(new Runnable(){

            @Override
            public void run() {
                while (HttpAsyncClientPool.this.status) {
                    try {
                        if (!HttpAsyncClientPool.this.threadPoolService.canSubmit()) {
                            TimeUnit.MILLISECONDS.sleep(200L);
                            continue;
                        }
                        CallbackProcesser callbackProcesser = (CallbackProcesser)HttpAsyncClientPool.this.latterQueue.take();
                        if (callbackProcesser == null) continue;
                        final String queueKey = callbackProcesser.getQueueKey();
                        final HttpUriRequest request = callbackProcesser.getRequest();
                        final FutureCallback callback = callbackProcesser.callback;
                        HttpAsyncClientPool.this.threadPoolService.submit(new Runnable(){

                            @Override
                            public void run() {
                                HttpAsyncClientPool.this.execute(queueKey, request, (FutureCallback<HttpResponse>)callback, HttpAsyncClientPool.this.slowHttpAsyncClient);
                            }
                        });
                    }
                    catch (InterruptedException e) {
                        log.warn("Interrupted", (Throwable)e);
                    }
                    catch (Exception e) {
                        log.warn("", (Throwable)e);
                    }
                }
            }
        });
    }

    public class CallbackProcesser
    implements FutureCallback<HttpResponse> {
        private FutureCallback<HttpResponse> callback;
        private String queueKey;
        private HttpUriRequest request;

        public CallbackProcesser(String queueKey, HttpUriRequest request, FutureCallback<HttpResponse> callback) {
            this.callback = callback;
            this.queueKey = queueKey;
            this.request = request;
        }

        public void completed(HttpResponse result) {
            try {
                CatUtils.executeInCatTransaction(() -> {
                    this.callback.completed((Object)result);
                    return null;
                }, (String)"AsyncHttp", (String)"completed");
            }
            catch (Throwable te) {
                log.error("completed;", te);
            }
            finally {
                ((AtomicInteger)HttpAsyncClientPool.this.runningStat.get(this.queueKey)).decrementAndGet();
            }
        }

        public void failed(Exception ex) {
            try {
                CatUtils.executeInCatTransaction(() -> {
                    this.callback.failed(ex);
                    return null;
                }, (String)"AsyncHttp", (String)"failed");
            }
            catch (Throwable te) {
                log.error("failed;", te);
            }
            finally {
                ((AtomicInteger)HttpAsyncClientPool.this.runningStat.get(this.queueKey)).decrementAndGet();
            }
        }

        public void cancelled() {
            try {
                CatUtils.executeInCatTransaction(() -> {
                    this.callback.cancelled();
                    return null;
                }, (String)"AsyncHttp", (String)"cancelled");
            }
            catch (Throwable te) {
                log.error("cancelled;", te);
            }
            finally {
                ((AtomicInteger)HttpAsyncClientPool.this.runningStat.get(this.queueKey)).decrementAndGet();
            }
        }

        public HttpUriRequest getRequest() {
            return this.request;
        }

        public String getQueueKey() {
            return this.queueKey;
        }
    }
}

