/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.service.virtual.impl;

import cn.com.duiba.biz.Exception.ThirdpatyException;
import cn.com.duiba.client.FuLuClient;
import cn.com.duiba.constant.VirtualFuLuConfig;
import cn.com.duiba.constant.nongzonghang.FuLuConfig;
import cn.com.duiba.dao.AppDAO;
import cn.com.duiba.domain.AppDO;
import cn.com.duiba.domain.SupplierRequest;
import cn.com.duiba.dto.fulu.FuLuBaseReq;
import cn.com.duiba.dto.fulu.FuLuBaseResp;
import cn.com.duiba.dto.fulu.req.OrderDirectAddReq;
import cn.com.duiba.service.impl.AbstractDuibaVirtualSupplier;
import cn.com.duiba.thirdparty.dto.SupplierRequestDto;
import cn.com.duiba.thirdparty.enums.virtual.VirtualItemChannelEnum;
import cn.com.duiba.tool.fulu.FuLuUtils;
import cn.com.duiba.wolf.utils.BeanUtils;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.entity.StringEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class FuLuApiStrategy
extends AbstractDuibaVirtualSupplier {
    private static final Logger LOGGER = LoggerFactory.getLogger(FuLuApiStrategy.class);
    private static final String LOGGER_PREFIX = "\u798f\u7984\u865a\u62df\u5546\u54c1\u63a5\u53e3";
    @Autowired
    private FuLuClient fuLuClient;
    @Autowired
    private VirtualFuLuConfig virtualFuLuConfig;
    @Autowired
    private AppDAO appDAO;
    private static final String Error4ConsumerMessage = "\u51fa\u4e86\u70b9\u5c0f\u95ee\u9898\uff0c\u8bf7\u91cd\u65b0\u4e0b\u5355";

    @Override
    public String getVirtualTypeCode() {
        return VirtualItemChannelEnum.FULU.getCode();
    }

    @Override
    public HttpRequestBase getVirtualRequest(SupplierRequestDto supplierRequest) {
        LOGGER.info("\u798f\u7984\u865a\u62df\u5546\u54c1\u63a5\u53e3,request={}", (Object)JSON.toJSONString((Object)supplierRequest));
        Map params = supplierRequest.getParams();
        String goodsNum = (String)params.get("bizParams");
        String orderNum = (String)params.get("orderNum");
        String account = (String)params.get("account");
        AppDO appDO = this.appDAO.getAppByCache(Long.valueOf(supplierRequest.getAppId()));
        Object appConfig = this.virtualFuLuConfig.getAppConfigBySubjectMap().get(String.valueOf(appDO.getSubject()));
        if (Objects.isNull(appConfig)) {
            throw new ThirdpatyException("\u914d\u7f6e\u5f02\u5e38");
        }
        JSONObject appConfigJson = (JSONObject)appConfig;
        String appKey = appConfigJson.getString("appKey");
        String appSecret = appConfigJson.getString("appSecret");
        HttpPost httpPost = new HttpPost(this.virtualFuLuConfig.getUrl());
        FuLuConfig fuLuConfig = new FuLuConfig();
        fuLuConfig.setAppKey(appKey);
        FuLuBaseReq fuLuBaseReq = new FuLuBaseReq(fuLuConfig, FuLuConfig.Api.ORDER_DIRECT_ADD.getMethodName());
        OrderDirectAddReq orderDirectAddReq = new OrderDirectAddReq();
        orderDirectAddReq.setProductId(Long.valueOf(goodsNum));
        orderDirectAddReq.setCustomerOrderNo(orderNum);
        orderDirectAddReq.setChargeAccount(account);
        orderDirectAddReq.setBuyNum(1);
        fuLuBaseReq.setBizContent(FuLuUtils.toJSON(orderDirectAddReq));
        fuLuBaseReq.setSign(null);
        fuLuBaseReq.setSign(FuLuUtils.sign(appSecret, fuLuBaseReq));
        StringEntity stringEntity = new StringEntity(FuLuUtils.toJSON(fuLuBaseReq), "UTF-8");
        stringEntity.setContentEncoding("UTF-8");
        stringEntity.setContentType("application/json");
        httpPost.setEntity((HttpEntity)stringEntity);
        return httpPost;
    }

    @Override
    public String getVirtualResponse(SupplierRequestDto request, String body) {
        LOGGER.info("\u798f\u7984\u865a\u62df\u5546\u54c1\u63a5\u53e3,\u8bf7\u6c42\u8fd4\u56de\u7ed3\u679c\u5904\u7406,request:{},body:{}", (Object)JSONObject.toJSONString((Object)request), (Object)body);
        SupplierRequest supplierRequest = (SupplierRequest)BeanUtils.copy((Object)request, SupplierRequest.class);
        Map<String, String> duibaDoc = new HashMap<String, String>();
        try {
            FuLuBaseResp fuluBaseResp = (FuLuBaseResp)JSON.parseObject((String)body, FuLuBaseResp.class);
            duibaDoc = this.fuLuClient.getDuibaVirtualResponse(supplierRequest, fuluBaseResp, null, null, null);
        }
        catch (Exception e) {
            LOGGER.error("fulu\uff0c\u5145\u503c\u5546\u54c1\u5b9a\u5236\uff0c\u7ed3\u679c\u89e3\u6790\u9519\u8bef:{}", (Object)body, (Object)e);
            duibaDoc.put("status", "fail");
            duibaDoc.put("errorMessage", "\u798f\u7984\u76f4\u5145\u54cd\u5e94\u89e3\u6790\u9519\u8bef");
        }
        return JSONObject.toJSONString(duibaDoc);
    }

    @Override
    public String getDefaultError4ConsumerMessage() {
        return Error4ConsumerMessage;
    }
}

