/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.service.virtualsupplierprocess;

import cn.com.duiba.constant.nongzonghang.FuLuConfig;
import cn.com.duiba.constant.nongzonghang.NongZongHangConfig;
import cn.com.duiba.domain.SupplierResponse;
import cn.com.duiba.domain.VirtualSupplierProcessingOrderLogEntity;
import cn.com.duiba.dto.fulu.FuLuBaseReq;
import cn.com.duiba.dto.fulu.FuLuBaseResp;
import cn.com.duiba.dto.fulu.req.OrderInfoGetReq;
import cn.com.duiba.dto.fulu.resp.OrderInfoGetResp;
import cn.com.duiba.dto.virtualsupplierprocess.MqInfo;
import cn.com.duiba.job.AbstractDuibaSimpleElasticJob;
import cn.com.duiba.mq.RocketMQMsgProducer;
import cn.com.duiba.service.HttpAsyncClientPool;
import cn.com.duiba.service.MessageService;
import cn.com.duiba.service.virtualsupplierprocess.VirtualSupplierProcessOrderService;
import cn.com.duiba.tool.JsonTool;
import cn.com.duiba.tool.fulu.FuLuUtils;
import com.alibaba.fastjson.JSON;
import io.elasticjob.autoconfigure.annotation.ElasticJob;
import io.elasticjob.lite.api.ShardingContext;
import java.io.IOException;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.concurrent.FutureCallback;
import org.apache.http.entity.StringEntity;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

@ElasticJob(name="virtualSupplierProcessingOrderRepeatQueryJob", cron="0 0/1 * * * ?", shardingTotalCount=1, overwrite=true)
public class VirtualSupplierProcessingOrderRepeatQueryJob
extends AbstractDuibaSimpleElasticJob {
    private static final Logger LOGGER = LoggerFactory.getLogger(VirtualSupplierProcessingOrderRepeatQueryJob.class);
    @Autowired
    private VirtualSupplierProcessOrderService virtualSupplierProcessOrderService;
    @Autowired
    private NongZongHangConfig nongZongHangConfig;
    @Autowired
    private FuLuConfig fuLuConfig;
    @Autowired
    private HttpAsyncClientPool httpAsyncClientPool;
    @Autowired
    private MessageService messageService;
    @Autowired
    private RocketMQMsgProducer rocketMQMsgProducer;

    @Override
    protected void doProcess(ShardingContext shardingContext) {
        if (CollectionUtils.isEmpty(this.nongZongHangConfig.getAppIds())) {
            return;
        }
        long s = System.currentTimeMillis();
        int size = 0;
        for (Long appId : this.nongZongHangConfig.getAppIds()) {
            int count = this.virtualSupplierProcessOrderService.countNeedRepeatQuery(appId);
            if (count <= 0) continue;
            if (count > 100) {
                count = 100;
            }
            int pageSize = 100;
            int pageNum = count / pageSize + 1;
            for (int i = 1; i <= pageNum; ++i) {
                int offset = (i - 1) * pageSize;
                List<VirtualSupplierProcessingOrderLogEntity> list = this.virtualSupplierProcessOrderService.selectNeedRepeatQueryList(appId, offset, pageSize);
                size += list.size();
                for (final VirtualSupplierProcessingOrderLogEntity entity : list) {
                    HttpPost httpPost = this.getHttpPost(entity);
                    this.httpAsyncClientPool.submit(String.valueOf(appId), (HttpUriRequest)httpPost, new FutureCallback<HttpResponse>(){

                        public void completed(HttpResponse response) {
                            try {
                                VirtualSupplierProcessingOrderRepeatQueryJob.this.doCompleted(response, entity);
                            }
                            catch (Exception e) {
                                LOGGER.warn("fulu query error", (Throwable)e);
                            }
                            finally {
                                VirtualSupplierProcessingOrderRepeatQueryJob.this.increaseHasQueryTimes(entity);
                                VirtualSupplierProcessingOrderRepeatQueryJob.this.deleteDoneRecord(entity);
                            }
                        }

                        public void failed(Exception e) {
                            VirtualSupplierProcessingOrderRepeatQueryJob.this.increaseHasQueryTimes(entity);
                        }

                        public void cancelled() {
                            VirtualSupplierProcessingOrderRepeatQueryJob.this.increaseHasQueryTimes(entity);
                        }
                    });
                }
            }
        }
        long e = System.currentTimeMillis();
        LOGGER.info("virtualSupplierProcessingOrderRepeatQueryJob scan size:{} time:{} ms", (Object)size, (Object)(e - s));
    }

    private void doCompleted(HttpResponse response, VirtualSupplierProcessingOrderLogEntity entity) throws IOException {
        String result = EntityUtils.toString((HttpEntity)response.getEntity());
        FuLuBaseResp fuLuBaseResp = (FuLuBaseResp)JSON.parseObject((String)result, FuLuBaseResp.class);
        if (fuLuBaseResp.getCode() == 0) {
            OrderInfoGetResp orderInfoGetResp = (OrderInfoGetResp)JSON.parseObject((String)fuLuBaseResp.getResult(), OrderInfoGetResp.class);
            HashMap<String, String> duibaDoc = new HashMap<String, String>();
            if (StringUtils.equals((String)orderInfoGetResp.getOrderState(), (String)"success")) {
                duibaDoc.put("status", "success");
                duibaDoc.put("supplierBizId", orderInfoGetResp.getOrderId());
                this.doneRecord(entity);
                this.sendMq(entity, "completed", duibaDoc, null);
            }
            if (StringUtils.equals((String)orderInfoGetResp.getOrderState(), (String)"failed")) {
                LOGGER.warn("fulu\uff0c\u4e0b\u5355\u5931\u8d25\uff0cresp=={}", (Object)JSON.toJSONString((Object)fuLuBaseResp));
                duibaDoc.put("status", "fail");
                duibaDoc.put("errorMessage", "\u51fa\u4e86\u70b9\u5c0f\u95ee\u9898\uff0c\u8bf7\u91cd\u65b0\u4e0b\u5355");
                this.doneRecord(entity);
                this.sendMq(entity, "completed", duibaDoc, null);
            }
        }
    }

    private HttpPost getHttpPost(VirtualSupplierProcessingOrderLogEntity entity) {
        HttpPost httpPost = new HttpPost(this.fuLuConfig.getUrl());
        FuLuBaseReq fuLuBaseReq = new FuLuBaseReq(this.fuLuConfig, FuLuConfig.Api.ORDER_INFO_GET.getMethodName());
        OrderInfoGetReq orderInfoGetReq = new OrderInfoGetReq();
        orderInfoGetReq.setCustomerOrderNo(entity.getOrderNum());
        fuLuBaseReq.setBizContent(FuLuUtils.toJSON(orderInfoGetReq));
        fuLuBaseReq.setSign(null);
        fuLuBaseReq.setSign(FuLuUtils.sign(this.fuLuConfig.getSysSecret(), fuLuBaseReq));
        StringEntity stringEntity = new StringEntity(FuLuUtils.toJSON(fuLuBaseReq), "UTF-8");
        stringEntity.setContentEncoding("UTF-8");
        stringEntity.setContentType("application/json");
        httpPost.setEntity((HttpEntity)stringEntity);
        return httpPost;
    }

    private void sendMq(VirtualSupplierProcessingOrderLogEntity entity, String callbackType, Map<String, String> duibaDoc, String errorMsg) {
        SupplierResponse response = new SupplierResponse();
        response.setUrl(entity.getHttpUrl());
        response.setSupplierName(entity.getSupplierName());
        response.setSupplierOrderId(String.valueOf(entity.getSupplierOrderId()));
        response.setOrderId(String.valueOf(entity.getOrderId()));
        response.setAppId(String.valueOf(entity.getAppId()));
        response.setConsumerId(String.valueOf(entity.getConsumerId()));
        response.setCallbackType(callbackType);
        if (MapUtils.isNotEmpty(duibaDoc)) {
            response.setBody(JSON.toJSONString(duibaDoc));
        }
        if (StringUtils.isNotBlank((String)errorMsg)) {
            response.setErrorMessage(errorMsg);
        }
        String body = JsonTool.objectToJson(response);
        MqInfo mqInfo = (MqInfo)JSON.parseObject((String)entity.getMqInfo(), MqInfo.class);
        if (mqInfo.getMqCallbackTopic().contains("MQ")) {
            this.rocketMQMsgProducer.sendMsg(mqInfo.getMqCallbackTopic(), mqInfo.getMqTag(), mqInfo.getMqMsgKey(), body, false, null);
        } else {
            this.messageService.sendMsg(mqInfo.getMqCallbackTopic(), mqInfo.getMqTag(), mqInfo.getMqMsgKey(), body);
        }
    }

    private void doneRecord(VirtualSupplierProcessingOrderLogEntity entity) {
        VirtualSupplierProcessingOrderLogEntity newEntity = new VirtualSupplierProcessingOrderLogEntity();
        newEntity.setId(entity.getId());
        newEntity.setProcessStatus(1);
        this.virtualSupplierProcessOrderService.updateById(newEntity);
    }

    private void deleteDoneRecord(VirtualSupplierProcessingOrderLogEntity entity) {
        VirtualSupplierProcessingOrderLogEntity entity1 = this.virtualSupplierProcessOrderService.getById(entity.getId());
        if (entity1.getProcessStatus() == 1) {
            this.virtualSupplierProcessOrderService.deleteById(entity1.getId());
        }
    }

    private void increaseHasQueryTimes(VirtualSupplierProcessingOrderLogEntity entity) {
        int hasQueryTimes = entity.getHasQueryTimes() + 1;
        VirtualSupplierProcessingOrderLogEntity newEntity = new VirtualSupplierProcessingOrderLogEntity();
        newEntity.setId(entity.getId());
        newEntity.setHasQueryTimes(hasQueryTimes);
        newEntity.setLatestQueryTime(new Date());
        this.virtualSupplierProcessOrderService.updateById(newEntity);
        if (hasQueryTimes >= 3 && entity.getProcessStatus() == 0) {
            VirtualSupplierProcessingOrderLogEntity updateEntity = new VirtualSupplierProcessingOrderLogEntity();
            updateEntity.setId(entity.getId());
            updateEntity.setProcessStatus(2);
            this.virtualSupplierProcessOrderService.updateById(updateEntity);
            this.sendMq(entity, "failed", null, "\u51fa\u4e86\u70b9\u5c0f\u95ee\u9898\uff0c\u8bf7\u91cd\u65b0\u4e0b\u5355");
        }
    }
}

