/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.tool;

import cn.com.duiba.biz.Exception.ThirdpatyException;
import cn.com.duiba.constant.NewInoherbConfig;
import cn.com.duiba.domain.SubCreditsMsgWrapper;
import cn.com.duiba.thirdparty.dto.CreditsMessageDto;
import com.alibaba.fastjson.JSON;
import java.security.MessageDigest;
import java.util.Arrays;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

public class InoherbTools {
    private static final String EXCHANGE = "exchange";
    private static final String OTHERS = "others";
    private static final String SUB_SUFFIX = "Sub";
    private static final String ADD_SUFFIX = "Add";
    private static final char[] HEX_DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};

    public static String genSign(Map<String, Object> params, String appsecret) {
        Object[] str = params.keySet().toArray(new String[0]);
        Arrays.sort(str);
        StringBuilder signatureStr = new StringBuilder();
        signatureStr.append(appsecret);
        for (Object key : str) {
            Object value = params.get(key);
            if (value == null || value == "") continue;
            signatureStr.append((String)key).append(value);
        }
        signatureStr.append(appsecret);
        String sign = InoherbTools.MD5(signatureStr.toString());
        return sign.toUpperCase();
    }

    private static String MD5(String s) {
        try {
            byte[] strTemp = s.getBytes("UTF-8");
            MessageDigest mdTemp = MessageDigest.getInstance("MD5");
            mdTemp.update(strTemp);
            byte[] md = mdTemp.digest();
            int j = md.length;
            char[] str = new char[j * 2];
            int k = 0;
            for (int i = 0; i < j; ++i) {
                byte byte0 = md[i];
                str[k++] = HEX_DIGITS[byte0 >>> 4 & 0xF];
                str[k++] = HEX_DIGITS[byte0 & 0xF];
            }
            return new String(str);
        }
        catch (Exception var9) {
            return null;
        }
    }

    public static int locateProcessType(Map<String, String> originData, NewInoherbConfig inoherbConfig, boolean isSub) {
        InoherbTools.examineProperties(inoherbConfig);
        Map map = (Map)JSON.parseObject((String)inoherbConfig.getProcessTypes(), Map.class);
        String type = originData.get("type");
        if (type == null) {
            return (Integer)map.get(EXCHANGE);
        }
        if (type.equalsIgnoreCase("hdtool") || type.equalsIgnoreCase("game") || type.equalsIgnoreCase("sign")) {
            return isSub ? ((Integer)map.get(type + SUB_SUFFIX)).intValue() : ((Integer)map.get(type + ADD_SUFFIX)).intValue();
        }
        return (Integer)map.get(EXCHANGE);
    }

    public static int locateVirtualProcessType(NewInoherbConfig inoherbConfig) {
        InoherbTools.examineProperties(inoherbConfig);
        Map map = (Map)JSON.parseObject((String)inoherbConfig.getProcessTypes(), Map.class);
        return (Integer)map.get("gameAdd");
    }

    public static int locateIssueType(Integer processType, NewInoherbConfig inoherbConfig) {
        InoherbTools.examineProperties(inoherbConfig);
        Map processTypes = (Map)JSON.parseObject((String)inoherbConfig.getProcessTypes(), Map.class);
        Map issueTypes = (Map)JSON.parseObject((String)inoherbConfig.getIssueTypes(), Map.class);
        return processType.compareTo((Integer)processTypes.get(EXCHANGE)) == 0 ? ((Integer)issueTypes.get(EXCHANGE)).intValue() : ((Integer)issueTypes.get(OTHERS)).intValue();
    }

    public static String getHostName(CreditsMessageDto message) {
        String url = message.getHttpUrl();
        return url.substring(0, url.indexOf(63));
    }

    public static String getHostName(SubCreditsMsgWrapper message) {
        String url = message.getHttpUrl();
        return url.substring(0, url.indexOf(63));
    }

    private static void examineProperties(NewInoherbConfig inoherbConfig) {
        if (StringUtils.isBlank((String)inoherbConfig.getProcessTypes())) {
            throw new ThirdpatyException("\u7f3a\u5c11\u5fc5\u8981\u914d\u7f6einoherb.new.processTypes");
        }
        if (StringUtils.isBlank((String)inoherbConfig.getIssueTypes())) {
            throw new ThirdpatyException("\u7f3a\u5c11\u5fc5\u8981\u914d\u7f6einoherb.new.issueTypes");
        }
    }
}

