/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.tool;

import com.alibaba.fastjson.JSONObject;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonTool {
    private static Logger log = LoggerFactory.getLogger(JsonTool.class);

    private JsonTool() {
    }

    public static String objectToJson(Object object) {
        String json = null;
        try {
            ObjectMapper mapper = new ObjectMapper();
            json = mapper.writeValueAsString(object);
        }
        catch (Exception e) {
            log.error("objectToJson", (Throwable)e);
        }
        return json;
    }

    public static <T> T jsonToObject(String json, Class<T> clazz) {
        try {
            ObjectMapper mapper = new ObjectMapper();
            return (T)mapper.readValue(json, clazz);
        }
        catch (Exception e) {
            log.error("jsonToObject", (Throwable)e);
            return null;
        }
    }

    public static JSONObject getAllJson(JSONObject o) {
        JSONObject json = new JSONObject();
        for (Map.Entry entry : o.entrySet()) {
            if (entry.getValue() instanceof JSONObject) {
                JSONObject child = (JSONObject)entry.getValue();
                for (Map.Entry chileEntry : child.entrySet()) {
                    json.put((String)chileEntry.getKey(), chileEntry.getValue());
                }
                continue;
            }
            json.put((String)entry.getKey(), entry.getValue());
        }
        JSONObject ret = new JSONObject();
        for (Map.Entry entry : json.entrySet()) {
            if (entry.getValue() instanceof JSONObject) {
                JSONObject child = (JSONObject)entry.getValue();
                for (Map.Entry chileEntry : child.entrySet()) {
                    ret.put((String)chileEntry.getKey(), chileEntry.getValue());
                }
                continue;
            }
            ret.put((String)entry.getKey(), entry.getValue());
        }
        return ret;
    }
}

