package cn.com.duiba.biz.credits;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Sets;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

import java.util.Map;
import java.util.Set;

/**
 * 香溢家定制
 * Created by sunyan on 2020/9/15.
 */
@Service
public class XyjApi {
    private static final Logger LOGGER = LoggerFactory.getLogger(XyjApi.class);
    /**
     * 应用id集合
     */
    private Set<Long> appIdSet = Sets.newHashSet(49614L);

    public boolean isXyjApp(Long appId) {
        return null != appId && appIdSet.contains(appId);
    }

    /**
     * 解析积分响应
     */
    public String parseCreditsResponse(String body, Map<String, String> authParams) {
        JSONObject jsonBody = JSON.parseObject(body);
        if (!"ok".equalsIgnoreCase(jsonBody.getString("status"))) {
            LOGGER.info("xyj credits error body={},orderNum={}",body,authParams.get("orderNum"));
            jsonBody.put("errorMessage","扣积分异常");
            return jsonBody.toJSONString();
        }
        return body;
    }
}
