package cn.com.duiba.constant;

import com.google.common.collect.Sets;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Configuration;

import java.util.Set;

/**
 * @author fja
 */
@Configuration
@ConfigurationProperties(prefix = "add.credits.noretry")
public class AddCreditsNoRetryConfig {
    private Set<Long> appIds = Sets.newHashSet(1L);

    public Set<Long> getAppIds() {
        return appIds;
    }

    public void setAppIds(Set<Long> appIds) {
        this.appIds = appIds;
    }

    /**
     * 是否是跳过加积分重试应用
     * @param appId -
     * @return true：跳过加积分重试
     */
    public boolean ifNoRetryApp(Long appId) {
        return this.appIds.contains(appId);
    }
}
