package cn.com.duiba.constant;

import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Configuration;

/**
 * @ClassName SpdBankConfig
 * @Description 浦发银行配置类
 * @Author zhoujunquan@duiba.com.cn
 * @Date 2021/1/9 2:48 下午
 * @Version 1.0
 **/
@Configuration
@ConfigurationProperties(prefix = "spdBank")
public class SpdBankConfig {
    /**
     * 浦发卡中心appId
     */
    private Long pdCardAppId = 19453L;

    /**
     * 开发者惠花券请求地址
     */
    private String apiUrl = "https://apiuat.spdbccc.com.cn/vcmp/externalcoupon/vcmp/coupon/send-coupon-notice";

    /**
     * 渠道信息
     */
    private String channel = "DBPT";

    /**
     * clientId
     */
    private String clientId = "gO9EnUvv-VFPX-EZ0g-ohbg-Gk6MbbwUXphd";

    /**
     * SM4密钥
     */
    private String sm4Secret = "FDBB1F6075A9122D";

    /**
     * 合作方私钥
     */
    private String hzfPrivateKey = "64188D4D2B19A8588B40E682C27F070508637705F9C1F4E2AA15644E30F1F0A0";

    /**
     * 卡中心公钥
     */
    private String kzxPublicKey = "66B9B356F1FE41F62D01BD02D7AD0697223DD7AE9C9C4DB1252C7488F0B4FC396D243E719B92600128FAE92DD5E1C37E0BD54C2D5B1BDBECF5E0C1CAE17EA153";

    /**
     * 奖品批次号
     */
    private String prizeNum = "16HRvEis00000109";

    public String getClientId() {
        return clientId;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public String getSm4Secret() {
        return sm4Secret;
    }

    public void setSm4Secret(String sm4Secret) {
        this.sm4Secret = sm4Secret;
    }

    public String getHzfPrivateKey() {
        return hzfPrivateKey;
    }

    public void setHzfPrivateKey(String hzfPrivateKey) {
        this.hzfPrivateKey = hzfPrivateKey;
    }

    public String getKzxPublicKey() {
        return kzxPublicKey;
    }

    public void setKzxPublicKey(String kzxPublicKey) {
        this.kzxPublicKey = kzxPublicKey;
    }

    public Long getPdCardAppId() {
        return pdCardAppId;
    }

    public void setPdCardAppId(Long pdCardAppId) {
        this.pdCardAppId = pdCardAppId;
    }

    public String getApiUrl() {
        return apiUrl;
    }

    public void setApiUrl(String apiUrl) {
        this.apiUrl = apiUrl;
    }

    public String getChannel() {
        return channel;
    }

    public void setChannel(String channel) {
        this.channel = channel;
    }

    public String getPrizeNum() {
        return prizeNum;
    }

    public void setPrizeNum(String prizeNum) {
        this.prizeNum = prizeNum;
    }

    public enum ResultMessageEnum {
        //发放成功
        SUCCESS("1", "发放成功"),
        //发放失败
        FAIL("2", "发放失败"),
        //奖励过期
        PAST_DUE("3", "奖励过期"),
        //请求超时
        TIME_OUT("4", "请求超时"),
        //文件补发
        REISSUE("5", "文件补发");

        private String code;
        private String message;

        ResultMessageEnum(String code, String message) {
            this.code = code;
            this.message = message;
        }

        public String getCode() {
            return code;
        }

        public void setCode(String code) {
            this.code = code;
        }

        public String getMessage() {
            return message;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        public static String getMessageByCode(String code) {
            for (ResultMessageEnum value : ResultMessageEnum.values()) {
                if (value.getCode().equals(code)) {
                    return value.getMessage();
                }
            }
            return "";
        }
    }
}