package cn.com.duiba.dao.custom.impl;

import cn.com.duiba.constant.DatabaseSchema;
import cn.com.duiba.dao.BaseDAO;
import cn.com.duiba.dao.custom.IcbcElifeRollbackCreditLogDAO;
import cn.com.duiba.domain.IcbcElifeRollbackCreditLogDO;
import com.google.common.collect.Maps;
import org.springframework.stereotype.Component;

import java.util.Map;

@Component
public class IcbcElifeRollbackCreditLogDAOImpl extends BaseDAO implements IcbcElifeRollbackCreditLogDAO {
    @Override
    protected DatabaseSchema chooseSchema() {
        return DatabaseSchema.DUIBA_CUSTOM;
    }

    @Override
    public Long insert(IcbcElifeRollbackCreditLogDO nrc) {
        insert("insert", nrc);
        return nrc.getId();
    }

    @Override
    public void update(IcbcElifeRollbackCreditLogDO nrc) {
        update("update", nrc);
    }

    @Override
    public IcbcElifeRollbackCreditLogDO select(long appId, String orderNum) {
        Map<String, Object> params = Maps.newHashMap();
        params.put("orderNum", orderNum);
        params.put("appId", appId);
        return selectOne("select", params);
    }


}
