package cn.com.duiba.tool;

import java.io.IOException;
import java.util.Properties;

import org.springframework.boot.env.PropertiesPropertySourceLoader;
import org.springframework.boot.env.PropertySourceLoader;
import org.springframework.core.PriorityOrdered;
import org.springframework.core.env.PropertiesPropertySource;
import org.springframework.core.env.PropertySource;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PropertiesLoaderUtils;
import org.springframework.stereotype.Component;

import cn.com.duiba.wolf.utils.BlowfishUtils;

/**
 * 自动配置增加配置项解密
 */
@Component
public class DuibaPropertySourceLoader extends PropertiesPropertySourceLoader implements PropertySourceLoader, PriorityOrdered {

    private static final String PREFIX = "dbseccode";
    private static final String SECRET = "CNxgrtFG2nYQUfu";

    @Override
    public PropertySource<?> load(String name, Resource resource, String profile) throws IOException {
        if (profile != null) {
        	return null;
        }
        Properties properties = PropertiesLoaderUtils.loadProperties(resource);
        Properties p = (Properties) properties.clone();
        for (Object key : p.keySet()) {
            if (key instanceof String) {
                String skey = (String) key;
                String value = (String) properties.get(skey);
                if (value != null && value.startsWith(PREFIX)) {
                    // 如果是加密的，进行解密操作
                    value = decode(value);
                    properties.put(skey, value);
                }
            }
        }
        return new PropertiesPropertySource(name, properties);
    }

    @Override
    public int getOrder() {
        return HIGHEST_PRECEDENCE;
    }

    private String decode(String value) {
    	String vl = value;
        if (vl.startsWith(PREFIX)) {
        	vl = value.substring(PREFIX.length());
            return BlowfishUtils.decryptBlowfish(vl, SECRET);
        }
        return vl;
    }
    
}
