/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.biz.credits;

import cn.com.duiba.constant.BaofengConfig;
import cn.com.duiba.thirdparty.dto.CreditsMessageDto;
import cn.com.duiba.tool.JsonTool;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class BaofengApi {
    private static final Logger logger = LoggerFactory.getLogger(BaofengApi.class);
    private static final String CHARACTER_ENCODE = "UTF-8";
    private static final String APPLICATION_JSON = "application/json";
    @Autowired
    private BaofengConfig baofengConfig;

    public boolean isBaofengAppid(Long appId) {
        String baofengAppId = this.baofengConfig.getAppId();
        return StringUtils.isNotBlank((CharSequence)baofengAppId) && baofengAppId.equals(String.valueOf(appId));
    }

    public CreditsMessageDto getAddCreditsMessage(CreditsMessageDto request) {
        request.setHttpUrl(request.getHttpUrl());
        Map authParams = request.getAuthParams();
        String uId = (String)authParams.get("uid");
        String credits = (String)authParams.get("credits");
        authParams.put("unionid", uId);
        authParams.put("score", credits);
        request.setAuthParams(authParams);
        request.setHttpType("post");
        return request;
    }

    public HttpRequestBase getAddCreditsHttpRequestBase(CreditsMessageDto message) {
        Map params = message.getAuthParams();
        String paramsJsonStr = JSONObject.toJSONString((Object)params);
        HttpPost httpPost = new HttpPost(message.getHttpUrl());
        StringEntity stringEntity = new StringEntity(paramsJsonStr, CHARACTER_ENCODE);
        httpPost.setEntity((HttpEntity)stringEntity);
        httpPost.setHeader("Content-Type", "application/json; charset=UTF-8");
        logger.info("\u5b9d\u4e30\u5b9a\u5236\u52a0\u79ef\u5206\u8bf7\u6c42\uff0crequestUrl\uff1a{}\uff0cparams\uff1a{}", (Object)message.getHttpUrl(), (Object)paramsJsonStr);
        return httpPost;
    }

    public String getResponseCredits(String body, Map<String, String> authParams) {
        logger.info("\u5b9d\u4e30\u52a0\u79ef\u5206\u884c\u65b9\u8fd4\u56de\u7ed3\u679c\uff1a\u3010body\u3011\uff1a{}", (Object)body);
        try {
            JSONObject jsonBody = JSON.parseObject((String)body);
            HashMap<String, String> duibaDoc = new HashMap<String, String>();
            Long code = Long.valueOf(jsonBody.getString("code"));
            String data = JSON.toJSONString((Object)jsonBody.get((Object)"data"));
            JSONObject parse = (JSONObject)JSONObject.parseObject((String)data, JSONObject.class);
            if (200L == code && parse.getLong("code") == 1L) {
                duibaDoc.put("status", "ok");
            } else {
                logger.warn("\u5b9d\u4e30\u5b9a\u5236\u79ef\u5206\u52a0\u51cf\u54cd\u5e94\u5931\u8d25 body={}\uff0c\u8bf7\u6c42\u53c2\u6570={}", (Object)body, (Object)JSON.toJSONString(authParams));
                duibaDoc.put("status", "fail");
            }
            duibaDoc.put("bizId", authParams.get("requestNo"));
            duibaDoc.put("credits", parse.getString("score"));
            return JsonTool.objectToJson(duibaDoc);
        }
        catch (Exception e) {
            logger.error("\u5b9d\u4e30\u5b9a\u5236\u79ef\u5206\u52a0\u51cf\u54cd\u5e94\u5f02\u5e38 body={}", (Object)body, (Object)e);
            return body;
        }
    }

    public static void main(String[] args) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("unionid", "test");
        map.put("score", "100");
        HttpPost httpPost = new HttpPost("https://bfapi.shengway.com/index.php?r=v1/customer-score&token=111");
        StringEntity se = new StringEntity(JSON.toJSONString(map), CHARACTER_ENCODE);
        httpPost.setEntity((HttpEntity)se);
        httpPost.setHeader("Content-Type", "application/json; charset=UTF-8");
        String result = null;
        try {
            CloseableHttpClient client = HttpClients.createDefault();
            CloseableHttpResponse response = client.execute((HttpUriRequest)httpPost);
            HttpEntity respEntity = response.getEntity();
            if (respEntity != null) {
                result = EntityUtils.toString((HttpEntity)respEntity, (String)"utf-8");
            }
            EntityUtils.consume((HttpEntity)respEntity);
            logger.info("\u5b9d\u4e30\u52a0\u79ef\u5206\u63a5\u53e3\u6267\u884c\u7ed3\u679c\uff1a{}", (Object)result);
        }
        catch (IOException e) {
            logger.error("\u8fd4\u56de\u7ed3\u679c\uff1a{}", (Object)e.getMessage());
            e.printStackTrace();
        }
    }
}

