/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.biz.credits;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.constant.BeingmateConfig;
import cn.com.duiba.domain.SupplierRequest;
import cn.com.duiba.tool.AssembleTool;
import cn.com.duiba.tool.JsonTool;
import com.alibaba.fastjson.JSONObject;
import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.HttpClient;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class BeingmateApi {
    private static final Logger LOGGER = LoggerFactory.getLogger(BeingmateApi.class);
    @Autowired
    private BeingmateConfig beingmateConfig;
    private Cache<String, String> tokenCache = Caffeine.newBuilder().expireAfterWrite(50L, TimeUnit.MINUTES).initialCapacity(5).maximumSize(100L).build();
    private static final String TOKEN = "token";

    public SupplierRequest getVirtualRequest(SupplierRequest request) {
        String url = request.getHttpUrl();
        String params = url.substring(url.indexOf(63) + 1);
        Map<String, String> paramMap = AssembleTool.getUrlParams(params);
        Map<String, String> authParams = request.getAuthParams();
        authParams.put("Openid", paramMap.get("uid"));
        authParams.put("SerialNumber", paramMap.get("orderNum"));
        authParams.put("postType", "raw");
        authParams.put("unicodeType", "UTF-8");
        request.setAuthParams(authParams);
        return request;
    }

    public void setHttpHeader(HttpRequestBase http) {
        String token = (String)this.tokenCache.get((Object)TOKEN, key -> {
            String tokenTemp = this.getToken();
            if (StringUtils.isBlank((String)tokenTemp)) {
                return null;
            }
            return tokenTemp;
        });
        http.setHeader("Content-Type", "application/json");
        http.setHeader("charset", "UTF-8");
        http.setHeader("Authorization", "Bearer " + token);
    }

    public String getVirtualResponse(SupplierRequest message, String body) {
        HashMap<String, String> duibaDoc = new HashMap<String, String>();
        try {
            JSONObject resultJson = JSONObject.parseObject((String)body);
            if (null == resultJson) {
                throw new BizException("\u5f00\u53d1\u8005\u63a5\u53e3\u54cd\u5e94\u5185\u5bb9\u5f02\u5e38");
            }
            Boolean success = resultJson.getBoolean("success");
            String status = resultJson.getString("status");
            if (!Objects.equals("200", status) || !success.booleanValue()) {
                throw new BizException(resultJson.getString("msg"));
            }
            duibaDoc.put("status", "success");
            duibaDoc.put("data", body);
        }
        catch (Exception e) {
            duibaDoc.put("status", "fail");
            duibaDoc.put("errorMessage", e.getMessage());
            LOGGER.info("[BeingmateApi-getVirtualResponse] Params:[message={},body={}], Msg:\u8d1d\u56e0\u7f8e-\u865a\u62df\u5546\u54c1\u63a5\u53e3\u54cd\u5e94\u89e3\u6790\u5f02\u5e38", new Object[]{JSONObject.toJSONString((Object)message), body, e});
        }
        return JsonTool.objectToJson(duibaDoc);
    }

    private String getToken() {
        String result = null;
        try {
            HashMap paramMap = Maps.newHashMap();
            paramMap.put("appid", this.beingmateConfig.getAppKey());
            paramMap.put("secret", this.beingmateConfig.getAppSecret());
            String url = AssembleTool.assembleUrl(this.beingmateConfig.getJwttokenUrl(), paramMap);
            result = BeingmateApi.sendGet(BeingmateApi.createHttpClient(), url, Charset.forName("utf-8"));
            JSONObject resultJson = JSONObject.parseObject((String)result);
            if (((Boolean)resultJson.get((Object)"success")).booleanValue() && Objects.equals("200", resultJson.get((Object)"status"))) {
                JSONObject response = JSONObject.parseObject((String)resultJson.getString("response"));
                return response.getString(TOKEN);
            }
        }
        catch (Exception e) {
            LOGGER.warn("\u8d1d\u56e0\u7f8e\u83b7\u53d6token\u503c\u5f02\u5e38, result={}", result, (Object)e);
        }
        LOGGER.warn("\u8d1d\u56e0\u7f8e\u83b7\u53d6token\u7ed3\u679c\u4e3a={}", result);
        return null;
    }

    private static HttpClient createHttpClient() {
        RequestConfig defaultRequestConfig = RequestConfig.custom().setSocketTimeout(5000).setConnectTimeout(5000).setConnectionRequestTimeout(3000).build();
        PoolingHttpClientConnectionManager cm = new PoolingHttpClientConnectionManager();
        cm.setMaxTotal(200);
        cm.setDefaultMaxPerRoute(20);
        return HttpClients.custom().setConnectionManager((HttpClientConnectionManager)cm).setDefaultRequestConfig(defaultRequestConfig).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String sendGet(HttpClient httpClient, String url, Charset encoding) {
        HttpGet httpget = new HttpGet(url);
        String resp = "";
        CloseableHttpResponse response = null;
        try {
            response = (CloseableHttpResponse)httpClient.execute((HttpUriRequest)httpget);
            resp = EntityUtils.toString((HttpEntity)response.getEntity(), (Charset)encoding);
        }
        catch (IOException e) {
            LOGGER.warn("\u8d1d\u56e0\u7f8e\u83b7\u53d6token\u53d1\u9001get\u8bf7\u6c42\u5931\u8d25\uff0curl={}", (Object)url, (Object)e);
        }
        finally {
            if (response != null) {
                try {
                    response.close();
                }
                catch (IOException e) {
                    LOGGER.warn("\u8d1d\u56e0\u7f8e\u83b7\u53d6token\u5173\u95edresponse\u5931\u8d25", (Throwable)e);
                }
            }
        }
        return resp;
    }
}

