/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.biz.credits;

import cn.com.duiba.biz.Exception.ThirdpatyException;
import cn.com.duiba.constant.HaoXiangNiConfig;
import cn.com.duiba.domain.SubCreditsMsgWrapper;
import cn.com.duiba.domain.SupplierRequest;
import cn.com.duiba.dto.haoxiangni.BaseResponse;
import cn.com.duiba.dto.haoxiangni.resp.AccessTokenRegisterResponse;
import cn.com.duiba.dto.haoxiangni.resp.CouponSendListResponse;
import cn.com.duiba.dto.haoxiangni.resp.CustomerBasicInfoGetResponse;
import cn.com.duiba.dto.haoxiangni.resp.PointAddResponse;
import cn.com.duiba.dto.haoxiangni.resp.PointInfoGetResponse;
import cn.com.duiba.dto.haoxiangni.resp.PointReduceResponse;
import cn.com.duiba.dto.haoxiangni.resp.basis.AccessTokenDetail;
import cn.com.duiba.dto.haoxiangni.resp.basis.CouponSendInfo;
import cn.com.duiba.dto.haoxiangni.resp.basis.CustomerBasicInfo;
import cn.com.duiba.dto.haoxiangni.resp.basis.CustomerPointInfo;
import cn.com.duiba.dto.haoxiangni.resp.basis.NickInfo;
import cn.com.duiba.order.center.api.dto.CreditsMessage;
import cn.com.duiba.thirdparty.dto.CreditsMessageDto;
import cn.com.duiba.tool.AssembleTool;
import cn.com.duiba.tool.haoxiangni.SignUtils;
import cn.com.duiba.wolf.cache.AdvancedCacheClient;
import cn.com.duiba.wolf.redis.RedisAtomicClient;
import cn.com.duiba.wolf.redis.RedisLock;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.time.Duration;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class HaoXiangNiApi {
    private static final Logger LOGGER = LoggerFactory.getLogger(HaoXiangNiApi.class);
    private static final String CACHE_TOKEN_KEY_FORMAT = "haoXiangNiToken_%s_%s";
    private static final String LOCK_TOKEN_KEY_FORMAT = "haoXiangNiLock_%s_%s";
    @Autowired
    private HaoXiangNiConfig haoXiangNiConfig;
    @Resource(name="httpClient")
    private CloseableHttpClient httpClient;
    @Resource(name="redisTemplate")
    private RedisAtomicClient redisAtomicClient;
    @Resource(name="redisTemplate")
    private AdvancedCacheClient advancedCacheClient;

    public Boolean isHaoXiangNi(Long appId) {
        Set<Long> appIds = this.haoXiangNiConfig.getAppIds();
        if (null == appIds) {
            return false;
        }
        return appIds.contains(appId);
    }

    public HttpRequestBase getSubCreditsMessage(CreditsMessage message) {
        String url = message.getHttpUrl();
        String paramsStr = url.substring(url.indexOf(63) + 1);
        Map<String, String> params = AssembleTool.getUrlParams(paramsStr);
        return this.getSubCreditsRequest(params);
    }

    public HttpRequestBase getSubCreditsMessage(SubCreditsMsgWrapper message) {
        String url = message.getHttpUrl();
        String paramsStr = url.substring(url.indexOf(63) + 1);
        Map<String, String> params = AssembleTool.getUrlParams(paramsStr);
        return this.getSubCreditsRequest(params);
    }

    private HttpPost getSubCreditsRequest(Map<String, String> params) {
        HttpPost httpPost = new HttpPost(HaoXiangNiConfig.Api.POINT_REDUCE.getApiAbsolutePath(this.haoXiangNiConfig));
        HashMap map = Maps.newHashMap();
        map.put("appKey", this.haoXiangNiConfig.getAppKey());
        map.put("nonce", System.currentTimeMillis());
        map.put("accessToken", this.getToken());
        map.put("groupId", this.haoXiangNiConfig.getGroupId());
        NickInfo nickInfo = this.getNickInfo(params.get("uid"));
        map.put("nick", nickInfo.getNick());
        map.put("platform", nickInfo.getPlatform());
        map.put("integralAccount", this.haoXiangNiConfig.getIntegralAccount());
        map.put("point", params.get("credits"));
        map.put("reduceType", 3);
        String desc = params.get("description");
        if (StringUtils.isNotBlank((CharSequence)desc)) {
            if (desc.length() > 100) {
                desc = desc.substring(0, 100);
            }
        } else {
            desc = "\u6263\u79ef\u5206";
        }
        map.put("remark", desc);
        map.put("sign", SignUtils.getSign(map, this.haoXiangNiConfig.getAppSecret()));
        StringEntity stringEntity = new StringEntity(JSON.toJSONString((Object)map), "UTF-8");
        stringEntity.setContentEncoding("UTF-8");
        stringEntity.setContentType("application/json");
        httpPost.setEntity((HttpEntity)stringEntity);
        return httpPost;
    }

    public HttpRequestBase getAddCreditsMessage(CreditsMessageDto message) {
        String httpUrl = message.getHttpUrl();
        String paramStr = httpUrl.substring(httpUrl.indexOf(63) + 1);
        Map<String, String> params = AssembleTool.getUrlParams(paramStr);
        return this.getAddCreditsRequest(params);
    }

    private HttpPost getAddCreditsRequest(Map<String, String> params) {
        HttpPost httpPost = new HttpPost(HaoXiangNiConfig.Api.POINT_ADD.getApiAbsolutePath(this.haoXiangNiConfig));
        HashMap map = Maps.newHashMap();
        map.put("appKey", this.haoXiangNiConfig.getAppKey());
        map.put("nonce", System.currentTimeMillis());
        map.put("accessToken", this.getToken());
        map.put("groupId", this.haoXiangNiConfig.getGroupId());
        NickInfo nickInfo = this.getNickInfo(params.get("uid"));
        map.put("nick", nickInfo.getNick());
        map.put("platform", nickInfo.getPlatform());
        map.put("integralAccount", this.haoXiangNiConfig.getIntegralAccount());
        map.put("point", params.get("credits"));
        map.put("sendType", 1);
        String desc = params.get("description");
        if (StringUtils.isNotBlank((CharSequence)desc)) {
            if (desc.length() > 100) {
                desc = desc.substring(0, 100);
            }
        } else {
            desc = "\u52a0\u79ef\u5206";
        }
        map.put("remark", desc);
        map.put("sign", SignUtils.getSign(map, this.haoXiangNiConfig.getAppSecret()));
        StringEntity stringEntity = new StringEntity(JSON.toJSONString((Object)map), "UTF-8");
        stringEntity.setContentEncoding("UTF-8");
        stringEntity.setContentType("application/json");
        httpPost.setEntity((HttpEntity)stringEntity);
        return httpPost;
    }

    public String parseCreditsRsp(String body, Boolean addCredits, Map<String, String> authParams) {
        HashMap<String, String> map = new HashMap<String, String>();
        if (StringUtils.isBlank((CharSequence)body)) {
            map.put("status", "fail");
            map.put("errorMessage", "\u597d\u60f3\u4f60\u65b0\u589e/\u6263\u51cf\u79ef\u5206\u63a5\u53e3\u8fd4\u56de\u4e3a\u7a7a");
            return JSON.toJSONString(map);
        }
        try {
            if (addCredits.booleanValue()) {
                this.parseAwardIntegralResp(body, map, authParams);
            } else {
                this.parseReduceIntegralResp(body, map, authParams);
            }
        }
        catch (Exception e) {
            LOGGER.error("\u597d\u60f3\u4f60\u65b0\u589e/\u6263\u51cf\u79ef\u5206\u63a5\u53e3\u89e3\u6790\u9519\u8bef:{}--\u662f\u5426\u65b0\u589e:{}", new Object[]{body, addCredits, e});
            map.put("status", "fail");
            map.put("errorMessage", "\u597d\u60f3\u4f60\u65b0\u589e/\u6263\u51cf\u79ef\u5206\u89e3\u6790\u7ed3\u679c\u9519\u8bef");
        }
        return JSONObject.toJSONString(map);
    }

    private void parseAwardIntegralResp(String body, Map<String, String> map, Map<String, String> authParams) {
        PointAddResponse response = (PointAddResponse)JSON.parseObject((String)body, PointAddResponse.class);
        if (response.getSuccess().booleanValue()) {
            CustomerPointInfo customerPointInfo = (CustomerPointInfo)response.getResult();
            map.put("status", "ok");
            map.put("bizId", response.getRequestId());
            map.put("credits", customerPointInfo.getAvailPoint().longValue() + "");
        } else {
            LOGGER.warn("\u597d\u60f3\u4f60\uff0c\u52a0\u79ef\u5206\uff0c\u5931\u8d25\uff0cparams={} response={}", (Object)JSON.toJSONString(authParams), (Object)JSON.toJSONString((Object)response));
            map.put("status", "fail");
            String errorMsg = response.getMsg();
            if (StringUtils.length((CharSequence)errorMsg) > 255) {
                errorMsg = errorMsg.substring(0, 255);
            }
            map.put("errorMessage", errorMsg);
        }
    }

    public void parseReduceIntegralResp(String body, Map<String, String> map, Map<String, String> authParams) {
        PointReduceResponse response = (PointReduceResponse)JSON.parseObject((String)body, PointReduceResponse.class);
        if (response.getSuccess().booleanValue()) {
            CustomerPointInfo customerPointInfo = (CustomerPointInfo)response.getResult();
            map.put("status", "ok");
            map.put("bizId", response.getRequestId());
            map.put("credits", customerPointInfo.getAvailPoint().longValue() + "");
        } else {
            LOGGER.warn("\u597d\u60f3\u4f60\uff0c\u51cf\u79ef\u5206\uff0c\u5931\u8d25\uff0cparams={} response={}", (Object)JSON.toJSONString(authParams), (Object)JSON.toJSONString((Object)response));
            map.put("status", "fail");
            String errorMsg = response.getMsg();
            if (StringUtils.length((CharSequence)errorMsg) > 255) {
                errorMsg = errorMsg.substring(0, 255);
            }
            map.put("errorMessage", errorMsg);
        }
    }

    public HttpRequestBase getVirtualRequest(SupplierRequest request) {
        String url = request.getHttpUrl();
        String paramsStr = url.substring(url.indexOf(63) + 1);
        Map<String, String> params = AssembleTool.getUrlParams(paramsStr);
        request.setAuthParams(params);
        return this.getRechargeRequest(params);
    }

    private HttpRequestBase getRechargeRequest(Map<String, String> params) {
        HttpPost httpPost = new HttpPost(HaoXiangNiConfig.Api.STORE_COUPON_SEND.getApiAbsolutePath(this.haoXiangNiConfig));
        HashMap map = Maps.newHashMap();
        map.put("appKey", this.haoXiangNiConfig.getAppKey());
        map.put("nonce", System.currentTimeMillis());
        map.put("accessToken", this.getToken());
        map.put("groupId", this.haoXiangNiConfig.getGroupId());
        JSONObject customerNickInfo = new JSONObject();
        NickInfo nickInfo = this.getNickInfo(params.get("uid"));
        customerNickInfo.put("nick", (Object)nickInfo.getNick());
        customerNickInfo.put("platform", (Object)nickInfo.getPlatform());
        map.put("customerNickInfo", Lists.newArrayList((Object[])new JSONObject[]{customerNickInfo}));
        map.put("couponCode", params.get("params"));
        map.put("sendChannelType", 2);
        map.put("shopId", this.haoXiangNiConfig.getShopId());
        map.put("sign", SignUtils.getSign(map, this.haoXiangNiConfig.getAppSecret()));
        StringEntity stringEntity = new StringEntity(JSON.toJSONString((Object)map), "UTF-8");
        stringEntity.setContentEncoding("UTF-8");
        stringEntity.setContentType("application/json");
        httpPost.setEntity((HttpEntity)stringEntity);
        return httpPost;
    }

    public String getVirtualResponse(SupplierRequest request, String body) {
        Map<String, String> params = request.getAuthParams();
        String uid = params.get("uid");
        return this.getVirtualRechargeResponse(body, uid);
    }

    private String getVirtualRechargeResponse(String body, String uid) {
        HashMap<String, String> duibaDoc = new HashMap<String, String>();
        if (StringUtils.isBlank((CharSequence)body)) {
            throw new ThirdpatyException("\u597d\u60f3\u4f60\uff0c\u5145\u503c\u5546\u54c1\u5b9a\u5236\uff0c\u8fd4\u56de\u7ed3\u679c\u4e3a\u7a7a");
        }
        try {
            CouponSendListResponse response = (CouponSendListResponse)JSON.parseObject((String)body, CouponSendListResponse.class);
            if (response.getSuccess().booleanValue() && ((CouponSendInfo)response.getResult()).getSuccessCount() > 0) {
                duibaDoc.put("status", "success");
                duibaDoc.put("supplierBizId", response.getRequestId());
            } else {
                CouponSendInfo couponSendInfo;
                LOGGER.warn("\u597d\u60f3\u4f60\uff0c\u5145\u503c\u5546\u54c1\u5b9a\u5236\uff0c\u5931\u8d25\uff0cuid={} resp={}", (Object)uid, (Object)JSON.toJSONString((Object)response));
                duibaDoc.put("status", "fail");
                String errorMsg = response.getMsg();
                if (response.getResult() != null && (couponSendInfo = (CouponSendInfo)response.getResult()).getFailedCount() > 0 && CollectionUtils.isNotEmpty(couponSendInfo.getFailedCustomerInfo())) {
                    errorMsg = couponSendInfo.getFailedCustomerInfo().get(0).getFailedMessage();
                }
                if (StringUtils.length((CharSequence)errorMsg) > 255) {
                    errorMsg = errorMsg.substring(0, 255);
                }
                duibaDoc.put("errorMessage", errorMsg);
            }
            duibaDoc.put("credits", this.getCredits(uid));
        }
        catch (Exception e) {
            LOGGER.error("\u597d\u60f3\u4f60\uff0c\u5145\u503c\u5546\u54c1\u5b9a\u5236\uff0c\u7ed3\u679c\u89e3\u6790\u9519\u8bef:{}", (Object)body, (Object)e);
            duibaDoc.put("status", "fail");
            duibaDoc.put("errorMessage", "\u6ce8\u5238\u63a5\u53e3\u54cd\u5e94\u89e3\u6790\u9519\u8bef");
        }
        return JSON.toJSONString(duibaDoc);
    }

    public String getCredits(String uid) {
        Object response;
        String url = HaoXiangNiConfig.Api.CONSUMER_POINT_INFO_GET.getApiAbsolutePath(this.haoXiangNiConfig);
        HttpPost httpPost = new HttpPost(url);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("appKey", this.haoXiangNiConfig.getAppKey());
        map.put("nonce", System.currentTimeMillis());
        map.put("accessToken", this.getToken());
        map.put("groupId", this.haoXiangNiConfig.getGroupId());
        NickInfo nickInfo = this.getNickInfo(uid);
        map.put("nick", nickInfo.getNick());
        map.put("platform", nickInfo.getPlatform());
        map.put("integralAccount", this.haoXiangNiConfig.getIntegralAccount());
        map.put("sign", SignUtils.getSign(map, this.haoXiangNiConfig.getAppSecret()));
        StringEntity stringEntity = new StringEntity(JSON.toJSONString(map), "UTF-8");
        stringEntity.setContentEncoding("UTF-8");
        stringEntity.setContentType("application/json");
        httpPost.setEntity((HttpEntity)stringEntity);
        String resp = null;
        try {
            response = this.httpClient.execute((HttpUriRequest)httpPost);
            Throwable throwable = null;
            try {
                HttpEntity entity = response.getEntity();
                resp = EntityUtils.toString((HttpEntity)entity, (String)"UTF-8");
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (response != null) {
                    if (throwable != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    } else {
                        response.close();
                    }
                }
            }
        }
        catch (IOException e) {
            LOGGER.warn("\u597d\u60f3\u4f60\uff0c\u83b7\u53d6\u7528\u6237\u79ef\u5206\uff0c\u5f02\u5e38\uff0c\u8bf7\u6c42\u53c2\u6570params={}", (Object)JSON.toJSONString(map), (Object)e);
            throw new ThirdpatyException("\u597d\u60f3\u4f60\uff0c\u83b7\u53d6\u7528\u6237\u79ef\u5206\uff0c\u5f02\u5e38");
        }
        if (StringUtils.isBlank((CharSequence)resp)) {
            throw new ThirdpatyException("\u597d\u60f3\u4f60\uff0c\u83b7\u53d6\u7528\u6237\u79ef\u5206\uff0c\u5931\u8d25");
        }
        response = (PointInfoGetResponse)JSON.parseObject((String)resp, PointInfoGetResponse.class);
        if (!((BaseResponse)response).getSuccess().booleanValue()) {
            LOGGER.warn("\u597d\u60f3\u4f60\uff0c\u83b7\u53d6\u7528\u6237\u79ef\u5206\uff0c\u5931\u8d25\uff0c\u8bf7\u6c42\u53c2\u6570params={},response={}", (Object)JSON.toJSONString(map), (Object)JSON.toJSONString((Object)response));
            throw new ThirdpatyException("\u597d\u60f3\u4f60\uff0c\u83b7\u53d6\u7528\u6237\u79ef\u5206\uff0c\u5931\u8d25");
        }
        String credits = String.valueOf(((CustomerPointInfo)((BaseResponse)response).getResult()).getAvailPoint().longValue());
        return credits;
    }

    public NickInfo getNickInfo(String wechatUnionId) {
        Object response;
        String url = HaoXiangNiConfig.Api.CUSTOMER_INFO_4_THIRD_PARTY_GET.getApiAbsolutePath(this.haoXiangNiConfig);
        HttpPost httpPost = new HttpPost(url);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("appKey", this.haoXiangNiConfig.getAppKey());
        map.put("nonce", System.currentTimeMillis());
        map.put("accessToken", this.getToken());
        map.put("groupId", this.haoXiangNiConfig.getGroupId());
        map.put("wechatUnionid", wechatUnionId);
        map.put("sign", SignUtils.getSign(map, this.haoXiangNiConfig.getAppSecret()));
        StringEntity stringEntity = new StringEntity(JSON.toJSONString(map), "UTF-8");
        stringEntity.setContentEncoding("UTF-8");
        stringEntity.setContentType("application/json");
        httpPost.setEntity((HttpEntity)stringEntity);
        String resp = null;
        try {
            response = this.httpClient.execute((HttpUriRequest)httpPost);
            Throwable throwable = null;
            try {
                HttpEntity entity = response.getEntity();
                resp = EntityUtils.toString((HttpEntity)entity, (String)"UTF-8");
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (response != null) {
                    if (throwable != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    } else {
                        response.close();
                    }
                }
            }
        }
        catch (IOException e) {
            LOGGER.warn("\u597d\u60f3\u4f60\uff0c\u8bf7\u6c42\u83b7\u53d6\u4f1a\u5458\u8be6\u60c5\uff0c\u5f02\u5e38\uff0c\u8bf7\u6c42\u53c2\u6570params={}", (Object)JSON.toJSONString(map), (Object)e);
            throw new ThirdpatyException("\u597d\u60f3\u4f60\uff0c\u8bf7\u6c42\u83b7\u53d6\u4f1a\u5458\u8be6\u60c5\uff0c\u5f02\u5e38");
        }
        if (StringUtils.isBlank((CharSequence)resp)) {
            throw new ThirdpatyException("\u597d\u60f3\u4f60\uff0c\u8bf7\u6c42\u83b7\u53d6\u4f1a\u5458\u8be6\u60c5\uff0c\u5931\u8d25");
        }
        response = (CustomerBasicInfoGetResponse)JSON.parseObject((String)resp, CustomerBasicInfoGetResponse.class);
        if (!((BaseResponse)response).getSuccess().booleanValue()) {
            LOGGER.warn("\u597d\u60f3\u4f60\uff0c\u8bf7\u6c42\u83b7\u53d6\u4f1a\u5458\u8be6\u60c5\uff0c\u5931\u8d25\uff0cparams={} response={}", (Object)JSON.toJSONString(map), (Object)JSON.toJSONString((Object)response));
            throw new ThirdpatyException("\u597d\u60f3\u4f60\uff0c\u8bf7\u6c42\u83b7\u53d6\u4f1a\u5458\u8be6\u60c5\uff0c\u5931\u8d25");
        }
        return ((CustomerBasicInfo)((BaseResponse)response).getResult()).getNickInfoList().get(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getToken() {
        String cacheKey = String.format(CACHE_TOKEN_KEY_FORMAT, this.haoXiangNiConfig.getAppKey(), this.haoXiangNiConfig.getGroupId());
        String cacheToken = (String)this.advancedCacheClient.get(cacheKey);
        if (StringUtils.isNotBlank((CharSequence)cacheToken)) {
            AccessTokenDetail tokenDetail = (AccessTokenDetail)JSON.parseObject((String)cacheToken, AccessTokenDetail.class);
            return tokenDetail.getAccessToken();
        }
        String lockKey = String.format(LOCK_TOKEN_KEY_FORMAT, this.haoXiangNiConfig.getAppKey(), this.haoXiangNiConfig.getGroupId());
        RedisLock lock = this.redisAtomicClient.getLock(lockKey, 2L);
        if (lock == null) {
            throw new ThirdpatyException("\u597d\u60f3\u4f60\uff0c\u8bf7\u6c42token\uff0c\u83b7\u53d6\u5206\u5e03\u5f0f\u9501\u5931\u8d25");
        }
        try {
            String url = HaoXiangNiConfig.Api.ACCESS_TOKEN_REGISTER.getApiAbsolutePath(this.haoXiangNiConfig);
            HttpPost httpPost = new HttpPost(url);
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("appKey", this.haoXiangNiConfig.getAppKey());
            map.put("groupId", this.haoXiangNiConfig.getGroupId());
            map.put("nonce", System.currentTimeMillis());
            map.put("sign", SignUtils.getSign(map, this.haoXiangNiConfig.getAppSecret()));
            StringEntity stringEntity = new StringEntity(JSON.toJSONString(map), "UTF-8");
            stringEntity.setContentEncoding("UTF-8");
            stringEntity.setContentType("application/json");
            httpPost.setEntity((HttpEntity)stringEntity);
            String resp = null;
            try (CloseableHttpResponse response = this.httpClient.execute((HttpUriRequest)httpPost);){
                HttpEntity entity = response.getEntity();
                resp = EntityUtils.toString((HttpEntity)entity, (String)"UTF-8");
            }
            catch (IOException e) {
                LOGGER.warn("\u597d\u60f3\u4f60\uff0c\u8bf7\u6c42token\uff0c\u5f02\u5e38\uff0c\u8bf7\u6c42\u53c2\u6570params={}", (Object)JSON.toJSONString(map), (Object)e);
                throw new ThirdpatyException("\u597d\u60f3\u4f60\uff0c\u8bf7\u6c42token\uff0c\u5f02\u5e38");
            }
            if (StringUtils.isBlank((CharSequence)resp)) {
                throw new ThirdpatyException("\u597d\u60f3\u4f60\uff0c\u8bf7\u6c42token\uff0c\u5931\u8d25");
            }
            AccessTokenRegisterResponse accessTokenRegisterResponse = (AccessTokenRegisterResponse)JSON.parseObject((String)resp, AccessTokenRegisterResponse.class);
            if (!accessTokenRegisterResponse.getSuccess().booleanValue()) {
                LOGGER.warn("\u597d\u60f3\u4f60\uff0c\u8bf7\u6c42token\uff0c\u5931\u8d25\uff0cparams={},response={}", (Object)JSON.toJSONString(map), (Object)JSON.toJSONString((Object)accessTokenRegisterResponse));
                throw new ThirdpatyException("\u597d\u60f3\u4f60\uff0c\u8bf7\u6c42token\uff0c\u5931\u8d25");
            }
            AccessTokenDetail accessTokenDetail = (AccessTokenDetail)accessTokenRegisterResponse.getResult();
            Date now = new Date();
            Date expireTime = accessTokenDetail.getExpiredTime();
            long seconds = Duration.between(now.toInstant(), expireTime.toInstant()).getSeconds();
            int exp = (int)(seconds - 10L);
            if (exp <= 0) {
                exp = 1;
            }
            this.advancedCacheClient.set(cacheKey, (Object)JSON.toJSONString((Object)accessTokenDetail), exp, TimeUnit.SECONDS);
            String string = accessTokenDetail.getAccessToken();
            return string;
        }
        finally {
            lock.unlock();
        }
    }
}

