/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.biz.credits;

import cn.com.duiba.domain.SubCreditsMsgWrapper;
import cn.com.duiba.domain.SupplierRequest;
import cn.com.duiba.notifycenter.domain.NotifyQueueDO;
import cn.com.duiba.order.center.api.dto.CreditsMessage;
import cn.com.duiba.tool.AssembleTool;
import cn.com.duiba.tool.JsonTool;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class IqiyiApi {
    private static Logger log = LoggerFactory.getLogger(IqiyiApi.class);
    private static final List<Long> iqiyiToutiaoIds = Arrays.asList(37066L, 38347L);
    @Value(value="${iqiyi.app.appkey}")
    private String iqiyiAppkey;
    @Value(value="${iqiyi.app.secret}")
    private String iqiyiAppSecret;
    private String expPrefix = "addexp";

    public CreditsMessage getSubCreditsMessage(CreditsMessage request) {
        String url = request.getHttpUrl();
        String host = url.substring(0, url.indexOf(63));
        String urlParams = url.substring(url.indexOf(63) + 1, url.length());
        Map<String, String> crediMap = AssembleTool.getUrlParams(urlParams);
        Map<String, String> authParams = this.getIqiyiAuthParams(Long.valueOf(request.getAppId()));
        authParams.put("userId", crediMap.get("uid"));
        authParams.put("orderNum", crediMap.get("orderNum"));
        authParams.put("score", crediMap.get("credits"));
        authParams.put("sign", this.sign(authParams, this.iqiyiAppSecret));
        request.setAuthParams(authParams);
        request.setHttpType("post");
        request.setHttpUrl(host);
        return request;
    }

    public SubCreditsMsgWrapper getSubCreditsMessage(SubCreditsMsgWrapper request) {
        String url = request.getHttpUrl();
        String host = url.substring(0, url.indexOf(63));
        String urlParams = url.substring(url.indexOf(63) + 1, url.length());
        Map<String, String> crediMap = AssembleTool.getUrlParams(urlParams);
        Map<String, String> authParams = this.getIqiyiAuthParams(request.getSubCreditsMsg().getAppId());
        authParams.put("userId", crediMap.get("uid"));
        authParams.put("orderNum", crediMap.get("orderNum"));
        authParams.put("score", crediMap.get("credits"));
        authParams.put("sign", this.sign(authParams, this.iqiyiAppSecret));
        request.getSubCreditsMsg().setAuthParams(authParams);
        request.getSubCreditsMsg().setHttpType(2);
        request.setHttpUrl(host);
        return request;
    }

    private Map<String, String> getIqiyiAuthParams(Long appId) {
        HashMap<String, String> authParams = new HashMap<String, String>();
        if (iqiyiToutiaoIds.contains(appId)) {
            authParams.put("verticalCode", "Toutiao");
            authParams.put("typeCode", "Point");
            authParams.put("agenttype", "12");
            authParams.put("agentversion", "1.12.10");
            authParams.put("srcplatform", "12");
            authParams.put("appver", "1.12.10");
            authParams.put("itemSystem", "2");
        } else {
            authParams.put("verticalCode", "iQIYI");
            authParams.put("typeCode", "point");
            authParams.put("agenttype", "12");
            authParams.put("agentversion", "8.9.0");
            authParams.put("srcplatform", "12");
            authParams.put("appver", "8.9.0");
            authParams.put("itemSystem", "2");
        }
        authParams.put("appKey", this.iqiyiAppkey);
        return authParams;
    }

    public HttpRequestBase getRequestNotify(String notifyUrl, NotifyQueueDO record) {
        Map<String, String> authParams = this.getIqiyiAuthParams(record.getAppId());
        authParams.put("userId", record.getPartnerUserId());
        authParams.put("orderNum", record.getDuibaOrderNum());
        if (record.getDeveloperBizId() != null) {
            authParams.put("transId", record.getDeveloperBizId());
        }
        authParams.put("success", String.valueOf(record.getResult()));
        authParams.put("sign", this.sign(authParams, this.iqiyiAppSecret));
        return new HttpPost(AssembleTool.assembleUrl(notifyUrl, authParams));
    }

    private String sign(Map<String, String> params, String secretKey) {
        TreeMap<String, String> sortedParams = new TreeMap<String, String>(params);
        sortedParams.remove("sign");
        StringBuilder sb = new StringBuilder();
        for (Map.Entry entry : sortedParams.entrySet()) {
            String val = (String)entry.getValue();
            sb.append((String)entry.getKey()).append("=").append(StringUtils.defaultIfEmpty((String)val, (String)"")).append("|");
        }
        return DigestUtils.md5Hex((String)sb.append(secretKey).toString());
    }

    public SupplierRequest getVirtualRequest(SupplierRequest request) {
        String url = request.getHttpUrl();
        String host = url.substring(0, url.indexOf(63));
        String urlParams = url.substring(url.indexOf(63) + 1, url.length());
        Map<String, String> crediMap = AssembleTool.getUrlParams(urlParams);
        Map<String, String> authParams = this.getIqiyiAuthParams(Long.valueOf(request.getAppId()));
        authParams.remove("itemSystem");
        authParams.put("scoreType", "1");
        authParams.put("userId", crediMap.get("uid"));
        authParams.put("channelCode", crediMap.get("params"));
        String param = crediMap.get("params");
        if (StringUtils.isNotBlank((String)param) && param.startsWith(this.expPrefix)) {
            authParams.put("typeCode", "paradise");
        }
        authParams.put("sign", this.sign(authParams, this.iqiyiAppSecret));
        request.setHttpUrl(host);
        request.setAuthParams(authParams);
        return request;
    }

    public String getVirtualRespone(String body) {
        JSONObject jBody = new JSONObject();
        HashMap<String, String> duibaDoc = new HashMap<String, String>();
        try {
            JSONObject jsonBody = JSON.parseObject((String)body);
            JSONArray jList = jsonBody.getJSONArray("data");
            if (jList != null && !jList.isEmpty()) {
                jBody = jList.getJSONObject(0);
            }
        }
        catch (Exception e) {
            log.error("\u8fd4\u56debody\u89e3\u6790\u51fa\u9519,VirtualRespone body=" + body, (Throwable)e);
            duibaDoc.put("status", "fail");
            duibaDoc.put("errorMessage", "\u8fd4\u56debody\u89e3\u6790\u51fa\u9519\uff1a" + e.getMessage());
            return JsonTool.objectToJson(duibaDoc);
        }
        String code = jBody.getString("code");
        if ("A0000".equals(code)) {
            duibaDoc.put("status", "success");
            duibaDoc.put("credits", "-1");
        } else {
            duibaDoc.put("status", "fail");
            duibaDoc.put("errorMessage", jBody.getString("message"));
        }
        return JsonTool.objectToJson(duibaDoc);
    }
}

