/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.biz.credits;

import cn.com.duiba.biz.Exception.ThirdpatyException;
import cn.com.duiba.boot.utils.SpringEnvironmentUtils;
import cn.com.duiba.constant.ShandongChinaMobileConfig;
import cn.com.duiba.domain.SubCreditsMsgWrapper;
import cn.com.duiba.order.center.api.dto.CreditsMessage;
import cn.com.duiba.tool.AssembleTool;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Maps;
import java.security.KeyFactory;
import java.security.PrivateKey;
import java.security.Signature;
import java.security.spec.PKCS8EncodedKeySpec;
import java.util.Base64;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class ShandongChinaMobileApi {
    private static final Logger log = LoggerFactory.getLogger(ShandongChinaMobileApi.class);
    private static final String CHANNEL_CODE = "duiba";
    private static final String SUCCESS_CODE = "0";
    @Resource
    private ShandongChinaMobileConfig shandongChinaMobileConfig;

    public boolean isShandongChinaMobile(Long appId) {
        return this.shandongChinaMobileConfig.getAppIds().contains(appId);
    }

    public CreditsMessage getSubCreditsMessage(CreditsMessage message) {
        String url = message.getHttpUrl();
        String newUrl = url.substring(0, url.indexOf(63));
        Map authParams = message.getAuthParams();
        message.setHttpUrl(AssembleTool.assembleUrl(newUrl, this.getNewParamMap(authParams)));
        return message;
    }

    public SubCreditsMsgWrapper getSubCreditsMessage(SubCreditsMsgWrapper message) {
        String url = message.getHttpUrl();
        String newUrl = url.substring(0, url.indexOf(63));
        Map authParams = message.getSubCreditsMsg().getAuthParams();
        message.setHttpUrl(AssembleTool.assembleUrl(newUrl, this.getNewParamMap(authParams)));
        return message;
    }

    public String parseCreditsRsp(String body) {
        log.info("\u5c71\u4e1c\u79fb\u52a8\u79ef\u5206response, body={}", (Object)body);
        JSONObject jsonBody = JSON.parseObject((String)body);
        JSONObject response = new JSONObject();
        if (StringUtils.isNotEmpty((CharSequence)body) && SUCCESS_CODE.equals(jsonBody.getString("resultCode"))) {
            response.put("status", (Object)"ok");
            response.put("credits", (Object)jsonBody.getJSONObject("resultObject").getString("ownHoney"));
            response.put("bizId", (Object)jsonBody.getJSONObject("resultObject").getString("orderId"));
        } else {
            response.put("status", (Object)"fail");
            response.put("errorMessage", jsonBody.get((Object)"resultMessage"));
        }
        return response.toString();
    }

    private Map<String, String> getNewParamMap(Map<String, String> params) {
        HashMap map = Maps.newHashMap();
        map.put("telnum", params.get("uid"));
        if (SpringEnvironmentUtils.isDevEnv() || SpringEnvironmentUtils.isTestEnv()) {
            map.put("telnum", "14706407549");
        }
        map.put("costHoney", params.get("credits"));
        map.put("goodsName", params.get("description"));
        map.put("orderId", params.get("orderNum"));
        map.put("channelCode", CHANNEL_CODE);
        map.put("sign", this.generateSign(map));
        return map;
    }

    private String generateSign(Map<String, String> contentMap) {
        String plaintext = contentMap.get("orderId") + "_" + contentMap.get("channelCode");
        try {
            PKCS8EncodedKeySpec keySpec = new PKCS8EncodedKeySpec(Base64.getDecoder().decode(this.shandongChinaMobileConfig.getPrivateKey()));
            KeyFactory keyFactory = KeyFactory.getInstance("RSA");
            PrivateKey key = keyFactory.generatePrivate(keySpec);
            Signature signature = Signature.getInstance("MD5withRSA");
            signature.initSign(key);
            signature.update(plaintext.getBytes());
            return Base64.getEncoder().encodeToString(signature.sign());
        }
        catch (Exception e) {
            log.error("\u5c71\u4e1c\u79fb\u52a8\u7b7e\u540d\u751f\u6210\u5931\u8d25, param={}", contentMap, (Object)e);
            throw new ThirdpatyException("\u5c71\u4e1c\u79fb\u52a8\u7b7e\u540d\u751f\u6210\u5931\u8d25");
        }
    }
}

