/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.biz.credits;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.utils.SpringEnvironmentUtils;
import cn.com.duiba.constant.WatsonsConfig;
import cn.com.duiba.domain.SubCreditsMsgWrapper;
import cn.com.duiba.domain.SupplierRequest;
import cn.com.duiba.thirdparty.dto.CreditsMessageDto;
import cn.com.duiba.tool.AssembleTool;
import cn.com.duiba.tool.MD5;
import cn.com.duiba.tool.WatsonsSignUtil;
import cn.com.duiba.wolf.utils.DateUtils;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.client.methods.HttpRequestBase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class WatsonsNewApi {
    private static final Logger LOGGER = LoggerFactory.getLogger(WatsonsNewApi.class);
    @Autowired
    private WatsonsConfig watsonsConfig;

    public HttpRequestBase getAddCreditsMessageRequest(CreditsMessageDto message) {
        try {
            String url = message.getHttpUrl();
            String host = url.substring(0, url.indexOf(63));
            String params = url.substring(url.indexOf(63) + 1, url.length());
            Map<String, String> urlParams = AssembleTool.getUrlParams(params);
            JSONObject data = new JSONObject();
            data.put("memberId", (Object)urlParams.get("uid"));
            data.put("numOfPoint", (Object)urlParams.get("credits"));
            data.put("typeCode", (Object)"Accrual");
            data.put("productName", (Object)"Point Adjustment_for Award points_A");
            data.put("storeId", (Object)"1");
            data.put("txnChannel", (Object)"System");
            Map<String, Object> newParams = this.signParam(data);
            return AssembleTool.assembleRequestJson(host, JSON.toJSONString(newParams));
        }
        catch (Exception e) {
            LOGGER.error("WatsonsApi-getAddCreditsMessage \u53d1\u751f\u5f02\u5e38\uff0c\u8bf7\u6c42\u53c2\u6570:message = [{}]", (Object)JSON.toJSONString((Object)message), (Object)e);
            return null;
        }
    }

    private Map<String, Object> signParam(JSONObject data) throws BizException {
        String appId = this.watsonsConfig.getDuibaIdentifier2();
        String appSecret = this.watsonsConfig.getAppSecret();
        String timestamp = String.valueOf(System.currentTimeMillis() / 1000L);
        String dataStr = data.toJSONString();
        try {
            String sourceStr = appId + appSecret + timestamp + dataStr;
            String sign = MD5.md5(sourceStr).toUpperCase();
            HashMap<String, Object> newParams = new HashMap<String, Object>();
            newParams.put("appId", appId);
            newParams.put("timestamp", timestamp);
            newParams.put("sign", sign);
            newParams.put("data", data);
            if (!SpringEnvironmentUtils.isProdEnv()) {
                LOGGER.info("watsonsApi\u83b7\u53d6\u57fa\u7840\u914d\u7f6e:\u52a0\u7b7e\u6570\u636e\uff1a{}\uff0c\u57fa\u7840\u6570\u636e:{}", (Object)sourceStr, (Object)JSON.toJSONString(newParams));
            }
            return newParams;
        }
        catch (Exception e) {
            LOGGER.warn("WatsonsApi-signParam \u53d1\u751f\u5f02\u5e38\uff0c\u8bf7\u6c42\u53c2\u6570:data = [{}]", (Object)data, (Object)e);
            throw new BizException("\u5c48\u81e3\u6c0f\u751f\u6210\u7b7e\u540d\u4e2d\u65ad");
        }
    }

    private Map<String, Object> signParam2(JSONObject data) throws BizException {
        String appId = this.watsonsConfig.getNewAppId();
        String appSecret = this.watsonsConfig.getNewSecret();
        String timestamp = String.valueOf(System.currentTimeMillis() / 1000L);
        String dataStr = data.toJSONString();
        try {
            String sourceStr = appId + appSecret + timestamp + dataStr;
            String sign = MD5.md5(sourceStr).toUpperCase();
            HashMap<String, Object> newParams = new HashMap<String, Object>();
            newParams.put("brandId", this.watsonsConfig.getBrandId());
            newParams.put("channelId", this.watsonsConfig.getChannelId());
            newParams.put("appId", appId);
            newParams.put("timestamp", timestamp);
            newParams.put("sign", sign);
            newParams.put("data", data);
            if (!SpringEnvironmentUtils.isProdEnv()) {
                LOGGER.info("watsonsApi\u83b7\u53d6\u57fa\u7840\u914d\u7f6e:\u52a0\u7b7e\u6570\u636e\uff1a{}\uff0c\u57fa\u7840\u6570\u636e:{}", (Object)sourceStr, (Object)JSON.toJSONString(newParams));
            }
            return newParams;
        }
        catch (Exception e) {
            LOGGER.warn("WatsonsApi-signParam \u53d1\u751f\u5f02\u5e38\uff0c\u8bf7\u6c42\u53c2\u6570:data = [{}]", (Object)data, (Object)e);
            throw new BizException("\u5c48\u81e3\u6c0f\u751f\u6210\u7b7e\u540d\u4e2d\u65ad");
        }
    }

    public HttpRequestBase getSubCreditsMessage(SubCreditsMsgWrapper message) {
        try {
            String url = message.getHttpUrl();
            String host = url.substring(0, url.indexOf(63));
            String params = url.substring(url.indexOf(63) + 1);
            Map<String, String> paramsMap = AssembleTool.getUrlParams(params);
            Date date = new Date();
            JSONObject data = new JSONObject();
            data.put("memberNumber", (Object)paramsMap.get("uid"));
            data.put("productName", (Object)"Point Adjustment_for Duiba Luck Draw Event_A");
            data.put("comments", (Object)"for Duiba Luck Draw Event_A");
            data.put("storeId", (Object)"1");
            data.put("businessDate", (Object)DateUtils.getSecondStr((Date)date));
            data.put("numOfPoint", (Object)paramsMap.get("credits"));
            data.put("txnChannel", (Object)"Web");
            SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmmss");
            data.put("txnNumber", (Object)("WTCCN" + paramsMap.get("uid") + sdf.format(date)));
            Map<String, Object> newParams = this.signParam2(data);
            String paramStr = JSON.toJSONString(newParams);
            if (!SpringEnvironmentUtils.isProdEnv()) {
                LOGGER.info("watsonsApi\u6263\u79ef\u5206\uff0c\u8bf7\u6c42\u6570\u636e:{}", (Object)paramStr);
            }
            return AssembleTool.assembleRequestJson(host, paramStr);
        }
        catch (Exception e) {
            LOGGER.warn("[watsonsApi- \u6784\u5efa\u6263\u79ef\u5206\u53c2\u6570\u5f02\u5e38]error:{}", (Throwable)e);
            return null;
        }
    }

    public String parseCreditsRsp(String body) {
        JSONObject response = JSON.parseObject((String)body);
        JSONObject json = new JSONObject();
        json.put("errorMessage", (Object)response.getString("resultMsg"));
        json.put("bizId", (Object)String.valueOf(System.currentTimeMillis()));
        json.put("status", (Object)(Objects.equals(response.getString("resultCode"), "00000") ? "ok" : "fail"));
        return json.toString();
    }

    public HttpRequestBase getVirtualRequestHttp(SupplierRequest request) {
        String url = request.getHttpUrl();
        String host = url.substring(0, url.indexOf(63));
        request.setHttpUrl(host);
        String params = url.substring(url.indexOf(63) + 1, url.length());
        Map<String, String> urlParams = AssembleTool.getUrlParams(params);
        TreeMap<String, Object> data = new TreeMap<String, Object>();
        data.put("user_id", urlParams.get("uid"));
        data.put("keycodes", Collections.singletonList(urlParams.get("params")));
        data.put("trans_id", urlParams.get("orderNum"));
        data.put("channel", "\u5151\u5427\u6d3b\u52a8");
        TreeMap<String, Object> paramMap = new TreeMap<String, Object>();
        paramMap.put("appId", this.watsonsConfig.getDuibaIdentifier2());
        paramMap.put("certiId", this.watsonsConfig.getCertiId2());
        paramMap.put("date", DateUtils.getSecondStr((Date)new Date()));
        paramMap.put("data", new JSONObject(data));
        LOGGER.info("watsonsApi\u865a\u62df\u5546\u54c1\uff0c\u8bf7\u6c42\u6570\u636e:{}", (Object)JSON.toJSONString(paramMap));
        String sign = WatsonsSignUtil.getSignWithObject(paramMap, this.watsonsConfig.getToken2());
        paramMap.put("sign", sign);
        request.setHttpUrl(host);
        return AssembleTool.assembleRequestJson(request.getHttpUrl(), JSON.toJSONString(paramMap));
    }

    public String getVirtualResponse(String body) {
        if (StringUtils.isBlank((CharSequence)body)) {
            return this.resultFail("\u5c48\u81e3\u6c0f\u865a\u62df\u5546\u54c1\u63a5\u53e3\u54cd\u5e94\u4e3a\u7a7a");
        }
        try {
            JSONObject originJson = JSON.parseObject((String)body);
            Boolean isSuccess = originJson.getBoolean("is_success");
            if (isSuccess.booleanValue()) {
                return this.resultSuccessWithData(originJson.getString("data"));
            }
            return this.resultFail(originJson.getString("message"));
        }
        catch (Exception e) {
            LOGGER.warn("[WatsonsApi-getVirtualRespone]\u5c48\u81e3\u6c0f-\u54cd\u5e94JSON\u89e3\u6790\u9519\u8bef:", (Throwable)e);
            return this.resultFail("\u5c48\u81e3\u6c0f\u54cd\u5e94JSON\u89e3\u6790\u9519\u8bef");
        }
    }

    private String resultFail(String message) {
        JSONObject result = new JSONObject();
        result.put("status", (Object)"fail");
        result.put("errorMessage", (Object)message);
        return result.toJSONString();
    }

    private String resultSuccessWithData(String data) {
        JSONObject result = new JSONObject();
        result.put("status", (Object)"success");
        result.put("data", (Object)data);
        return result.toJSONString();
    }
}

