/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.biz.credits;

import cn.com.duiba.biz.Exception.ThirdpatyException;
import cn.com.duiba.constant.YangShiPinConfig;
import cn.com.duiba.domain.SupplierRequest;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.util.HashMap;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class YangShiPinApi {
    private static final Logger LOGGER = LoggerFactory.getLogger(YangShiPinApi.class);
    @Autowired
    private YangShiPinConfig yangShiPinConfig;

    public Boolean isYangShiPin(Long appId) {
        Set<Long> appIds = this.yangShiPinConfig.getAppIds();
        if (null == appIds) {
            return false;
        }
        return appIds.contains(appId);
    }

    public String parseCreditsResponse(String body) {
        HashMap<String, String> map = new HashMap<String, String>();
        if (StringUtils.isBlank((CharSequence)body)) {
            map.put("status", "fail");
            map.put("errorMessage", "\u592e\u89c6\u9891\u65b0\u589e/\u6263\u51cf\u79ef\u5206\u63a5\u53e3\u8fd4\u56de\u4e3a\u7a7a");
            return JSON.toJSONString(map);
        }
        try {
            JSONObject jsonObject = JSON.parseObject((String)body);
            map.put("status", jsonObject.getJSONObject("data").getString("status"));
            map.put("errorMessage", jsonObject.getJSONObject("data").getString("errorMessage"));
            map.put("bizId", jsonObject.getJSONObject("data").getString("bizId"));
            map.put("credits", jsonObject.getJSONObject("data").getString("credits"));
        }
        catch (Exception e) {
            LOGGER.error("\u592e\u89c6\u9891\uff0c\u79ef\u5206\u5151\u6362\uff0c\u7ed3\u679c\u89e3\u6790\u9519\u8bef:{}", (Object)body, (Object)e);
            map.put("status", "fail");
            map.put("errorMessage", "\u79ef\u5206\u5151\u6362\u63a5\u53e3\u54cd\u5e94\u89e3\u6790\u9519\u8bef");
        }
        return JSON.toJSONString(map);
    }

    public String getVirtualResponse(SupplierRequest message, String body) {
        HashMap<String, String> map = new HashMap<String, String>();
        if (StringUtils.isBlank((CharSequence)body)) {
            throw new ThirdpatyException("\u592e\u89c6\u9891\uff0c\u5145\u503c\u5546\u54c1\u5b9a\u5236\uff0c\u8fd4\u56de\u7ed3\u679c\u4e3a\u7a7a");
        }
        try {
            JSONObject jsonObject = JSON.parseObject((String)body);
            map.put("status", jsonObject.getJSONObject("data").getString("status"));
            map.put("credits", jsonObject.getJSONObject("data").getString("credits"));
            map.put("errorMessage", jsonObject.getJSONObject("data").getString("errorMessage"));
            map.put("supplierBizId", jsonObject.getJSONObject("data").getString("supplierBizId"));
        }
        catch (Exception e) {
            LOGGER.error("\u592e\u89c6\u9891\uff0c\u865a\u62df\u5546\u54c1\u5145\u503c\uff0c\u7ed3\u679c\u89e3\u6790\u9519\u8bef:{}", (Object)body, (Object)e);
            map.put("status", "fail");
            map.put("errorMessage", "\u865a\u62df\u5546\u54c1\u5145\u503c\u63a5\u53e3\u54cd\u5e94\u89e3\u6790\u9519\u8bef");
        }
        return JSON.toJSONString(map);
    }

    public String getResponseNotify(String body) {
        try {
            JSONObject jsonObject = JSON.parseObject((String)body);
            String status = jsonObject.getJSONObject("data").getString("status");
            if (StringUtils.equalsIgnoreCase((CharSequence)status, (CharSequence)"ok")) {
                return "ok";
            }
        }
        catch (Exception e) {
            LOGGER.error("\u592e\u89c6\u9891\uff0c\u5151\u6362\u7ed3\u679c\u901a\u77e5\uff0c\u7ed3\u679c\u89e3\u6790\u9519\u8bef:{}", (Object)body, (Object)e);
        }
        return body;
    }
}

