/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.biz.credits.impl;

import cn.com.duiba.biz.credits.EzrApiService;
import cn.com.duiba.constant.EzrConstant;
import cn.com.duiba.credits.sdk.SignTool;
import cn.com.duiba.dao.AppDAO;
import cn.com.duiba.domain.AppDO;
import cn.com.duiba.domain.SubCreditsMsgWrapper;
import cn.com.duiba.notifycenter.domain.NotifyQueueDO;
import cn.com.duiba.thirdparty.dto.CreditsMessageDto;
import cn.com.duiba.tool.AssembleTool;
import cn.com.duiba.tool.JsonTool;
import cn.com.duiba.wolf.utils.SecurityUtils;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpRequestBase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class EzrApiServiceImpl
implements EzrApiService {
    @Autowired
    private EzrConstant ezrConstant;
    @Autowired
    private AppDAO appDAO;
    private static Logger log = LoggerFactory.getLogger(EzrApiServiceImpl.class);

    @Override
    public Boolean isEzr(Long appId) {
        return this.ezrConstant.getAppIds().contains(appId);
    }

    @Override
    public SubCreditsMsgWrapper getRequestCredits(SubCreditsMsgWrapper subCreditsMsgWrapper) {
        Map params = subCreditsMsgWrapper.getSubCreditsMsg().getAuthParams();
        Map<String, String> authParams = this.basicCredits(false, params);
        subCreditsMsgWrapper.getSubCreditsMsg().setAuthParams(authParams);
        subCreditsMsgWrapper.getSubCreditsMsg().setHttpType(2);
        String url = subCreditsMsgWrapper.getHttpUrl();
        String host = url.indexOf(63) == -1 ? url : url.substring(0, url.indexOf(63));
        subCreditsMsgWrapper.setHttpUrl(host);
        return subCreditsMsgWrapper;
    }

    @Override
    public CreditsMessageDto getAddCreditsMessage(CreditsMessageDto request) {
        Map params = request.getAuthParams();
        Map<String, String> authParams = this.basicCredits(true, params);
        request.setAuthParams(authParams);
        request.setHttpType("post");
        String url = request.getHttpUrl();
        String host = url.indexOf(63) == -1 ? url : url.substring(0, url.indexOf(63));
        request.setHttpUrl(host);
        return request;
    }

    @Override
    public HttpRequestBase getRequestNotify(String notifyUrl, NotifyQueueDO record, AppDO app) {
        HashMap<String, String> authParams = new HashMap<String, String>();
        authParams.put("success", String.valueOf(record.getResult()));
        authParams.put("apk", app.getAppKey());
        authParams.put("appSecret", this.appDAO.getAppSecret(app));
        authParams.put("orderNum", record.getDuibaOrderNum());
        authParams.put("bizId", record.getDeveloperBizId());
        authParams.put("timestamp", String.valueOf(System.currentTimeMillis()));
        authParams.put("uid", record.getPartnerUserId());
        String sign = SignTool.sign(authParams);
        authParams.remove("appSecret");
        authParams.put("sign", sign);
        return new HttpGet(AssembleTool.assembleUrl(notifyUrl, authParams));
    }

    @Override
    public String parseCreditsRsp(String body) {
        JSONObject jsonBody;
        try {
            jsonBody = JSON.parseObject((String)body);
        }
        catch (Exception e) {
            log.info("JSON.parseObject:", (Throwable)e);
            return body;
        }
        JSONObject json = JsonTool.getAllJson(jsonBody);
        HashMap<String, String> duibaDoc = new HashMap<String, String>();
        duibaDoc.put("errorMessage", json.getString("Msg"));
        duibaDoc.put("status", "true".equals(json.getString("Status")) ? "ok" : "fail");
        duibaDoc.put("bizId", json.getString("TransId"));
        duibaDoc.put("credits", json.getString("Bonus"));
        return JsonTool.objectToJson(duibaDoc);
    }

    private Map<String, String> basicCredits(Boolean addOrSub, Map<String, String> params) {
        LinkedHashMap<String, String> authParams = new LinkedHashMap<String, String>();
        JSONObject jsonObject = new JSONObject();
        String orderNum = params.get("orderNum");
        jsonObject.put("TradeNo", (Object)(addOrSub != false ? "A" + orderNum : "B" + orderNum));
        jsonObject.put("Code", (Object)params.get("uid"));
        jsonObject.put("ShopCode", (Object)this.ezrConstant.getXtepShopCode());
        String description = params.get("description");
        jsonObject.put("TransBonus", (Object)(addOrSub != false ? params.get("credits") : "-" + params.get("credits")));
        jsonObject.put("Remark", (Object)(StringUtils.isBlank((CharSequence)description) ? "\u79ef\u5206\u53d8\u52a8" : description));
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyyMMddHHmmss");
        String timestamp = simpleDateFormat.format(new Date());
        authParams.put("AppId", this.ezrConstant.getXtepAppId());
        authParams.put("Timestamp", timestamp);
        authParams.put("Token", this.ezrConstant.getXtepToken());
        String signStr = AssembleTool.paramSplic(authParams);
        String sign = SecurityUtils.encode2StringBySHA((String)signStr).toUpperCase();
        authParams.remove("Token");
        authParams.put("Sign", sign);
        authParams.put("Args", jsonObject.toString());
        authParams.put("AppSystem", this.ezrConstant.getXtepAppSystem());
        return authParams;
    }
}

