/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.biz.credits.strategy.Impl;

import cn.com.duiba.biz.credits.strategy.ApiStrategy;
import cn.com.duiba.config.FudeConfig;
import cn.com.duiba.domain.SubCreditsMsgWrapper;
import cn.com.duiba.notifycenter.domain.NotifyQueueDO;
import cn.com.duiba.thirdparty.dto.CreditsMessageDto;
import cn.com.duiba.tool.JsonTool;
import cn.com.duiba.tool.fude.SignToolJSONObject;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.message.BasicNameValuePair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class FudeApiStrategy
implements ApiStrategy {
    private static final Logger log = LoggerFactory.getLogger(FudeApiStrategy.class);
    private static final String CHARACTER_ENCODE = "UTF-8";
    private static final String APPLICATION_JSON = "application/json";
    private static final String SUCCESS = "Y";
    @Autowired
    private FudeConfig fudeConfig;

    @Override
    public HttpRequestBase getMqSubCreditsHttpRequest(SubCreditsMsgWrapper message) {
        log.info("\u798f\u5fb7\u4eba\u5bff\u6263\u79ef\u5206\u5f00\u59cb");
        return null;
    }

    @Override
    public String parseCreditsRsp(String body, Boolean addCredits, Map<String, String> authParams) {
        HashMap<String, String> duibaDoc = new HashMap<String, String>();
        duibaDoc.put("bizId", authParams.get("orderNum"));
        duibaDoc.put("credits", authParams.get("credits"));
        duibaDoc.put("status", "fail");
        log.info("\u798f\u5fb7\u4eba\u5bff\u52a0\u79ef\u5206\u54cd\u5e94\u4f53\uff1a{}", (Object)body);
        if (addCredits.booleanValue()) {
            JSONObject jsonObject = JSONObject.parseObject((String)body);
            String flag = jsonObject.getString("flag");
            if (SUCCESS.equals(flag)) {
                duibaDoc.put("status", "ok");
                duibaDoc.put("bizId", jsonObject.getString("id"));
            } else {
                log.warn("\u798f\u5fb7\u4eba\u5bff\u52a0\u79ef\u5206\u54cd\u5e94\u5931\u8d25\uff1a{}", (Object)body);
                duibaDoc.put("errorMessage", jsonObject.getString("msg"));
            }
        }
        return JsonTool.objectToJson(duibaDoc);
    }

    @Override
    public HttpRequestBase getAddCreditsMessageRequest(CreditsMessageDto message) {
        try {
            log.info("\u798f\u5fb7\u4eba\u5bff\u52a0\u79ef\u5206\u8bf7\u6c42 :{}", (Object)JSON.toJSONString((Object)message));
            String url = message.getHttpUrl();
            String host = url.substring(0, url.indexOf(63));
            Map authParams = message.getAuthParams();
            HashMap<String, String> param = this.buildParam(authParams);
            log.info("\u798f\u5fb7\u4eba\u5bff\u52a0\u79ef\u5206\u8bf7\u6c42\u5151\u5427uid\uff1a{} \u5b9e\u9645jfUid:{}", authParams.get("uid"), (Object)JSONObject.toJSONString(param));
            String paramStr = JSONObject.toJSONString(param);
            HttpPost httpPost = new HttpPost(host);
            ArrayList<BasicNameValuePair> pairs = new ArrayList<BasicNameValuePair>();
            pairs.add(new BasicNameValuePair("param", paramStr));
            httpPost.setEntity((HttpEntity)new UrlEncodedFormEntity(pairs, CHARACTER_ENCODE));
            return httpPost;
        }
        catch (Exception e) {
            log.warn("\u798f\u5fb7\u4eba\u5bff\u52a0\u79ef\u5206\u8bf7\u6c42\u5f02\u5e38", (Throwable)e);
            return null;
        }
    }

    public HashMap<String, String> buildParam(Map<String, String> authParams) {
        String transfer = authParams.get("transfer");
        String jfUid = JSONObject.parseObject((String)transfer).getString("jfUid");
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("integrals", authParams.get("credits"));
        paramMap.put("uid", jfUid);
        paramMap.put("timestamp", String.valueOf(System.currentTimeMillis() / 1000L));
        Map<String, String> all_params = SignToolJSONObject.getMapToString(this.fudeConfig.getAppSecret(), paramMap);
        String string_to_sign = SignToolJSONObject.stringToSign(all_params);
        String signedStr = SignToolJSONObject.getMD5SignedString(string_to_sign);
        paramMap.put("sign", signedStr);
        HashMap<String, HashMap<String, String>> param = new HashMap<String, HashMap<String, String>>();
        param.put("param", paramMap);
        return paramMap;
    }

    @Override
    public HttpRequestBase getRequestNotify(String notifyUrl, NotifyQueueDO record) {
        log.info("\u798f\u5fb7\u4eba\u5bff\u83b7\u53d6\u5151\u6362\u7ed3\u679c\u901a\u77e5");
        return null;
    }
}

