/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.biz.credits.strategy.Impl;

import cn.com.duiba.biz.Exception.ThirdpatyException;
import cn.com.duiba.biz.credits.strategy.ApiStrategy;
import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.constant.hsbc.HsbcConfig;
import cn.com.duiba.domain.SubCreditsMsgWrapper;
import cn.com.duiba.dto.hsbc.HsbcCreditsRespData;
import cn.com.duiba.dto.hsbc.HsbcUserInfoRespData;
import cn.com.duiba.dto.hsbc.common.HsbcRespBody;
import cn.com.duiba.dto.hsbc.common.HsbcRespData;
import cn.com.duiba.notifycenter.domain.NotifyQueueDO;
import cn.com.duiba.thirdparty.dto.CreditsMessageDto;
import cn.com.duiba.thirdparty.dto.hsbc.UserInfoDto;
import cn.com.duiba.tool.AssembleTool;
import cn.com.duiba.tool.hsbc.HsbcTool;
import cn.hutool.core.convert.Convert;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Maps;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Resource;
import javax.validation.Validator;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.NoHttpResponseException;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.Base64Utils;

@Service
public class HsbcApiStrategy
implements ApiStrategy {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final RequestConfig config = RequestConfig.custom().setConnectTimeout(5000).setSocketTimeout(5000).setConnectionRequestTimeout(500).build();
    private static final int FIVE_SECONDS = 5000;
    private static final int TEN_SECONDS = 5000;
    private static final String STATUS_SUCCESS = "10000";
    @Resource
    private HsbcTool hsbcTool;
    @Resource
    private Validator validator;
    @Autowired
    private HsbcConfig hsbcConfig;
    @Resource(name="shotKeepAliveHttpClient")
    private CloseableHttpClient httpClient;

    @Override
    public HttpRequestBase getMqSubCreditsHttpRequest(SubCreditsMsgWrapper message) {
        String url = this.hsbcTool.getHostName(message.getHttpUrl());
        HttpPost httpPost = new HttpPost(url);
        Map<String, String> originData = AssembleTool.getUrlParams(this.hsbcTool.getParamUrl(message.getHttpUrl()));
        this.log.info("[hsbc]\u51cf\u79ef\u5206originData = \u3010{}\u3011", (Object)JSON.toJSONString(originData));
        Long consumerId = message.getSubCreditsMsg().getConsumerId();
        Long appId = message.getSubCreditsMsg().getAppId();
        try {
            JSONObject bizObject = this.buildSubCreditsBizObject(originData);
            Map<String, Object> body = this.buildRequestBody(bizObject, appId);
            String bodyStr = JSON.toJSONString(body);
            String jwtToken = this.hsbcTool.generateToken(this.buildJwtClaim(bodyStr), appId);
            httpPost.setHeader("Authorization", jwtToken);
            httpPost.setEntity((HttpEntity)new StringEntity(bodyStr, ContentType.APPLICATION_JSON));
            httpPost.setConfig(this.config);
            message.setHttpUrl(url);
            Map authParams = Optional.ofNullable(message.getSubCreditsMsg().getAuthParams()).orElse(Maps.newHashMap());
            body.forEach((key, value) -> {
                if (!authParams.containsKey(key)) {
                    authParams.put(key, String.valueOf(value));
                }
            });
            message.getSubCreditsMsg().setAuthParams(authParams);
            this.log.info("[hsbc] cid = \u3010{}\u3011 orderNum = \u3010{}\u3011 \u51cf\u79ef\u5206\u52a0\u5bc6body = \u3010{}\u3011 token = \u3010{}\u3011", new Object[]{consumerId, originData.get("orderNum"), bodyStr, jwtToken});
            return httpPost;
        }
        catch (Exception e) {
            this.log.error(String.format("[hsbc] cid = \u3010%s\u3011 \u751f\u6210\u6263\u79ef\u5206\u8bf7\u6c42\u5931\u8d25\uff0coriginData = \u3010%s\u3011", consumerId, JSON.toJSONString(originData)), (Throwable)e);
            throw new IllegalStateException(e);
        }
    }

    private JSONObject buildSubCreditsBizObject(Map<String, String> originData) {
        JSONObject businessObject = new JSONObject();
        businessObject.put("uid", (Object)originData.get("uid"));
        businessObject.put("credits", (Object)originData.get("credits"));
        businessObject.put("itemCode", (Object)originData.get("itemCode"));
        businessObject.put("timeStamp", (Object)System.currentTimeMillis());
        businessObject.put("description", (Object)this.subDescription(originData.get("description")));
        businessObject.put("orderNum", (Object)originData.get("orderNum"));
        businessObject.put("type", (Object)originData.get("type"));
        businessObject.put("actualPrice", (Object)originData.get("actualPrice"));
        businessObject.put("productName", (Object)this.subDescription(originData.get("description")));
        return businessObject;
    }

    @Override
    public HttpRequestBase getAddCreditsMessageRequest(CreditsMessageDto message) {
        String url = this.hsbcTool.getHostName(message.getHttpUrl());
        HttpPost httpPost = new HttpPost(url);
        Map<String, String> originData = AssembleTool.getUrlParams(this.hsbcTool.getParamUrl(message.getHttpUrl()));
        this.log.info("[hsbc]\u52a0\u79ef\u5206originData = \u3010{}\u3011", (Object)JSON.toJSONString(originData));
        try {
            JSONObject bizObject = this.buildAddCreditsBizObject(originData, Long.valueOf(message.getConsumerId()));
            Long appId = Long.parseLong(message.getAppId());
            Map<String, Object> body = this.buildRequestBody(bizObject, appId);
            String bodyStr = JSON.toJSONString(body);
            String jwtToken = this.hsbcTool.generateToken(this.buildJwtClaim(bodyStr), appId);
            httpPost.setHeader("Authorization", jwtToken);
            httpPost.setEntity((HttpEntity)new StringEntity(bodyStr, ContentType.APPLICATION_JSON));
            httpPost.setConfig(this.config);
            message.setHttpUrl(url);
            Map authParams = Optional.ofNullable(message.getAuthParams()).orElse(Maps.newHashMap());
            body.forEach((key, value) -> {
                if (!authParams.containsKey(key)) {
                    authParams.put(key, String.valueOf(value));
                }
            });
            message.setAuthParams(authParams);
            this.log.info("[hsbc]cid = \u3010{}\u3011 orderNum = \u3010{}\u3011 \u52a0\u79ef\u5206body = \u3010{}\u3011 token = \u3010{}\u3011", new Object[]{message.getConsumerId(), originData.get("orderNum"), bodyStr, jwtToken});
            return httpPost;
        }
        catch (Exception e) {
            this.log.error(String.format("[hsbc]\u751f\u6210\u52a0\u79ef\u5206\u8bf7\u6c42\u5931\u8d25\uff0coriginData = \u3010%s\u3011", JSON.toJSONString(originData)), (Throwable)e);
            throw new IllegalStateException(e);
        }
    }

    private JSONObject buildAddCreditsBizObject(Map<String, String> originData, Long consumerId) {
        JSONObject bizObject = new JSONObject();
        bizObject.put("uid", (Object)originData.get("uid"));
        bizObject.put("credits", (Object)originData.get("credits"));
        bizObject.put("timeStamp", (Object)System.currentTimeMillis());
        bizObject.put("description", (Object)this.subDescription(originData.get("description")));
        bizObject.put("orderNum", (Object)originData.get("orderNum"));
        bizObject.put("type", (Object)originData.get("type"));
        bizObject.put("approach", (Object)this.subDescription(originData.get("description")));
        return bizObject;
    }

    @Override
    public HttpRequestBase getRequestNotify(String notifyUrl, NotifyQueueDO record) {
        HttpPost httpPost = new HttpPost(notifyUrl);
        String partnerUserId = record.getPartnerUserId();
        try {
            JSONObject bizObject = this.buildNotifyBizObject(record);
            this.log.info("[hsbc]\u901a\u77e5bizObject = \u3010{}\u3011", (Object)JSON.toJSONString((Object)bizObject));
            Map<String, Object> body = this.buildRequestBody(bizObject, record.getAppId());
            String bodyStr = JSON.toJSONString(body);
            httpPost.setHeader("Authorization", this.hsbcTool.generateToken(this.buildJwtClaim(bodyStr), record.getAppId()));
            httpPost.setEntity((HttpEntity)new StringEntity(bodyStr, ContentType.APPLICATION_JSON));
            httpPost.setConfig(this.config);
            return httpPost;
        }
        catch (Exception e) {
            this.log.error(String.format("[hsbc] uid =\u3010%s\u3011 \u751f\u6210notify\u8bf7\u6c42\u5931\u8d25\uff0cNotifyQueueDO = \u3010%s\u3011", partnerUserId, JSON.toJSONString((Object)record)), (Throwable)e);
            throw new IllegalStateException(e);
        }
    }

    private JSONObject buildNotifyBizObject(NotifyQueueDO record) {
        JSONObject bizObject = new JSONObject();
        bizObject.put("uid", (Object)record.getPartnerUserId());
        bizObject.put("success", (Object)this.isExchangeSuccess(record));
        bizObject.put("timeStamp", (Object)System.currentTimeMillis());
        bizObject.put("bizId", (Object)record.getDeveloperBizId());
        bizObject.put("orderNum", (Object)record.getDuibaOrderNum());
        return bizObject;
    }

    public String parseCreditsRspV2(String body, Boolean addCredits, Long appId, Map<String, String> authParams) {
        JSONObject result = new JSONObject();
        try {
            HsbcRespBody hsbcRespBody = this.preCheckAndParse(body);
            if (STATUS_SUCCESS.equals(hsbcRespBody.getCode())) {
                result.put("status", (Object)"ok");
                HsbcCreditsRespData hsbcCreditsRespData = this.decryptAndParseResp(hsbcRespBody, HsbcCreditsRespData.class, appId);
                this.log.info("[hsbc] parseCreditsRspV2 \u8fd4\u56de\u89e3\u5bc6\u4fe1\u606fhsbcCreditsRespData = {}", (Object)JSON.toJSONString((Object)hsbcCreditsRespData));
                if (Objects.nonNull(hsbcCreditsRespData) && Objects.nonNull(hsbcCreditsRespData.getCredits()) && Objects.nonNull(hsbcCreditsRespData.getBizId())) {
                    result.put("credits", (Object)hsbcCreditsRespData.getCredits());
                    result.put("bizId", (Object)hsbcCreditsRespData.getBizId());
                } else {
                    this.log.warn(String.format("[hsbc] authParams = \u3010%s\u3011 \u65e0\u79ef\u5206\u8fd4\u56de hsbcCreditsRespData = \u3010%s\u3011", JSON.toJSONString(authParams), hsbcCreditsRespData));
                }
            } else {
                result.put("status", (Object)"fail");
                result.put("errorMessage", (Object)hsbcRespBody.getMessage());
            }
            return result.toJSONString();
        }
        catch (Exception e) {
            this.log.error("[hsbc] authParams = \u3010" + JSON.toJSONString(authParams) + "\u3011 parseCreditsRsp \u89e3\u6790\u5931\u8d25", (Throwable)e);
            result.put("status", (Object)"fail");
            result.put("errorMessage", (Object)"\u672a\u77e5\u5f02\u5e38");
            return result.toJSONString();
        }
    }

    public String getResponseNotifyV2(Long appId, String body) {
        try {
            HsbcRespBody hsbcRespBody = this.preCheckAndParse(body);
            if (!STATUS_SUCCESS.equals(hsbcRespBody.getCode())) {
                throw new BizException(hsbcRespBody.getMessage());
            }
            String result = this.decryptAndParseResp(hsbcRespBody, String.class, appId);
            this.log.info("[hsbc]\u901a\u77e5\u7ed3\u679c = \u3010{}\u3011", (Object)result);
            if (StringUtils.isBlank((String)result)) {
                throw new BizException("\u8fd4\u56de\u6570\u636e\u4e3a\u7a7a");
            }
            return result;
        }
        catch (Exception e) {
            this.log.error("[hsbc]\u901a\u77e5\u5f02\u5e38", (Throwable)e);
            return "fail";
        }
    }

    private Map<String, Object> buildRequestBody(JSONObject bizObject, Long appId) throws Exception {
        HashMap body = Maps.newHashMap();
        PrivateKey duibaRsaPrivateKey = this.hsbcTool.findDuibaPrivateKeyByAppId(appId);
        body.put("signature", this.hsbcTool.sign(bizObject.toJSONString(), duibaRsaPrivateKey));
        byte[] key = this.hsbcTool.generateAesKey();
        byte[] ivps = this.hsbcTool.generateAesVector();
        String cipherText = this.hsbcTool.aesEncrypt(bizObject.toJSONString(), key, ivps);
        body.put("bizData", cipherText);
        PublicKey hsbcRsaPublicKey = this.hsbcTool.findHsbcPublicKeyByAppId(appId);
        byte[] aesKey = this.hsbcTool.rsaEncrypt(key, hsbcRsaPublicKey);
        String decryptKey = Base64Utils.encodeToString((byte[])aesKey);
        body.put("key", decryptKey);
        byte[] aesIvps = this.hsbcTool.rsaEncrypt(ivps, hsbcRsaPublicKey);
        String decryptIvps = Base64Utils.encodeToString((byte[])aesIvps);
        body.put("iv", decryptIvps);
        return body;
    }

    private HsbcRespBody preCheckAndParse(String body) {
        HsbcRespBody hsbcRespBody = (HsbcRespBody)JSON.parseObject((String)body, HsbcRespBody.class);
        this.checkParameters(hsbcRespBody);
        return hsbcRespBody;
    }

    private <T> T decryptAndParseResp(HsbcRespBody hsbcRespBody, Class<T> t, Long appId) throws Exception {
        PublicKey hsbcRsaPublicKey;
        HsbcRespData hsbcRespData = hsbcRespBody.getHsbcRespData();
        PrivateKey duibaRsaPrivateKey = this.hsbcTool.findDuibaPrivateKeyByAppId(appId);
        byte[] aesKey = Base64Utils.decodeFromString((String)hsbcRespData.getAesKey());
        byte[] key = this.hsbcTool.rsaDecrypt(aesKey, duibaRsaPrivateKey);
        byte[] aesIvps = Base64Utils.decodeFromString((String)hsbcRespData.getAesIvps());
        byte[] ivps = this.hsbcTool.rsaDecrypt(aesIvps, duibaRsaPrivateKey);
        String cipherText = hsbcRespData.getCipherText();
        byte[] cipherContent = Base64Utils.decodeFromString((String)cipherText);
        String bizObjectStr = this.hsbcTool.aesDecrypt(cipherContent, key, ivps);
        String signature = hsbcRespData.getSignature();
        byte[] origin = Base64Utils.decodeFromString((String)signature);
        if (!this.hsbcTool.verifySign(origin, hsbcRsaPublicKey = this.hsbcTool.findHsbcPublicKeyByAppId(appId), bizObjectStr)) {
            throw new BizException("\u7b7e\u540d\u6821\u9a8c\u5931\u8d25");
        }
        if (t == String.class) {
            return (T)Convert.convert(t, (Object)bizObjectStr);
        }
        return (T)JSON.parseObject((String)bizObjectStr, t);
    }

    private boolean isExchangeSuccess(NotifyQueueDO record) {
        return BooleanUtils.isTrue((Boolean)record.getResult());
    }

    private void checkParameters(HsbcRespBody hsbcRespBody) {
        if (Objects.isNull(hsbcRespBody)) {
            throw new IllegalArgumentException("hsbcRespBody\u53c2\u6570\u5f02\u5e38\uff0c\u62a5\u6587=null");
        }
        Set respBodyResult = this.validator.validate((Object)hsbcRespBody, new Class[0]);
        if (CollectionUtils.isNotEmpty((Collection)respBodyResult)) {
            throw new IllegalArgumentException(String.format("hsbcRespBody\u53c2\u6570\u5f02\u5e38\uff0c\u62a5\u6587 = \u3010%s\u3011", JSON.toJSONString((Object)hsbcRespBody)));
        }
        Set respDataResult = this.validator.validate((Object)hsbcRespBody.getHsbcRespData(), new Class[0]);
        if (CollectionUtils.isNotEmpty((Collection)respDataResult)) {
            throw new IllegalArgumentException(String.format("hsbcRespData\u53c2\u6570\u5f02\u5e38\uff0c\u62a5\u6587 = \u3010%s\u3011", JSON.toJSONString((Object)hsbcRespBody)));
        }
    }

    private Map<String, Object> buildJwtClaim(String payload) {
        HashMap claims = Maps.newHashMap();
        claims.put("jti", UUID.randomUUID().toString());
        claims.put("iat", new Date().getTime());
        claims.put("sub", "HSBC and DUIBA LTD");
        claims.put("aud", "Connect/Treasury");
        claims.put("payload_hash", this.hsbcTool.sha256(payload));
        claims.put("payload_hash_alg", "SHA256");
        return claims;
    }

    private String subDescription(String description) {
        if (StringUtils.isBlank((String)description)) {
            return description;
        }
        description = description.replace("\u6d3b\u52a8\u5de5\u5177\uff0c", "");
        description = description.replace("\u6d3b\u52a8\u5de5\u5177,", "");
        description = description.replace("\u5151\u6362\u5b9e\u7269:", "");
        description = description.replace("\u5151\u6362\u5b9e\u7269\uff1a", "");
        return description;
    }

    public UserInfoDto getUserInfo(String hsbcOpenId, String hsbcAppId, Long duibaAppId) {
        String url = this.hsbcTool.findUserInfoUrlByAppId(duibaAppId) + "?requestid=" + HsbcApiStrategy.getRequestId();
        HttpPost httpPost = new HttpPost(url);
        this.log.info("hsbc\u67e5\u8be2\u7528\u6237\u4fe1\u606f\uff0chsbcOpenId={} hsbcAppId={}", (Object)hsbcOpenId, (Object)hsbcAppId);
        JSONObject bizObject = new JSONObject();
        bizObject.put("openId", (Object)hsbcOpenId);
        bizObject.put("appId", (Object)hsbcAppId);
        try {
            Map<String, Object> body = this.buildRequestBody(bizObject, duibaAppId);
            String bodyStr = JSON.toJSONString(body);
            long start = System.currentTimeMillis();
            this.log.info("hsbc\u67e5\u8be2\u7528\u6237\u4fe1\u606f\u8bf7\u6c42\uff0curl={} body={} bizObject={}", new Object[]{url, bodyStr, JSON.toJSONString((Object)bizObject)});
            httpPost.setHeader("Authorization", this.hsbcTool.generateToken(this.buildJwtClaim(bodyStr), duibaAppId));
            httpPost.setEntity((HttpEntity)new StringEntity(bodyStr, ContentType.APPLICATION_JSON));
            httpPost.setConfig(this.config);
            String resp = this.retryRequest(httpPost, 1, bizObject);
            long end = System.currentTimeMillis();
            this.log.info("hsbc\u67e5\u8be2\u7528\u6237\u4fe1\u606f\u54cd\u5e94\uff0curl={} resp={} bizObject={} time={}", new Object[]{url, resp, JSON.toJSONString((Object)bizObject), end - start});
            HsbcRespBody hsbcRespBody = this.preCheckAndParse(resp);
            if (!StringUtils.equals((String)STATUS_SUCCESS, (String)hsbcRespBody.getCode())) {
                this.log.info("hsbc\u67e5\u8be2\u7528\u6237\u4fe1\u606f\u5931\u8d25\uff0cresp={} bizObject={}", (Object)resp, (Object)JSON.toJSONString((Object)bizObject));
                return null;
            }
            HsbcUserInfoRespData data = this.decryptAndParseResp(hsbcRespBody, HsbcUserInfoRespData.class, duibaAppId);
            this.log.info("hsbc\u67e5\u8be2\u7528\u6237\u4fe1\u606f\u54cd\u5e94\u89e3\u5bc6\uff0cdata={} bizObject={}", (Object)JSON.toJSONString((Object)data), (Object)JSON.toJSONString((Object)bizObject));
            UserInfoDto userInfoDto = new UserInfoDto();
            userInfoDto.setUid(data.getUid());
            userInfoDto.setCredits(data.getCredits());
            return userInfoDto;
        }
        catch (Exception e) {
            this.log.error("hsbc\u67e5\u8be2\u7528\u6237\u4fe1\u606f\u8bf7\u6c42\u5f02\u5e38\uff0cbizObject={}", (Object)JSON.toJSONString((Object)bizObject), (Object)e);
            throw new IllegalStateException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String retryRequest(HttpPost httpPost, int exeCount, JSONObject bizObject) {
        if (exeCount > 2) {
            this.log.warn("hsbc\u67e5\u8be2\u7528\u6237\u4fe1\u606f\u8bf7\u6c42\u5f02\u5e38\uff0c\u91cd\u8bd5\u4e00\u6b21\u540e\u4ecd\u5931\u8d25\uff0cbizObject={}", (Object)JSON.toJSONString((Object)bizObject));
            throw new ThirdpatyException("hsbc\u67e5\u8be2\u7528\u6237\u4fe1\u606f\u8bf7\u6c42\u5f02\u5e38");
        }
        try (CloseableHttpResponse response = this.httpClient.execute((HttpUriRequest)httpPost);){
            String resp;
            HttpEntity entity = response.getEntity();
            String string = resp = EntityUtils.toString((HttpEntity)entity, (String)"UTF-8");
            return string;
        }
        catch (NoHttpResponseException e) {
            this.log.warn("hsbc\u67e5\u8be2\u7528\u6237\u4fe1\u606f\u8bf7\u6c42\u65e0\u670d\u52a1\u54cd\u5e94\uff0c\u9700\u91cd\u8bd5\u4e00\u6b21\uff0cbizObject={}", (Object)JSON.toJSONString((Object)bizObject), (Object)e);
            return this.retryRequest(httpPost, ++exeCount, bizObject);
        }
        catch (Exception e) {
            this.log.warn("hsbc\u67e5\u8be2\u7528\u6237\u4fe1\u606f\u8bf7\u6c42\u5f02\u5e38\uff0cbizObject={}", (Object)JSON.toJSONString((Object)bizObject), (Object)e);
            throw new ThirdpatyException("hsbc\u67e5\u8be2\u7528\u6237\u4fe1\u606f\u8bf7\u6c42\u5f02\u5e38");
        }
    }

    private static String getRequestId() {
        return System.currentTimeMillis() + RandomStringUtils.randomNumeric((int)4);
    }
}

