/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.biz.credits.unionpay;

import cn.com.duiba.biz.Exception.ThirdpatyException;
import cn.com.duiba.biz.credits.unionpay.UnionPayRequest;
import cn.com.duiba.constant.UnionPayConstants;
import cn.com.duiba.constant.base.BaseUnionBankConstants;
import cn.com.duiba.domain.SupplierRequest;
import cn.com.duiba.tool.AssembleTool;
import cn.com.duiba.tool.UnionPayBankUtil;
import cn.hutool.core.date.DateUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class BaseUnionPayRequest
implements UnionPayRequest {
    protected static final Logger LOGGER = LoggerFactory.getLogger(BaseUnionPayRequest.class);
    @Autowired
    protected UnionPayConstants unionPayConstants;

    public String getBaseResponse(String body, SupplierRequest request, BaseUnionBankConstants baseUnionBankConstants, String merchantCoding) {
        if (StringUtils.isBlank((CharSequence)merchantCoding) || !merchantCoding.startsWith(baseUnionBankConstants.getVirtualCreditsPre())) {
            return null;
        }
        HashMap<String, String> map = new HashMap<String, String>();
        if (StringUtils.isBlank((CharSequence)body)) {
            throw new ThirdpatyException("\u4e91\u95ea\u4ed8\uff0c\u865a\u62df\u5546\u54c1\u5b9a\u5236\uff0c\u8fd4\u56de\u7ed3\u679c\u4e3a\u7a7a");
        }
        LOGGER.info("\u4e91\u95ea\u4ed8{}\u5b9a\u5236\u8fd4\u56de\u7ed3\u679c\u4e3a:{}", (Object)request.getOrderId(), (Object)(body.length() > 500 ? body.substring(0, 500) : body));
        try {
            JSONObject awardObject;
            String awardId;
            JSONObject jsonObject = JSON.parseObject((String)body);
            map.put("status", Objects.equals("00", jsonObject.getString("resp")) ? "success" : "fail");
            map.put("errorMessage", StringEscapeUtils.unescapeHtml4((String)jsonObject.getString("msg")));
            map.put("supplierBizId", jsonObject.getString("transSeqId"));
            String info = (String)jsonObject.get((Object)"info");
            if (StringUtils.isNotBlank((CharSequence)info) && StringUtils.isNotBlank((CharSequence)(awardId = (String)(awardObject = JSON.parseObject((String)info)).get((Object)"awardId")))) {
                map.put("supplierBizId", awardId);
            }
        }
        catch (Exception e) {
            LOGGER.error("\u4e91\u95ea\u4ed8\uff0c\u865a\u62df\u5546\u54c1\u5b9a\u5236\uff0c\u7ed3\u679c\u89e3\u6790\u9519\u8bef:{}", (Object)body, (Object)e);
            map.put("status", "fail");
            map.put("errorMessage", "\u865a\u62df\u5546\u54c1\u5145\u503c\u63a5\u53e3\u54cd\u5e94\u89e3\u6790\u9519\u8bef");
        }
        return JSON.toJSONString(map);
    }

    @NotNull
    public Map<String, String> buildCommReq(Map<String, String> authParamMap, Map<String, String> params, Long appId) {
        HashMap<String, String> requestParams = new HashMap<String, String>();
        if (StringUtils.isBlank((CharSequence)params.get("devAppId"))) {
            requestParams.put("appId", this.unionPayConstants.getAppConfig(String.valueOf(appId)).getAppId());
        } else {
            requestParams.put("appId", params.get("devAppId"));
        }
        requestParams.put("transSeqId", authParamMap.get("orderNum"));
        requestParams.put("transTs", DateUtil.format((Date)new Date(), (String)"yyyyMMdd"));
        if (StringUtils.isBlank((CharSequence)params.get("devAppId"))) {
            requestParams.put("openId", authParamMap.get("uid"));
        } else {
            requestParams.put("mobile", params.get("mobile"));
        }
        requestParams.put("acctEntityTp", "03");
        requestParams.put("nonceStr", UnionPayBankUtil.createNonceStr());
        requestParams.put("timestamp", Long.toString(System.currentTimeMillis() / 1000L));
        return requestParams;
    }

    public Map<String, String> getUrlParams(SupplierRequest request) {
        String url = request.getHttpUrl();
        String authParams = url.substring(url.indexOf(63) + 1);
        return AssembleTool.getUrlParams(authParams);
    }
}

