/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.biz.virtual.supplier;

import cn.com.duiba.biz.credits.ChangChengApi;
import cn.com.duiba.biz.credits.GangZhongLvApi;
import cn.com.duiba.biz.credits.GuMingApi;
import cn.com.duiba.biz.credits.HaoXiangNiApi;
import cn.com.duiba.biz.credits.HongQiApi;
import cn.com.duiba.biz.credits.HuaweiApi;
import cn.com.duiba.biz.credits.IcbcElifeApi;
import cn.com.duiba.biz.credits.LivatApi;
import cn.com.duiba.biz.credits.MingYuJiuDianApi;
import cn.com.duiba.biz.credits.NewInoherbApi;
import cn.com.duiba.biz.credits.QiaQiaApi;
import cn.com.duiba.biz.credits.ReconciliationBizService;
import cn.com.duiba.biz.credits.ShanXiSecuritiesApi;
import cn.com.duiba.biz.credits.SiChuanLianTongApi;
import cn.com.duiba.biz.credits.SpdBankApi;
import cn.com.duiba.biz.credits.UnionPayApi;
import cn.com.duiba.biz.credits.WatsonsApi;
import cn.com.duiba.biz.credits.WuFangZhaiApi;
import cn.com.duiba.biz.credits.nongzonghang.NongZongHangApi;
import cn.com.duiba.biz.credits.strategy.ApiStrategyRouter;
import cn.com.duiba.boot.utils.SpringEnvironmentUtils;
import cn.com.duiba.domain.RequestTypeEnum;
import cn.com.duiba.domain.SupplierRequest;
import cn.com.duiba.domain.SupplierResponse;
import cn.com.duiba.mq.RocketMQMsgProducer;
import cn.com.duiba.service.CustomService;
import cn.com.duiba.service.HttpAsyncClientPool;
import cn.com.duiba.service.MessageService;
import cn.com.duiba.tool.AssembleTool;
import cn.com.duiba.tool.CaiNiaoTool;
import cn.com.duiba.tool.HttpRequestLog;
import cn.com.duiba.tool.JsonTool;
import cn.com.duiba.wolf.dubbo.DubboResult;
import cn.com.duibaboot.ext.autoconfigure.httpclient.ssre.CanAccessInsideNetwork;
import com.alibaba.fastjson.JSON;
import javax.annotation.Resource;
import org.apache.commons.lang.StringUtils;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.entity.GzipDecompressingEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.concurrent.FutureCallback;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.message.BasicHeader;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class VirtualSupplier {
    private static Logger log = LoggerFactory.getLogger(VirtualSupplier.class);
    @Autowired
    private MessageService messageService;
    @Autowired
    private RocketMQMsgProducer rocketMQMsgProducer;
    @Autowired
    private HttpAsyncClientPool httpAsyncClientPool;
    @Autowired
    private CustomService customService;
    @Autowired
    private GangZhongLvApi gangZhongLvApi;
    @Autowired
    private QiaQiaApi qiaQiaApi;
    @Autowired
    private WuFangZhaiApi wuFangZhaiApi;
    @Autowired
    private NongZongHangApi nongZongHangApi;
    @Autowired
    private LivatApi livatApi;
    @Autowired
    private GuMingApi guMingApi;
    @Autowired
    private WatsonsApi watsonsApi;
    @Autowired
    private UnionPayApi unionPayApi;
    @Autowired
    private ReconciliationBizService reconciliationBizService;
    @Autowired
    private IcbcElifeApi icbcElifeApi;
    @Autowired
    private HuaweiApi huaweiApi;
    @Autowired
    private NewInoherbApi newInoherbApi;
    @Autowired
    private MingYuJiuDianApi mingYuJiuDianApi;
    @Autowired
    private SiChuanLianTongApi siChuanLianTongApi;
    @Autowired
    private HaoXiangNiApi haoXiangNiApi;
    @Autowired
    private ChangChengApi changChengApi;
    @Autowired
    private SpdBankApi spdBankApi;
    @Autowired
    private ShanXiSecuritiesApi shanXiSecuritiesApi;
    @Autowired
    private HongQiApi hongQiApi;
    @Resource(name="httpClient")
    @CanAccessInsideNetwork
    private CloseableHttpClient httpClient;

    public void asyncSubmit(SupplierRequest mes, final String callbackTopic, final String msgTag, final String msgKey) {
        final SupplierRequest message = this.customService.getVirturalRequest(mes);
        HttpRequestBase http = this.getRequest(message);
        this.reconciliationBizService.saveVirtualAddCreditsMsg(message);
        String reqUrl = null == http ? "" : http.getURI().toString();
        HttpRequestLog.logUrl("[action virtual][request bizId " + message.getOrderId() + "][url " + reqUrl + "][authParams " + message.getAuthParams() + "]");
        this.httpAsyncClientPool.submit(message.getAppId(), (HttpUriRequest)http, new FutureCallback<HttpResponse>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void completed(HttpResponse response) {
                SupplierResponse resp = new SupplierResponse();
                try {
                    resp.setOrderId(message.getOrderId());
                    resp.setSupplierOrderId(message.getSupplierOrderId());
                    resp.setSupplierName(message.getSupplierName());
                    resp.setUrl(message.getHttpUrl());
                    resp.setCallbackType("completed");
                    resp.setAppId(message.getAppId());
                    resp.setConsumerId(message.getConsumerId());
                    Header header = response.getEntity().getContentEncoding();
                    String result = header != null && header.toString().contains("gzip") ? EntityUtils.toString((HttpEntity)new GzipDecompressingEntity(response.getEntity())) : EntityUtils.toString((HttpEntity)response.getEntity());
                    String body = VirtualSupplier.this.customService.getVirturalResponse(message, result, callbackTopic, msgTag, msgKey, response);
                    VirtualSupplier.this.reconciliationBizService.updateVirtualAddCreditsRsp(message, body);
                    resp.setBody(HttpRequestLog.subBody(body));
                }
                catch (Exception e) {
                    log.error("VirtualSupplier completed", (Throwable)e);
                }
                finally {
                    VirtualSupplier.this.finallyBlock(message, resp, callbackTopic, msgTag, msgKey, Integer.toString(response.getStatusLine().getStatusCode()));
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void failed(Exception ex) {
                log.error("VirtualSupplier failed orderId:" + message.getOrderId(), (Throwable)ex);
                SupplierResponse resp = new SupplierResponse();
                try {
                    resp.setOrderId(message.getOrderId());
                    resp.setSupplierOrderId(message.getSupplierOrderId());
                    resp.setCallbackType("failed");
                    resp.setAppId(message.getAppId());
                    resp.setConsumerId(message.getConsumerId());
                    resp.setErrorMessage(ex.getClass().getName() + ":" + ex.getMessage());
                }
                catch (Exception e) {
                    log.error("VirtualSupplier completed", (Throwable)e);
                }
                finally {
                    VirtualSupplier.this.finallyBlock(message, resp, callbackTopic, msgTag, msgKey, "");
                }
            }

            public void cancelled() {
                SupplierResponse resp = new SupplierResponse();
                try {
                    resp.setOrderId(message.getOrderId());
                    resp.setSupplierOrderId(message.getSupplierOrderId());
                    resp.setCallbackType("cancelled");
                    resp.setAppId(message.getAppId());
                    resp.setConsumerId(message.getConsumerId());
                }
                catch (Exception e) {
                    log.error("VirtualSupplier cancelled", (Throwable)e);
                }
                finally {
                    VirtualSupplier.this.finallyBlock(message, resp, callbackTopic, msgTag, msgKey, "");
                }
            }
        }, RequestTypeEnum.VIRTUAL);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public DubboResult<String> syncSubmitWithoutDuiba(SupplierRequest supplierRequest) {
        SupplierRequest message = this.customService.getVirturalRequest(supplierRequest);
        HttpRequestBase http = this.getRequest(message);
        log.info("http:{}", (Object)JSON.toJSONString((Object)http));
        String reqUrl = null == http ? "" : http.getURI().toString();
        HttpRequestLog.logUrl("[action virtual][request bizId " + message.getOrderId() + "][messageUrl " + message.getHttpUrl() + "][url " + reqUrl + "][authParams " + message.getAuthParams() + "]");
        try (CloseableHttpResponse response = this.httpClient.execute((HttpUriRequest)http);){
            Header header = response.getEntity().getContentEncoding();
            String result = header != null && header.toString().contains("gzip") ? EntityUtils.toString((HttpEntity)new GzipDecompressingEntity(response.getEntity())) : EntityUtils.toString((HttpEntity)response.getEntity());
            String body = this.customService.getVirturalResponse(message, result, null, null, null, (HttpResponse)response);
            DubboResult dubboResult = DubboResult.successResult((Object)body);
            return dubboResult;
        }
        catch (Exception e) {
            log.warn("\u53d1\u9001\u8bf7\u6c42\u5931\u8d25,supplierRequest={}", (Object)JSON.toJSONString((Object)supplierRequest), (Object)e);
            return DubboResult.failResult((String)"\u53d1\u9001\u8bf7\u6c42\u5931\u8d25");
        }
    }

    private HttpRequestBase getRequest(SupplierRequest message) {
        Object http = null;
        Long appId = Long.valueOf(message.getAppId());
        if (this.customService.isMobike(appId)) {
            http = AssembleTool.assembleRequest(message.getHttpUrl(), message.getAuthParams());
            String time = message.getParams().get("time");
            if (StringUtils.isNotEmpty((String)time)) {
                http.setHeader((Header)new BasicHeader("time", time));
                http.setHeader((Header)new BasicHeader("accesstoken", message.getParams().get("accesstoken")));
            }
        } else if (this.customService.isIqiyi(appId) || this.customService.isWeibo(appId) || this.customService.isPayqb(appId) || this.customService.isSuning(appId)) {
            http = AssembleTool.assembleRequest(message.getHttpUrl(), message.getAuthParams());
        } else if (this.customService.isJiuYangAppid(appId)) {
            String getAutuData = message.getAuthParams().get("getAuthDatas");
            http = getAutuData != null && "ok".equals(getAutuData) ? AssembleTool.assembleRequestForObjectParam(message.getHttpUrl(), message.getAuthDatas()) : AssembleTool.assembleRequest(message.getHttpUrl(), message.getAuthParams());
        } else if (this.customService.isAliTrip(appId)) {
            http = CaiNiaoTool.setHttpRequestHeader(message.getHttpUrl(), message.getAuthParams());
        } else if (this.customService.isHaiDiLao(appId)) {
            http = this.customService.setHaidilaoVirtualHttpHeader(message, (HttpRequestBase)http);
        } else if (this.customService.isFunHeadlines(appId)) {
            http = this.customService.resetFunHeadlinesVirtualHttpType(message, (HttpRequestBase)http);
        } else if (this.customService.isRenrenTv(appId)) {
            http = this.customService.setRenrenVirtualHttpHeader(message);
        } else if (this.customService.isSns(appId)) {
            http = AssembleTool.assembleRequest(message.getHttpUrl(), message.getAuthParams());
            this.customService.setSnsAddHttpHeader(message.getAuthParams(), (HttpRequestBase)http);
        } else if (this.customService.isBeingmate(appId)) {
            http = AssembleTool.assembleRequest(message.getHttpUrl(), message.getAuthParams());
            this.customService.setBeingmateHttpHeader((HttpRequestBase)http);
        } else if (this.gangZhongLvApi.isGangZhongLv(appId).booleanValue()) {
            http = this.gangZhongLvApi.getVirtualRequest(message);
        } else if (this.customService.isWatsons(appId)) {
            if (!SpringEnvironmentUtils.isProdEnv()) {
                log.info("\u5c48\u81e3\u6c0f\u865a\u62df\u5546\u54c1\u5145\u503c\u8bf7\u6c42\u53c2\u6570\uff1a{}", (Object)JSON.toJSONString(message.getAuthParams()));
            }
            http = this.watsonsApi.getVirtualRequestHttp(message);
        } else {
            HttpRequestBase httpRequestBase;
            http = this.customService.isHeBeiMobile(appId) ? AssembleTool.assembleRequestJson(message.getHttpUrl(), JSON.toJSONString(message.getAuthParams())) : (this.qiaQiaApi.isQiaQia(appId) != false ? this.qiaQiaApi.getVirtualRequest(message) : (this.wuFangZhaiApi.isWuFangZhai(appId) != false ? this.wuFangZhaiApi.getVirtualRequest(message) : (this.haoXiangNiApi.isHaoXiangNi(appId) != false ? this.haoXiangNiApi.getVirtualRequest(message) : (this.livatApi.isLivat(appId) ? this.livatApi.getVirtualRequest(message, appId) : (this.nongZongHangApi.isNongZongHang(appId) != false ? this.nongZongHangApi.getVirtualRequestHttp(message) : (this.newInoherbApi.isNewInoherb(appId) ? this.newInoherbApi.getVirtualRequest(message) : (this.guMingApi.isGuMing(appId) ? this.guMingApi.getVirtualRequest(message) : (this.unionPayApi.isUnionPayApp(appId) ? this.unionPayApi.getVirtualRequest(message) : (this.siChuanLianTongApi.isSiChuanLianTongApp(appId) != false ? this.siChuanLianTongApi.getVirtualRequest(message) : (this.icbcElifeApi.isIcbcApp(appId) ? this.icbcElifeApi.getVirtualRequest(message) : (this.mingYuJiuDianApi.isAppId(appId) ? this.mingYuJiuDianApi.getVirtualRequest(message) : (this.changChengApi.isChangCheng(appId) != false ? this.changChengApi.getVirtualRequest(message) : (this.spdBankApi.isPdCardApp(appId) ? this.spdBankApi.getPdCardVirtualRequest(message) : (this.shanXiSecuritiesApi.isAppId(appId) ? this.shanXiSecuritiesApi.getVirtualRequest(message) : (this.hongQiApi.isHongQiAppid(appId) != false ? this.hongQiApi.getVirtualRequest(message) : (ApiStrategyRouter.route(appId) != null ? ((httpRequestBase = ApiStrategyRouter.route(appId).getVirtualRequest(message)) != null ? httpRequestBase : new HttpGet(message.getHttpUrl())) : this.getVirtualRequest(appId, message)))))))))))))))));
        }
        return http;
    }

    private HttpRequestBase getVirtualRequest(Long appId, SupplierRequest message) {
        if (this.huaweiApi.isHuaweiApp(appId)) {
            return this.huaweiApi.getVirtualRequest(message);
        }
        return new HttpGet(message.getHttpUrl());
    }

    private void finallyBlock(SupplierRequest message, SupplierResponse response, String callbackTopic, String msgTag, String msgKey, String code) {
        try {
            boolean needSendMq;
            response.setUrl(message.getHttpUrl());
            response.setSupplierName(message.getSupplierName());
            response.setSupplierOrderId(message.getSupplierOrderId());
            response.setOrderId(message.getOrderId());
            response.setAppId(message.getAppId());
            response.setConsumerId(message.getConsumerId());
            String body = JsonTool.objectToJson(response);
            HttpRequestLog.logUrl("[action virtual] [tag response] [code " + code + "] [bizId " + message.getOrderId() + "] [body " + response.getBody() + "] [callback " + response.getCallbackType() + "]");
            if (this.nongZongHangApi.isNongZongHang(Long.valueOf(message.getAppId())).booleanValue() && !(needSendMq = this.nongZongHangApi.customFinallyBlock(message, response))) {
                return;
            }
            if (callbackTopic.contains("MQ")) {
                this.rocketMQMsgProducer.sendMsg(callbackTopic, msgTag, msgKey, body, false, null);
            } else {
                this.messageService.sendMsg(callbackTopic, msgTag, msgKey, body);
            }
        }
        catch (Exception e) {
            log.error("VirtualSupplier callback:" + message.getOrderId(), (Throwable)e);
        }
    }
}

