/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.constant.hsbc;

import cn.com.duiba.biz.credits.strategy.ApiStrategyRouter;
import cn.com.duiba.biz.credits.strategy.Impl.HsbcApiStrategy;
import com.alibaba.fastjson.JSON;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.security.KeyFactory;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.Map;
import java.util.Set;
import javax.annotation.Resource;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Configuration;
import org.springframework.util.Base64Utils;

@Configuration
@ConfigurationProperties(prefix="hsbc")
public class HsbcConfig
implements InitializingBean {
    @Resource
    private HsbcApiStrategy hsbcApiStrategy;
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private Set<Long> appIds = Sets.newHashSet((Object[])new Long[]{-1L});
    private static final String ALGORITHM_RSA = "RSA";
    private String appId2RsaDuibaPrivateKeyConf;
    private Map<String, String> appId2RsaDuibaPrivateKeyConfMap = Maps.newHashMap();
    private final Map<Long, PrivateKey> appId2RsaDuibaPrivateKeyMap = Maps.newHashMap();
    private String appId2HsbcKeyConf;
    private String appId2JwtKeyConf;
    private String appId2UserInfoUrlConf;
    private Map<String, String> appId2HsbcKeyConfMap = Maps.newHashMap();
    private Map<String, String> appId2JwtKeyConfMap = Maps.newHashMap();
    private Map<String, String> appId2UserInfoUrlMap = Maps.newHashMap();
    private final Map<Long, PublicKey> appId2HsbcPublicKeyMap = Maps.newHashMap();

    public void afterPropertiesSet() {
        ApiStrategyRouter.register(this.appIds, this.hsbcApiStrategy);
        try {
            this.appId2HsbcKeyConfMap = (Map)JSON.parseObject((String)this.appId2HsbcKeyConf, Map.class);
            this.appId2JwtKeyConfMap = (Map)JSON.parseObject((String)this.appId2JwtKeyConf, Map.class);
            this.appId2UserInfoUrlMap = (Map)JSON.parseObject((String)this.appId2UserInfoUrlConf, Map.class);
            this.appId2RsaDuibaPrivateKeyConfMap = (Map)JSON.parseObject((String)this.appId2RsaDuibaPrivateKeyConf, Map.class);
            this.batchGeneratePublicKey();
            this.batchGeneratePrivateKey();
        }
        catch (Exception e) {
            this.log.error("[hsbc] \u79d8\u94a5\u521d\u59cb\u5316\u5931\u8d25", (Throwable)e);
        }
    }

    private PrivateKey generatePrivateKey(String privateKeyConf) throws Exception {
        PKCS8EncodedKeySpec keySpec = new PKCS8EncodedKeySpec(Base64Utils.decodeFromString((String)privateKeyConf));
        KeyFactory keyFactory = KeyFactory.getInstance(ALGORITHM_RSA);
        return keyFactory.generatePrivate(keySpec);
    }

    private PublicKey generatePublicKey(String publicKeyConf) throws Exception {
        X509EncodedKeySpec keySpec = new X509EncodedKeySpec(Base64Utils.decodeFromString((String)publicKeyConf));
        KeyFactory keyFactory = KeyFactory.getInstance(ALGORITHM_RSA);
        return keyFactory.generatePublic(keySpec);
    }

    public boolean isHsbcApp(Long appId) {
        return this.appIds.contains(appId);
    }

    public void batchGeneratePublicKey() throws Exception {
        for (Map.Entry<String, String> entry : this.appId2HsbcKeyConfMap.entrySet()) {
            if (StringUtils.isBlank((String)entry.getValue())) {
                this.log.error(String.format("[hsbc] appId = %s\u516c\u94a5\u914d\u7f6e\u4e3a\u7a7a", entry.getKey()));
                continue;
            }
            this.appId2HsbcPublicKeyMap.put(Long.parseLong(entry.getKey()), this.generatePublicKey(entry.getValue()));
        }
    }

    public void batchGeneratePrivateKey() throws Exception {
        for (Map.Entry<String, String> entry : this.appId2RsaDuibaPrivateKeyConfMap.entrySet()) {
            if (StringUtils.isBlank((String)entry.getValue())) {
                this.log.error(String.format("[hsbc] appId = %s\u79c1\u94a5\u914d\u7f6e\u4e3a\u7a7a", entry.getKey()));
                continue;
            }
            this.appId2RsaDuibaPrivateKeyMap.put(Long.parseLong(entry.getKey()), this.generatePrivateKey(entry.getValue()));
        }
    }

    public Set<Long> getAppIds() {
        return this.appIds;
    }

    public void setAppIds(Set<Long> appIds) {
        this.appIds = appIds;
    }

    public String getAppId2RsaDuibaPrivateKeyConf() {
        return this.appId2RsaDuibaPrivateKeyConf;
    }

    public void setAppId2RsaDuibaPrivateKeyConf(String appId2RsaDuibaPrivateKeyConf) {
        this.appId2RsaDuibaPrivateKeyConf = appId2RsaDuibaPrivateKeyConf;
    }

    public Map<String, String> getAppId2RsaDuibaPrivateKeyConfMap() {
        return this.appId2RsaDuibaPrivateKeyConfMap;
    }

    public void setAppId2RsaDuibaPrivateKeyConfMap(Map<String, String> appId2RsaDuibaPrivateKeyConfMap) {
        this.appId2RsaDuibaPrivateKeyConfMap = appId2RsaDuibaPrivateKeyConfMap;
    }

    public Map<Long, PrivateKey> getAppId2RsaDuibaPrivateKeyMap() {
        return this.appId2RsaDuibaPrivateKeyMap;
    }

    public String getAppId2HsbcKeyConf() {
        return this.appId2HsbcKeyConf;
    }

    public void setAppId2HsbcKeyConf(String appId2HsbcKeyConf) {
        this.appId2HsbcKeyConf = appId2HsbcKeyConf;
    }

    public String getAppId2JwtKeyConf() {
        return this.appId2JwtKeyConf;
    }

    public void setAppId2JwtKeyConf(String appId2JwtKeyConf) {
        this.appId2JwtKeyConf = appId2JwtKeyConf;
    }

    public String getAppId2UserInfoUrlConf() {
        return this.appId2UserInfoUrlConf;
    }

    public void setAppId2UserInfoUrlConf(String appId2UserInfoUrlConf) {
        this.appId2UserInfoUrlConf = appId2UserInfoUrlConf;
    }

    public Map<String, String> getAppId2HsbcKeyConfMap() {
        return this.appId2HsbcKeyConfMap;
    }

    public void setAppId2HsbcKeyConfMap(Map<String, String> appId2HsbcKeyConfMap) {
        this.appId2HsbcKeyConfMap = appId2HsbcKeyConfMap;
    }

    public Map<String, String> getAppId2JwtKeyConfMap() {
        return this.appId2JwtKeyConfMap;
    }

    public void setAppId2JwtKeyConfMap(Map<String, String> appId2JwtKeyConfMap) {
        this.appId2JwtKeyConfMap = appId2JwtKeyConfMap;
    }

    public Map<String, String> getAppId2UserInfoUrlMap() {
        return this.appId2UserInfoUrlMap;
    }

    public void setAppId2UserInfoUrlMap(Map<String, String> appId2UserInfoUrlMap) {
        this.appId2UserInfoUrlMap = appId2UserInfoUrlMap;
    }

    public Map<Long, PublicKey> getAppId2HsbcPublicKeyMap() {
        return this.appId2HsbcPublicKeyMap;
    }
}

