/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.dao.impl;

import cn.com.duiba.constant.DatabaseSchema;
import cn.com.duiba.dao.AppDAO;
import cn.com.duiba.dao.BaseDAO;
import cn.com.duiba.domain.AppDO;
import cn.com.duiba.wolf.perf.timeprofile.DBTimeProfile;
import cn.com.duiba.wolf.utils.BlowfishUtils;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Repository;

@Repository(value="appDAO")
public class AppDAOImpl
extends BaseDAO
implements AppDAO {
    private static Logger log = LoggerFactory.getLogger(AppDAOImpl.class);
    @Value(value="${app.secret.key}")
    private String appSecretKey;
    private Cache<Long, AppDO> appCache = CacheBuilder.newBuilder().expireAfterWrite(1L, TimeUnit.MINUTES).build();

    @Override
    public AppDO findAppSimple(Long id) {
        return (AppDO)this.getSqlSession().selectOne(this.getStamentNameSpace("findAppSimple"), (Object)id);
    }

    @Override
    public String getAppSecret(AppDO app) {
        return BlowfishUtils.decryptBlowfish((String)app.getSecretCode(), (String)this.appSecretKey);
    }

    public String getAppSecretKey() {
        return this.appSecretKey;
    }

    public void setAppSecretKey(String appSecretKey) {
        this.appSecretKey = appSecretKey;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AppDO getAppByCache(final Long appId) {
        try {
            DBTimeProfile.enter((String)"getAppByLocalCache");
            AppDO appDO = (AppDO)this.appCache.get((Object)appId, (Callable)new Callable<AppDO>(){

                @Override
                public AppDO call() throws Exception {
                    return AppDAOImpl.this.findAppSimple(appId);
                }
            });
            return appDO;
        }
        catch (Exception e) {
            log.error("getAppByCache error", (Throwable)e);
            AppDO appDO = this.findAppSimple(appId);
            return appDO;
        }
        finally {
            DBTimeProfile.release();
        }
    }

    @Override
    protected DatabaseSchema chooseSchema() {
        return DatabaseSchema.CREDITS;
    }
}

